/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.ParseException;
import java.text.StringCharacterIterator;
import java.util.LinkedList;

public class ASCIIPropertyListParser {
    public static final char WHITESPACE_SPACE = ' ';
    public static final char WHITESPACE_TAB = '\t';
    public static final char WHITESPACE_NEWLINE = '\n';
    public static final char WHITESPACE_CARRIAGE_RETURN = '\r';
    public static final char ARRAY_BEGIN_TOKEN = '(';
    public static final char ARRAY_END_TOKEN = ')';
    public static final char ARRAY_ITEM_DELIMITER_TOKEN = ',';
    public static final char DICTIONARY_BEGIN_TOKEN = '{';
    public static final char DICTIONARY_END_TOKEN = '}';
    public static final char DICTIONARY_ASSIGN_TOKEN = '=';
    public static final char DICTIONARY_ITEM_DELIMITER_TOKEN = ';';
    public static final char QUOTEDSTRING_BEGIN_TOKEN = '\"';
    public static final char QUOTEDSTRING_END_TOKEN = '\"';
    public static final char QUOTEDSTRING_ESCAPE_TOKEN = '\\';
    public static final char DATA_BEGIN_TOKEN = '<';
    public static final char DATA_END_TOKEN = '>';
    public static final char DATA_GSOBJECT_BEGIN_TOKEN = '*';
    public static final char DATA_GSDATE_BEGIN_TOKEN = 'D';
    public static final char DATA_GSBOOL_BEGIN_TOKEN = 'B';
    public static final char DATA_GSBOOL_TRUE_TOKEN = 'Y';
    public static final char DATA_GSBOOL_FALSE_TOKEN = 'N';
    public static final char DATA_GSINT_BEGIN_TOKEN = 'I';
    public static final char DATA_GSREAL_BEGIN_TOKEN = 'R';
    public static final char DATE_DATE_FIELD_DELIMITER = '-';
    public static final char DATE_TIME_FIELD_DELIMITER = ':';
    public static final char DATE_GS_DATE_TIME_DELIMITER = ' ';
    public static final char DATE_APPLE_DATE_TIME_DELIMITER = 'T';
    public static final char DATE_APPLE_END_TOKEN = 'Z';
    public static final char COMMENT_BEGIN_TOKEN = '/';
    public static final char MULTILINE_COMMENT_SECOND_TOKEN = '*';
    public static final char SINGLELINE_COMMENT_SECOND_TOKEN = '/';
    public static final char MULTILINE_COMMENT_END_TOKEN = '/';
    private byte[] data;
    private int index;
    private static CharsetEncoder asciiEncoder;

    public static NSObject parse(File f) throws IOException, ParseException {
        return ASCIIPropertyListParser.parse(new FileInputStream(f));
    }

    public static NSObject parse(InputStream in) throws ParseException, IOException {
        byte[] buf = PropertyListParser.readAll(in);
        in.close();
        return ASCIIPropertyListParser.parse(buf);
    }

    public static NSObject parse(byte[] bytes) throws ParseException {
        ASCIIPropertyListParser parser = new ASCIIPropertyListParser(bytes);
        return parser.parse();
    }

    protected ASCIIPropertyListParser() {
    }

    private ASCIIPropertyListParser(byte[] propertyListContent) {
        this.data = propertyListContent;
    }

    private boolean acceptSequence(char ... sequence) {
        int i = 0;
        while (i < sequence.length) {
            if (this.data[this.index + i] != sequence[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean accept(char ... acceptableSymbols) {
        boolean symbolPresent = false;
        char[] cArray = acceptableSymbols;
        int n = acceptableSymbols.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (this.data[this.index] == c) {
                symbolPresent = true;
            }
            ++n2;
        }
        return symbolPresent;
    }

    private boolean accept(char acceptableSymbol) {
        return this.data[this.index] == acceptableSymbol;
    }

    private void expect(char ... expectedSymbols) throws ParseException {
        if (!this.accept(expectedSymbols)) {
            String excString = "Expected '" + expectedSymbols[0] + "'";
            int i = 1;
            while (i < expectedSymbols.length) {
                excString = String.valueOf(excString) + " or '" + expectedSymbols[i] + "'";
                ++i;
            }
            excString = String.valueOf(excString) + " but found '" + (char)this.data[this.index] + "'";
            throw new ParseException(excString, this.index);
        }
    }

    private void expect(char expectedSymbol) throws ParseException {
        if (!this.accept(expectedSymbol)) {
            throw new ParseException("Expected '" + expectedSymbol + "' but found '" + (char)this.data[this.index] + "'", this.index);
        }
    }

    private void read(char symbol) throws ParseException {
        this.expect(symbol);
        ++this.index;
    }

    private void skip() {
        ++this.index;
    }

    private void skip(int numSymbols) {
        this.index += numSymbols;
    }

    private void skipWhitespacesAndComments() {
        boolean commentSkipped;
        do {
            commentSkipped = false;
            while (this.accept('\r', '\n', ' ', '\t')) {
                this.skip();
            }
            if (this.acceptSequence('/', '/')) {
                this.skip(2);
                this.readInputUntil('\r', '\n');
                commentSkipped = true;
                continue;
            }
            if (!this.acceptSequence('/', '*')) continue;
            this.skip(2);
            while (true) {
                if (this.acceptSequence('*', '/')) break;
                this.skip();
            }
            this.skip(2);
            commentSkipped = true;
        } while (commentSkipped);
    }

    private String readInputUntil(char ... symbols) {
        String s = "";
        while (!this.accept(symbols)) {
            s = String.valueOf(s) + (char)this.data[this.index];
            this.skip();
        }
        return s;
    }

    private String readInputUntil(char symbol) {
        String s = "";
        while (!this.accept(symbol)) {
            s = String.valueOf(s) + (char)this.data[this.index];
            this.skip();
        }
        return s;
    }

    public NSObject parse() throws ParseException {
        this.index = 0;
        if (this.data.length >= 3 && (this.data[0] & 0xFF) == 239 && (this.data[1] & 0xFF) == 187 && (this.data[2] & 0xFF) == 191) {
            this.skip(3);
        }
        this.skipWhitespacesAndComments();
        this.expect('{', '(', '/');
        try {
            return this.parseObject();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new ParseException("Reached end of input unexpectedly.", this.index);
        }
    }

    private NSObject parseObject() throws ParseException {
        switch (this.data[this.index]) {
            case 40: {
                return this.parseArray();
            }
            case 123: {
                return this.parseDictionary();
            }
            case 60: {
                return this.parseData();
            }
            case 34: {
                String quotedString = this.parseQuotedString();
                if (quotedString.length() == 20 && quotedString.charAt(4) == '-') {
                    try {
                        return new NSDate(quotedString);
                    }
                    catch (Exception ex) {
                        return new NSString(quotedString);
                    }
                }
                return new NSString(quotedString);
            }
        }
        if (this.data[this.index] > 47 && this.data[this.index] < 58) {
            return this.parseDateString();
        }
        String parsedString = this.parseString();
        return new NSString(parsedString);
    }

    private NSArray parseArray() throws ParseException {
        this.skip();
        this.skipWhitespacesAndComments();
        LinkedList<NSObject> objects = new LinkedList<NSObject>();
        while (!this.accept(')')) {
            objects.add(this.parseObject());
            this.skipWhitespacesAndComments();
            if (!this.accept(',')) break;
            this.skip();
            this.skipWhitespacesAndComments();
        }
        this.read(')');
        return new NSArray(objects.toArray(new NSObject[objects.size()]));
    }

    private NSDictionary parseDictionary() throws ParseException {
        this.skip();
        this.skipWhitespacesAndComments();
        NSDictionary dict = new NSDictionary();
        while (!this.accept('}')) {
            String keyString = this.accept('\"') ? this.parseQuotedString() : this.parseString();
            this.skipWhitespacesAndComments();
            this.read('=');
            this.skipWhitespacesAndComments();
            NSObject object = this.parseObject();
            dict.put(keyString, object);
            this.skipWhitespacesAndComments();
            this.read(';');
            this.skipWhitespacesAndComments();
        }
        this.skip();
        return dict;
    }

    private NSObject parseData() throws ParseException {
        NSObject obj = null;
        this.skip();
        if (this.accept('*')) {
            this.skip();
            this.expect('B', 'D', 'I', 'R');
            if (this.accept('B')) {
                this.skip();
                this.expect('Y', 'N');
                obj = this.accept('Y') ? new NSNumber(true) : new NSNumber(false);
                this.skip();
            } else if (this.accept('D')) {
                this.skip();
                String dateString = this.readInputUntil('>');
                obj = new NSDate(dateString);
            } else if (this.accept('I', 'R')) {
                this.skip();
                String numberString = this.readInputUntil('>');
                obj = new NSNumber(numberString);
            }
            this.read('>');
        } else {
            String dataString = this.readInputUntil('>');
            dataString = dataString.replaceAll("\\s+", "");
            int numBytes = dataString.length() / 2;
            byte[] bytes = new byte[numBytes];
            int i = 0;
            while (i < bytes.length) {
                String byteString = dataString.substring(i * 2, i * 2 + 2);
                int byteValue = Integer.parseInt(byteString, 16);
                bytes[i] = (byte)byteValue;
                ++i;
            }
            obj = new NSData(bytes);
            this.skip();
        }
        return obj;
    }

    private NSObject parseDateString() {
        String numericalString = this.parseString();
        if (numericalString.length() > 4 && numericalString.charAt(4) == '-') {
            try {
                return new NSDate(numericalString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new NSString(numericalString);
    }

    private String parseString() {
        return this.readInputUntil(' ', '\t', '\n', '\r', ',', ';', '=', ')');
    }

    private String parseQuotedString() throws ParseException {
        String unescapedString;
        this.skip();
        String quotedString = "";
        boolean unescapedBackslash = true;
        while (this.data[this.index] != 34 || this.data[this.index - 1] == 92 && unescapedBackslash) {
            quotedString = String.valueOf(quotedString) + (char)this.data[this.index];
            if (this.accept('\\')) {
                unescapedBackslash = this.data[this.index - 1] != 92 || !unescapedBackslash;
            }
            this.skip();
        }
        try {
            unescapedString = ASCIIPropertyListParser.parseQuotedString(quotedString);
        }
        catch (Exception ex) {
            throw new ParseException("The quoted string could not be parsed.", this.index);
        }
        this.skip();
        return unescapedString;
    }

    public static synchronized String parseQuotedString(String s) throws UnsupportedEncodingException, CharacterCodingException {
        LinkedList<Byte> strBytes = new LinkedList<Byte>();
        StringCharacterIterator iterator = new StringCharacterIterator(s);
        char c = iterator.current();
        while (iterator.getIndex() < iterator.getEndIndex()) {
            switch (c) {
                case '\\': {
                    byte[] bts;
                    byte[] byArray = bts = ASCIIPropertyListParser.parseEscapedSequence(iterator).getBytes("UTF-8");
                    int n = bts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte b = byArray[n2];
                        strBytes.add(b);
                        ++n2;
                    }
                    break;
                }
                default: {
                    strBytes.add((byte)0);
                    strBytes.add((byte)c);
                }
            }
            c = iterator.next();
        }
        byte[] bytArr = new byte[strBytes.size()];
        int i = 0;
        for (Byte b : strBytes) {
            bytArr[i] = b;
            ++i;
        }
        String result = new String(bytArr, "UTF-8");
        CharBuffer charBuf = CharBuffer.wrap(result);
        if (asciiEncoder == null) {
            asciiEncoder = Charset.forName("ASCII").newEncoder();
        }
        if (asciiEncoder.canEncode((CharSequence)charBuf)) {
            return asciiEncoder.encode(charBuf).asCharBuffer().toString();
        }
        return result;
    }

    private static String parseEscapedSequence(StringCharacterIterator iterator) throws UnsupportedEncodingException {
        char c = iterator.next();
        if (c == '\\') {
            byte[] byArray = new byte[2];
            byArray[1] = 92;
            return new String(byArray, "UTF-8");
        }
        if (c == '\"') {
            byte[] byArray = new byte[2];
            byArray[1] = 34;
            return new String(byArray, "UTF-8");
        }
        if (c == 'b') {
            byte[] byArray = new byte[2];
            byArray[1] = 8;
            return new String(byArray, "UTF-8");
        }
        if (c == 'n') {
            byte[] byArray = new byte[2];
            byArray[1] = 10;
            return new String(byArray, "UTF-8");
        }
        if (c == 'r') {
            byte[] byArray = new byte[2];
            byArray[1] = 13;
            return new String(byArray, "UTF-8");
        }
        if (c == 't') {
            byte[] byArray = new byte[2];
            byArray[1] = 9;
            return new String(byArray, "UTF-8");
        }
        if (c == 'U' || c == 'u') {
            String byte1 = "";
            byte1 = String.valueOf(byte1) + iterator.next();
            byte1 = String.valueOf(byte1) + iterator.next();
            String byte2 = "";
            byte2 = String.valueOf(byte2) + iterator.next();
            byte2 = String.valueOf(byte2) + iterator.next();
            byte[] stringBytes = new byte[]{(byte)Integer.parseInt(byte1, 16), (byte)Integer.parseInt(byte2, 16)};
            return new String(stringBytes, "UTF-8");
        }
        String num = "";
        num = String.valueOf(num) + c;
        num = String.valueOf(num) + iterator.next();
        num = String.valueOf(num) + iterator.next();
        int asciiCode = Integer.parseInt(num, 8);
        byte[] byArray = new byte[2];
        byArray[1] = (byte)asciiCode;
        byte[] stringBytes = byArray;
        return new String(stringBytes, "UTF-8");
    }
}

