/*
 * Decompiled with CFR 0.152.
 */
package mbookbinder.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Stack;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class CompressionUtil {
    private static boolean debug = true;

    public void unzip(File zippedFile) throws IOException {
        this.unzip(zippedFile, Charset.defaultCharset().name());
    }

    public void unzip(File zippedFile, String encoding) throws IOException {
        this.unzip(zippedFile, zippedFile.getParentFile(), encoding);
    }

    public void unzip(File zippedFile, File destDir) throws IOException {
        this.unzip(new FileInputStream(zippedFile), destDir, Charset.defaultCharset().name());
    }

    public void unzip(File zippedFile, File destDir, String encoding) throws IOException {
        this.unzip(new FileInputStream(zippedFile), destDir, encoding);
    }

    public void unzip(InputStream is, File destDir) throws IOException {
        this.unzip(is, destDir, Charset.defaultCharset().name());
    }

    public void unzip(InputStream is, File destDir, String encoding) throws IOException {
        ZipArchiveEntry entry;
        int nWritten = 0;
        byte[] buf = new byte[8192];
        CompressionUtil.ensureDestDir(destDir);
        ZipArchiveInputStream zis = new ZipArchiveInputStream(is, encoding, false);
        while ((entry = zis.getNextZipEntry()) != null) {
            String name = entry.getName();
            File target = new File(destDir, name);
            if (entry.isDirectory()) {
                CompressionUtil.ensureDestDir(target);
                continue;
            }
            target.createNewFile();
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(target));
            while ((nWritten = zis.read(buf)) >= 0) {
                bos.write(buf, 0, nWritten);
            }
            bos.close();
            CompressionUtil.debug("file : " + name);
        }
        zis.close();
    }

    private static void ensureDestDir(File dir) throws IOException {
        if (!dir.exists()) {
            dir.mkdirs();
            CompressionUtil.debug("dir  : " + dir);
        }
    }

    public void zip(File src) throws IOException {
        CompressionUtil.zip(src, Charset.defaultCharset().name(), true);
    }

    public void zip(File src, boolean includeSrc) throws IOException {
        CompressionUtil.zip(src, Charset.defaultCharset().name(), includeSrc);
    }

    public static void zip(File src, String charSetName, boolean includeSrc) throws IOException {
        CompressionUtil.zip(src, src.getParentFile(), charSetName, includeSrc);
    }

    public void zip(File src, OutputStream os) throws IOException {
        CompressionUtil.zip(src, os, Charset.defaultCharset().name(), true);
    }

    public static void zip(File src, File destDir, String charSetName, boolean includeSrc) throws IOException {
        int pos;
        String fileName = src.getName();
        if (!src.isDirectory() && (pos = fileName.lastIndexOf(".")) > 0) {
            fileName = fileName.substring(0, pos);
        }
        fileName = String.valueOf(fileName) + ".zip";
        CompressionUtil.ensureDestDir(destDir);
        File zippedFile = new File(destDir, fileName);
        if (!zippedFile.exists()) {
            zippedFile.createNewFile();
        }
        CompressionUtil.zip(src, new FileOutputStream(zippedFile), charSetName, includeSrc);
    }

    public void zip(File[] filesToZip, OutputStream os, String encoding) {
    }

    public static void zip(File src, OutputStream os, String charsetName, boolean includeSrc) throws IOException {
        File root;
        ZipArchiveOutputStream zos = new ZipArchiveOutputStream(os);
        zos.setEncoding(charsetName);
        byte[] buf = new byte[8192];
        Stack<File> stack = new Stack<File>();
        if (src.isDirectory()) {
            if (includeSrc) {
                stack.push(src);
                root = src.getParentFile();
            } else {
                File[] fs = src.listFiles();
                int i = 0;
                while (i < fs.length) {
                    stack.push(fs[i]);
                    ++i;
                }
                root = src;
            }
        } else {
            stack.push(src);
            root = src.getParentFile();
        }
        while (!stack.isEmpty()) {
            int length;
            File f = (File)stack.pop();
            String name = CompressionUtil.toPath(root, f);
            if (f.isDirectory()) {
                CompressionUtil.debug("dir  : " + name);
                File[] fs = f.listFiles();
                int i = 0;
                while (i < fs.length) {
                    if (fs[i].isDirectory()) {
                        stack.push(fs[i]);
                    } else {
                        stack.add(0, fs[i]);
                    }
                    ++i;
                }
                continue;
            }
            CompressionUtil.debug("file : " + name);
            ZipArchiveEntry ze = new ZipArchiveEntry(name);
            zos.putArchiveEntry(ze);
            FileInputStream fis = new FileInputStream(f);
            while ((length = fis.read(buf, 0, buf.length)) >= 0) {
                zos.write(buf, 0, length);
            }
            fis.close();
            zos.closeArchiveEntry();
        }
        zos.close();
    }

    private static String toPath(File root, File dir) {
        String path = dir.getAbsolutePath();
        if ((path = path.substring(root.getAbsolutePath().length()).replace(File.separatorChar, '/')).startsWith("/")) {
            path = path.substring(1);
        }
        if (dir.isDirectory() && !path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        return path;
    }

    private static void debug(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }
}

