/*
 * Decompiled with CFR 0.152.
 */
package mbookbinder.util;

import com.dd.plist.NSDictionary;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import mbookbinder.data.BindObject;
import mbookbinder.data.GenerateType;
import mbookbinder.data.SectionData;
import mbookbinder.data.TocData;
import mbookbinder.util.CompressionUtil;
import mbookbinder.util.FileUtil;
import mbookbinder.util.ImageUtil;
import mbookbinder.util.XmlParser;

public class GenerateMBook
extends SwingWorker<Void, Void> {
    private String mBookTitle;
    private String mSubTitle;
    private String mAuthor;
    private String mPublisher;
    private String mDescription;
    private File mFileCoverImage;
    private File mFileCoverMovie;
    private String mIOSInAppID;
    private String mInAppStartPage;
    private String mOrientation;
    private boolean mBlockWebbox;
    private boolean mPageCurling;
    private boolean mPageVolumeOff;
    private ArrayList<SectionData> mArySections;
    private ArrayList<TocData> mAryTOC;
    private GenerateType mGenerateType = GenerateType.Only_Zip;
    private File mExportDir;
    private File mBookInfoXml;
    private NSDictionary mBind;
    private JProgressBar mProgress = null;
    private String workResult = "fail";
    private BindObject MBookBinder;

    public GenerateMBook(JProgressBar progress, BindObject binder) {
        this.mProgress = progress;
        this.MBookBinder = binder;
    }

    public GenerateMBook setExportDir(File exportDir) {
        this.mExportDir = exportDir;
        return this;
    }

    public GenerateMBook setBind(NSDictionary bind) {
        this.mBind = bind;
        this.mBookTitle = bind.objectForKey("BookTitle").toString();
        this.mSubTitle = bind.objectForKey("SubTitle").toString();
        this.mAuthor = bind.objectForKey("Author").toString();
        this.mPublisher = bind.objectForKey("Publisher").toString();
        this.mDescription = bind.objectForKey("Description").toString();
        this.mFileCoverImage = new File(bind.objectForKey("CoverPath").toString());
        this.mFileCoverMovie = new File(bind.objectForKey("CoverMovie").toString());
        this.mIOSInAppID = bind.objectForKey("iOSInAppID").toString();
        this.mInAppStartPage = bind.objectForKey("InAppStartPage").toString();
        this.mOrientation = bind.objectForKey("Orientation").toString();
        this.mBlockWebbox = bind.objectForKey("BlockWebbox").toString().equals("1");
        this.mPageCurling = bind.objectForKey("PageCurling").toString().equals("1");
        this.mPageVolumeOff = bind.objectForKey("PageVolumeOff").toString().equals("1");
        this.mArySections = this.MBookBinder.getArySectionData();
        this.mAryTOC = this.MBookBinder.getAryTocData();
        return this;
    }

    public GenerateMBook setGenerateType(GenerateType generateType) {
        this.mGenerateType = generateType;
        return this;
    }

    public void start() {
        this.execute();
    }

    @Override
    protected Void doInBackground() {
        try {
            this.makeBookInfoXml();
            this.moveCoverSource();
            this.moveSection();
            switch (this.mGenerateType) {
                case Only_Zip: {
                    CompressionUtil.zip(this.mExportDir, "UTF-8", true);
                    GenerateMBook.removeDIR(this.mExportDir.getPath());
                    this.mExportDir.delete();
                    break;
                }
                case Only_Dir: {
                    break;
                }
                case Both: {
                    CompressionUtil.zip(this.mExportDir, "UTF-8", true);
                }
            }
        }
        catch (Exception e) {
            GenerateMBook.removeDIR(this.mExportDir.getPath());
            this.mExportDir.delete();
        }
        this.workResult = "Complete";
        return null;
    }

    @Override
    protected void done() {
        super.done();
        this.mProgress.setVisible(false);
        JOptionPane.showMessageDialog(null, "To " + this.mExportDir.toPath() + "\nGenerate " + this.workResult);
    }

    @Override
    protected void process(List<Void> chunks) {
        super.process(chunks);
    }

    private boolean makeBookInfoXml() {
        this.mBookInfoXml = XmlParser.writeBookInfoXml(this.mExportDir, this.mBind, this.MBookBinder);
        return this.mBookInfoXml != null;
    }

    private boolean moveCoverSource() {
        if (this.mFileCoverImage != null && this.mFileCoverImage.exists()) {
            this.checkCopy(this.mFileCoverImage, this.mExportDir, "cover.jpg");
            this.makeScaleImg(this.mFileCoverImage.getPath(), String.valueOf(this.mExportDir.getAbsolutePath()) + File.separator + "medium.jpg", 0.5f);
            this.makeScaleImg(this.mFileCoverImage.getPath(), String.valueOf(this.mExportDir.getAbsolutePath()) + File.separator + "thumb.jpg", 0.25f);
        }
        if (this.mFileCoverMovie != null && this.mFileCoverMovie.exists()) {
            this.checkCopy(this.mFileCoverMovie, this.mExportDir);
        }
        return false;
    }

    private void makeScaleImg(String src, String dest, float scale) {
        File srcF = new File(src);
        File destF = new File(dest);
        try {
            ImageUtil.resize(srcF, destF, scale);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean moveSection() {
        for (SectionData sectionData : this.MBookBinder.getArySectionData()) {
            File sectionDir = new File(sectionData.getPath());
            File exportDir = new File(String.valueOf(this.mExportDir.getAbsolutePath()) + File.separator + sectionDir.getName());
            exportDir.mkdir();
            this.checkCopy(sectionDir, exportDir);
        }
        return false;
    }

    private void checkCopy(File sourceF, File targetF) {
        if (sourceF.isFile()) {
            File temp = new File(String.valueOf(targetF.getAbsolutePath()) + File.separator + sourceF.getName());
            FileUtil.copy(sourceF, temp);
        } else {
            File[] ff;
            File[] fileArray = ff = sourceF.listFiles();
            int n = ff.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                File temp = new File(String.valueOf(targetF.getAbsolutePath()) + File.separator + file.getName());
                if (file.isDirectory()) {
                    temp.mkdir();
                    this.checkCopy(file, temp);
                } else {
                    FileUtil.copy(file, temp);
                }
                ++n2;
            }
        }
    }

    private void checkCopy(File sourceF, File targetF, String rename) {
        File newTagerF = new File(String.valueOf(targetF.getAbsolutePath()) + File.separator + rename);
        FileUtil.copy(sourceF, newTagerF);
    }

    private static void removeDIR(String source) {
        File[] listFile = new File(source).listFiles();
        try {
            if (listFile.length > 0) {
                int i = 0;
                while (i < listFile.length) {
                    if (listFile[i].isFile()) {
                        System.out.println(listFile[i].toString());
                        listFile[i].delete();
                    } else {
                        GenerateMBook.removeDIR(listFile[i].getPath());
                    }
                    listFile[i].delete();
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

