/*
 * Decompiled with CFR 0.152.
 */
package mbookbinder.util;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ImageUtil {
    public static final int RATIO = 0;
    public static final int SAME = -1;

    public static void resize(File src, File dest, float per) throws IOException {
        Image srcImg = null;
        String suffix = src.getName().substring(src.getName().lastIndexOf(46) + 1).toLowerCase();
        srcImg = suffix.equals("bmp") || suffix.equals("png") || suffix.equals("gif") ? ImageIO.read(src) : new ImageIcon(src.toURL()).getImage();
        int srcWidth = (int)((float)((Image)srcImg).getWidth(null) * per);
        int srcHeight = (int)((float)((Image)srcImg).getHeight(null) * per);
        ImageUtil.resize(src, dest, srcWidth, srcHeight);
    }

    public static void resize(File src, File dest, int width, int height) throws IOException {
        double ratio;
        Image srcImg = null;
        String suffix = src.getName().substring(src.getName().lastIndexOf(46) + 1).toLowerCase();
        srcImg = suffix.equals("bmp") || suffix.equals("png") || suffix.equals("gif") ? ImageIO.read(src) : new ImageIcon(src.toURL()).getImage();
        int srcWidth = srcImg.getWidth(null);
        int srcHeight = srcImg.getHeight(null);
        int destWidth = -1;
        int destHeight = -1;
        if (width == -1) {
            destWidth = srcWidth;
        } else if (width > 0) {
            destWidth = width;
        }
        if (height == -1) {
            destHeight = srcHeight;
        } else if (height > 0) {
            destHeight = height;
        }
        if (width == 0 && height == 0) {
            destWidth = srcWidth;
            destHeight = srcHeight;
        } else if (width == 0) {
            ratio = (double)destHeight / (double)srcHeight;
            destWidth = (int)((double)srcWidth * ratio);
        } else if (height == 0) {
            ratio = (double)destWidth / (double)srcWidth;
            destHeight = (int)((double)srcHeight * ratio);
        }
        Image imgTarget = srcImg.getScaledInstance(destWidth, destHeight, 4);
        int[] pixels = new int[destWidth * destHeight];
        PixelGrabber pg = new PixelGrabber(imgTarget, 0, 0, destWidth, destHeight, pixels, 0, destWidth);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
        BufferedImage destImg = new BufferedImage(destWidth, destHeight, 1);
        destImg.setRGB(0, 0, destWidth, destHeight, pixels, 0, destWidth);
        ImageIO.write((RenderedImage)destImg, "jpg", dest);
    }
}

