/*
 * Decompiled with CFR 0.152.
 */
package mbookbinder.util;

import java.util.ArrayList;
import java.util.Collections;
import mbookbinder.data.BindObject;
import mbookbinder.data.SectionData;
import mbookbinder.data.TocData;
import mbookbinder.util.multiReorderableTableModel;

public class SectionTableModel
extends multiReorderableTableModel {
    private String[] tableColumn = new String[]{"Section File Name", "Section Title", "Pages", "PagesSize", "Version"};
    private ArrayList<SectionData> linkedArySectionData;
    private BindObject MBookBinder;

    public SectionTableModel(BindObject binder) {
        this.MBookBinder = binder;
        this.linkedArySectionData = this.MBookBinder.getArySectionData();
        this.fireTableDataChanged();
    }

    public void initRow() {
        this.linkedArySectionData = this.MBookBinder.getArySectionData();
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int column) {
        return this.tableColumn[column];
    }

    @Override
    public int getColumnCount() {
        return this.tableColumn.length;
    }

    @Override
    public int getRowCount() {
        return this.linkedArySectionData.size();
    }

    @Override
    public SectionData getRowAt(int row) {
        return this.linkedArySectionData.get(row);
    }

    @Override
    public Object getValueAt(int row, int col) {
        SectionData retToc = this.linkedArySectionData.get(row);
        switch (col) {
            case 0: {
                return retToc.getName();
            }
            case 1: {
                return retToc.getTitle();
            }
            case 2: {
                return retToc.getNumberOfPages();
            }
            case 3: {
                return retToc.getPageSize();
            }
            case 4: {
                return retToc.getVersion();
            }
        }
        return null;
    }

    @Override
    public Object CloneRow() {
        ArrayList<String> exSectionPathAry = new ArrayList<String>();
        for (SectionData sectionData : this.linkedArySectionData) {
            exSectionPathAry.add(sectionData.getName());
        }
        return exSectionPathAry;
    }

    @Override
    public void reorderEnd(Object exObj) {
        ArrayList<TocData> newTocAry = new ArrayList<TocData>();
        for (SectionData sectionData : this.linkedArySectionData) {
            for (TocData tocData : this.MBookBinder.getAryTocData()) {
                if (!sectionData.getName().equals(tocData.getSectionName())) continue;
                newTocAry.add(tocData);
            }
        }
        this.MBookBinder.setAryTocData(newTocAry);
        this.fireTableDataChanged();
    }

    public void addRow(SectionData sectionData) {
        this.linkedArySectionData.add(sectionData);
        int index = this.linkedArySectionData.size() - 1;
        this.fireTableRowsInserted(index, index);
    }

    @Override
    public void addRowAt(Object sectionData, int index) {
        this.linkedArySectionData.add(index, (SectionData)sectionData);
        this.fireTableRowsInserted(index, index);
    }

    @Override
    public void removeRow(int targetIndex) {
        String removeSectionName = this.linkedArySectionData.remove(targetIndex).getName();
        int index = this.linkedArySectionData.size() - 1;
        this.fireTableRowsDeleted(index, index);
    }

    public void removeRowWithCheckTocAry(int targetIndex) {
        String removeSectionName = this.linkedArySectionData.remove(targetIndex).getName();
        this.MBookBinder.removeTocItemBySectionName(removeSectionName);
        int index = this.linkedArySectionData.size() - 1;
        this.fireTableRowsDeleted(index, index);
    }

    public boolean checkContainsSectionName(SectionData sectiondata) {
        boolean retVal = false;
        for (SectionData tmpSectionData : this.linkedArySectionData) {
            if (!tmpSectionData.getPath().equals(sectiondata.getPath())) continue;
            retVal = true;
        }
        return retVal;
    }

    public void replaceSectionData(SectionData sectionData) {
        for (SectionData tmpSectionData : this.linkedArySectionData) {
            if (!tmpSectionData.getPath().equals(sectionData.getPath())) continue;
            int removeSectionIndex = this.linkedArySectionData.indexOf(tmpSectionData);
            this.linkedArySectionData.set(removeSectionIndex, sectionData);
            System.out.println("ex  : " + tmpSectionData.toString());
            System.out.println("new : " + sectionData.toString());
            this.fireTableDataChanged();
            break;
        }
    }

    public void clear() {
        this.linkedArySectionData = this.MBookBinder.getArySectionData();
        this.fireTableDataChanged();
    }

    @Override
    public void printDebug() {
        System.out.println("============================");
        int i = 0;
        while (i < this.linkedArySectionData.size()) {
            System.out.println(String.valueOf(i) + "_" + this.linkedArySectionData.get(i).getName());
            ++i;
        }
    }

    public void sort() {
        Collections.sort(this.linkedArySectionData);
        this.fireTableDataChanged();
    }
}

