/*
 * Decompiled with CFR 0.152.
 */
package mbookbinder.util;

import java.util.ArrayList;
import javax.swing.JOptionPane;
import mbookbinder.data.BindObject;
import mbookbinder.data.SectionData;
import mbookbinder.data.TocData;
import mbookbinder.util.multiReorderableTableModel;

public class TocDataTableModel
extends multiReorderableTableModel {
    private String[] tableColumn = new String[]{"Toc Title", "Section File Name", "Page No."};
    private ArrayList<TocData> originalAryTocData;
    private ArrayList<TocData> tmpAryTocData;
    private BindObject MBookBinder;

    public TocDataTableModel(BindObject binder) {
        this.MBookBinder = binder;
    }

    public void initRowData(ArrayList<TocData> targetAryTocData) {
        this.originalAryTocData = this.cloneArrayList(targetAryTocData);
        this.tmpAryTocData = this.cloneArrayList(targetAryTocData);
        this.fireTableDataChanged();
    }

    private ArrayList<TocData> cloneArrayList(ArrayList<TocData> list) {
        ArrayList<TocData> clone = new ArrayList<TocData>(list.size());
        for (TocData item : list) {
            clone.add(item.clone());
        }
        return clone;
    }

    @Override
    public Object CloneRow() {
        return null;
    }

    @Override
    public void reorderEnd(Object exObj) {
    }

    public void addRow(TocData tmpTocData) {
        this.originalAryTocData.add(tmpTocData);
        this.tmpAryTocData.add(tmpTocData.clone());
        int index = this.originalAryTocData.size() - 1;
        this.fireTableRowsInserted(index, index);
    }

    @Override
    public void addRowAt(Object sectionData, int index) {
        this.originalAryTocData.add(index, (TocData)sectionData);
        this.tmpAryTocData.add(index, (TocData)sectionData);
        this.fireTableRowsInserted(index, index);
    }

    public void insertRow(int targetIndex, TocData tmpTocData) {
        this.originalAryTocData.set(targetIndex, tmpTocData);
        this.tmpAryTocData.set(targetIndex, tmpTocData.clone());
        this.fireTableRowsInserted(targetIndex, targetIndex);
    }

    @Override
    public TocData getRowAt(int targetIndex) {
        return this.tmpAryTocData.get(targetIndex);
    }

    @Override
    public void removeRow(int targetIndex) {
        System.out.println("B removeRow : ti : " + targetIndex + " ori Size : " + this.originalAryTocData.size() + " tmp Size : " + this.tmpAryTocData.size());
        this.originalAryTocData.remove(targetIndex);
        this.tmpAryTocData.remove(targetIndex);
        System.out.println("A removeRow : ti : " + targetIndex + " ori Size : " + this.originalAryTocData.size() + " tmp Size : " + this.tmpAryTocData.size());
        this.fireTableRowsDeleted(targetIndex - 1, targetIndex - 1);
    }

    public void removeTitleFront(int size) {
        if (size > 0) {
            int i = 0;
            while (i < this.tmpAryTocData.size()) {
                TocData tocData = this.tmpAryTocData.get(i);
                String tocTitle = tocData.getTitle();
                if (tocTitle.length() > size) {
                    tocTitle = tocTitle.substring(size);
                }
                tocData.setTitle(tocTitle);
                this.tmpAryTocData.set(i, tocData);
                this.originalAryTocData.set(i, tocData);
                ++i;
            }
        }
        this.fireTableDataChanged();
    }

    public void removeTitleBack(int size) {
        if (size > 0) {
            int i = 0;
            while (i < this.tmpAryTocData.size()) {
                TocData tocData = this.tmpAryTocData.get(i);
                String tocTitle = tocData.getTitle();
                if (tocTitle.length() > size) {
                    tocTitle = tocTitle.substring(0, tocTitle.length() - size);
                }
                tocData.setTitle(tocTitle);
                this.tmpAryTocData.set(i, tocData);
                this.originalAryTocData.set(i, tocData);
                ++i;
            }
        }
        this.fireTableDataChanged();
    }

    public void resetRow(int targetIndex) {
        this.tmpAryTocData.set(targetIndex, this.originalAryTocData.get(targetIndex).clone());
        this.fireTableRowsUpdated(targetIndex, targetIndex);
    }

    public ArrayList<TocData> getAllRows() {
        return this.cloneArrayList(this.tmpAryTocData);
    }

    @Override
    public int getColumnCount() {
        return this.tableColumn.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.tableColumn[column];
    }

    @Override
    public int getRowCount() {
        return this.tmpAryTocData.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        TocData retToc = this.tmpAryTocData.get(row);
        switch (col) {
            case 0: {
                return retToc.getTitle();
            }
            case 1: {
                return retToc.getSectionName();
            }
            case 2: {
                return String.valueOf(Integer.parseInt(retToc.getPageIndex()) + 1);
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        System.out.println("Setting value at " + rowIndex + "," + columnIndex + " to " + aValue + " (an instance of " + aValue.getClass() + ")");
        TocData retToc = this.tmpAryTocData.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                retToc.setTitle(aValue.toString());
                break;
            }
            case 1: {
                retToc.setSectionName(aValue.toString());
                String sectionName = aValue.toString();
                if (sectionName.contains(".section")) {
                    sectionName = sectionName.substring(0, sectionName.indexOf(".section"));
                }
                retToc.setTitle(sectionName);
                break;
            }
            case 2: {
                if (!retToc.getSectionName().equals("")) {
                    int maxPage = this.getMaxPage(retToc.getSectionName());
                    int tmpPage = Integer.parseInt(aValue.toString().trim());
                    if (maxPage != -1 && tmpPage > 0 && tmpPage <= maxPage) {
                        retToc.setPageIndex(String.valueOf(tmpPage - 1));
                        break;
                    }
                    JOptionPane.showMessageDialog(null, "section Page index must be in 1 ~ " + maxPage + ". ");
                    return;
                }
                JOptionPane.showMessageDialog(null, "section is null");
                return;
            }
        }
        this.tmpAryTocData.set(rowIndex, retToc);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
        this.printDebugData();
    }

    private int getMaxPage(String sectionName) {
        for (SectionData tmpDict : this.MBookBinder.getArySectionData()) {
            if (!tmpDict.getName().equals(sectionName)) continue;
            return Integer.parseInt(tmpDict.getNumberOfPages());
        }
        return -1;
    }

    private void printDebugData() {
        System.out.println("New value of data:");
        int numRows = this.getRowCount();
        int i = 0;
        while (i < numRows) {
            System.out.print("    row " + i + " : ");
            System.out.print(" T_ " + this.originalAryTocData.get(i).getTitle().equals(this.tmpAryTocData.get(i).getTitle()));
            System.out.print("/ S_ " + this.originalAryTocData.get(i).getSectionName().equals(this.tmpAryTocData.get(i).getSectionName()));
            System.out.print("/ P_ " + this.originalAryTocData.get(i).getPageIndex().equals(this.tmpAryTocData.get(i).getPageIndex()));
            System.out.print("/ D_ " + this.originalAryTocData.get(i).getDescription().equals(this.tmpAryTocData.get(i).getDescription()));
            System.out.println();
            ++i;
        }
        System.out.println("--------------------------");
    }

    @Override
    public void printDebug() {
        System.out.println("============================");
        int i = 0;
        while (i < this.tmpAryTocData.size()) {
            System.out.println(String.valueOf(i) + "_" + this.tmpAryTocData.get(i).getSectionName() + " / " + this.originalAryTocData.get(i).getSectionName());
            ++i;
        }
    }
}

