/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jazzlib;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.jazzlib.Inflater;
import net.sf.jazzlib.InflaterInputStream;
import net.sf.jazzlib.ZipConstants;
import net.sf.jazzlib.ZipEntry;
import net.sf.jazzlib.ZipException;

public class ZipFile
implements ZipConstants {
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private final String name;
    private final RandomAccessFile raf;
    private HashMap entries;
    private boolean closed = false;
    private byte[] locBuf = new byte[30];

    public ZipFile(String name) throws ZipException, IOException {
        this.raf = new RandomAccessFile(name, "r");
        this.name = name;
    }

    public ZipFile(File file) throws ZipException, IOException {
        this.raf = new RandomAccessFile(file, "r");
        this.name = file.getPath();
    }

    public ZipFile(File file, int mode) throws ZipException, IOException {
        if ((mode & 4) != 0) {
            throw new IllegalArgumentException("OPEN_DELETE mode not supported yet in net.sf.jazzlib.ZipFile");
        }
        this.raf = new RandomAccessFile(file, "r");
        this.name = file.getPath();
    }

    private final int readLeShort(DataInput di, byte[] b) throws IOException {
        di.readFully(b, 0, 2);
        return b[0] & 0xFF | (b[1] & 0xFF) << 8;
    }

    private final int readLeInt(DataInput di, byte[] b) throws IOException {
        di.readFully(b, 0, 4);
        return b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF | (b[3] & 0xFF) << 8) << 16;
    }

    private final int readLeShort(byte[] b, int off) {
        return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8;
    }

    private final int readLeInt(byte[] b, int off) {
        return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8 | (b[off + 2] & 0xFF | (b[off + 3] & 0xFF) << 8) << 16;
    }

    private void readEntries() throws ZipException, IOException {
        long pos = this.raf.length() - 22L;
        byte[] ebs = new byte[46];
        do {
            if (pos < 0L) {
                throw new ZipException("central directory not found, probably not a zip file: " + this.name);
            }
            this.raf.seek(pos--);
        } while (this.readLeInt(this.raf, ebs) != 101010256);
        if (this.raf.skipBytes(6) != 6) {
            throw new EOFException(this.name);
        }
        int count = this.readLeShort(this.raf, ebs);
        if (this.raf.skipBytes(4) != 4) {
            throw new EOFException(this.name);
        }
        int centralOffset = this.readLeInt(this.raf, ebs);
        this.entries = new HashMap(count + count / 2);
        this.raf.seek(centralOffset);
        byte[] buffer = new byte[16];
        int i = 0;
        while (i < count) {
            this.raf.readFully(ebs);
            if (this.readLeInt(ebs, 0) != 33639248) {
                throw new ZipException("Wrong Central Directory signature: " + this.name);
            }
            int method = this.readLeShort(ebs, 10);
            int dostime = this.readLeInt(ebs, 12);
            int crc = this.readLeInt(ebs, 16);
            int csize = this.readLeInt(ebs, 20);
            int size = this.readLeInt(ebs, 24);
            int nameLen = this.readLeShort(ebs, 28);
            int extraLen = this.readLeShort(ebs, 30);
            int commentLen = this.readLeShort(ebs, 32);
            int offset = this.readLeInt(ebs, 42);
            int needBuffer = Math.max(nameLen, commentLen);
            if (buffer.length < needBuffer) {
                buffer = new byte[needBuffer];
            }
            this.raf.readFully(buffer, 0, nameLen);
            String name = new String(buffer, 0, 0, nameLen);
            ZipEntry entry = new ZipEntry(name);
            entry.setMethod(method);
            entry.setCrc((long)crc & 0xFFFFFFFFL);
            entry.setSize((long)size & 0xFFFFFFFFL);
            entry.setCompressedSize((long)csize & 0xFFFFFFFFL);
            entry.setDOSTime(dostime);
            if (extraLen > 0) {
                byte[] extra = new byte[extraLen];
                this.raf.readFully(extra);
                entry.setExtra(extra);
            }
            if (commentLen > 0) {
                this.raf.readFully(buffer, 0, commentLen);
                entry.setComment(new String(buffer, 0, commentLen));
            }
            entry.offset = offset;
            this.entries.put(name, entry);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.closed = true;
            this.entries = null;
            this.raf.close();
        }
    }

    protected void finalize() throws IOException {
        if (!this.closed && this.raf != null) {
            this.close();
        }
    }

    public Enumeration entries() {
        try {
            return new ZipEntryEnumeration(this.getEntries().values().iterator());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getEntries() throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            if (this.closed) {
                throw new IllegalStateException("ZipFile has closed: " + this.name);
            }
            if (this.entries == null) {
                this.readEntries();
            }
            return this.entries;
        }
    }

    public ZipEntry getEntry(String name) {
        try {
            HashMap entries = this.getEntries();
            ZipEntry entry = (ZipEntry)entries.get(name);
            return entry != null ? (ZipEntry)entry.clone() : null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checkLocalHeader(ZipEntry entry) throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(entry.offset);
            this.raf.readFully(this.locBuf);
            if (this.readLeInt(this.locBuf, 0) != 67324752) {
                throw new ZipException("Wrong Local header signature: " + this.name);
            }
            if (entry.getMethod() != this.readLeShort(this.locBuf, 8)) {
                throw new ZipException("Compression method mismatch: " + this.name);
            }
            if (entry.getName().length() != this.readLeShort(this.locBuf, 26)) {
                throw new ZipException("file name length mismatch: " + this.name);
            }
            int extraLen = entry.getName().length() + this.readLeShort(this.locBuf, 28);
            return entry.offset + 30 + extraLen;
        }
    }

    public InputStream getInputStream(ZipEntry entry) throws IOException {
        String name;
        HashMap entries = this.getEntries();
        ZipEntry zipEntry = (ZipEntry)entries.get(name = entry.getName());
        if (zipEntry == null) {
            throw new NoSuchElementException(name);
        }
        long start = this.checkLocalHeader(zipEntry);
        int method = zipEntry.getMethod();
        BufferedInputStream is = new BufferedInputStream(new PartialInputStream(this.raf, start, zipEntry.getCompressedSize()));
        switch (method) {
            case 0: {
                return is;
            }
            case 8: {
                return new InflaterInputStream(is, new Inflater(true));
            }
        }
        throw new ZipException("Unknown compression method " + method);
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        try {
            return this.getEntries().size();
        }
        catch (IOException ioe) {
            return 0;
        }
    }

    private static class PartialInputStream
    extends InputStream {
        private final RandomAccessFile raf;
        long filepos;
        long end;

        public PartialInputStream(RandomAccessFile raf, long start, long len) {
            this.raf = raf;
            this.filepos = start;
            this.end = start + len;
        }

        public int available() {
            long amount = this.end - this.filepos;
            if (amount > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)amount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            if (this.filepos == this.end) {
                return -1;
            }
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                this.raf.seek(this.filepos++);
                return this.raf.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] b, int off, int len) throws IOException {
            if ((long)len > this.end - this.filepos && (len = (int)(this.end - this.filepos)) == 0) {
                return -1;
            }
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                this.raf.seek(this.filepos);
                int count = this.raf.read(b, off, len);
                if (count > 0) {
                    this.filepos += (long)len;
                }
                return count;
            }
        }

        public long skip(long amount) {
            if (amount < 0L) {
                throw new IllegalArgumentException();
            }
            if (amount > this.end - this.filepos) {
                amount = this.end - this.filepos;
            }
            this.filepos += amount;
            return amount;
        }
    }

    private static class ZipEntryEnumeration
    implements Enumeration {
        private final Iterator elements;

        public ZipEntryEnumeration(Iterator elements) {
            this.elements = elements;
        }

        public boolean hasMoreElements() {
            return this.elements.hasNext();
        }

        public Object nextElement() {
            return ((ZipEntry)this.elements.next()).clone();
        }
    }
}

