/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSSet;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.PropertyListParser;
import com.dd.plist.UID;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public class BinaryPropertyListParser {
    private int majorVersion;
    private int minorVersion;
    private byte[] bytes;
    private int objectRefSize;
    private int[] offsetTable;

    protected BinaryPropertyListParser() {
    }

    public static NSObject parse(byte[] data) throws PropertyListFormatException, UnsupportedEncodingException {
        BinaryPropertyListParser parser = new BinaryPropertyListParser();
        return parser.doParse(data);
    }

    private NSObject doParse(byte[] data) throws PropertyListFormatException, UnsupportedEncodingException {
        this.bytes = data;
        String magic = new String(BinaryPropertyListParser.copyOfRange(this.bytes, 0, 8));
        if (!magic.startsWith("bplist")) {
            throw new IllegalArgumentException("The given data is no binary property list. Wrong magic bytes: " + magic);
        }
        this.majorVersion = magic.charAt(6) - 48;
        this.minorVersion = magic.charAt(7) - 48;
        if (this.majorVersion > 0) {
            throw new IllegalArgumentException("Unsupported binary property list format: v" + this.majorVersion + "." + this.minorVersion + ". " + "Version 1.0 and later are not yet supported.");
        }
        byte[] trailer = BinaryPropertyListParser.copyOfRange(this.bytes, this.bytes.length - 32, this.bytes.length);
        int offsetSize = (int)BinaryPropertyListParser.parseUnsignedInt(trailer, 6, 7);
        this.objectRefSize = (int)BinaryPropertyListParser.parseUnsignedInt(trailer, 7, 8);
        int numObjects = (int)BinaryPropertyListParser.parseUnsignedInt(trailer, 8, 16);
        int topObject = (int)BinaryPropertyListParser.parseUnsignedInt(trailer, 16, 24);
        int offsetTableOffset = (int)BinaryPropertyListParser.parseUnsignedInt(trailer, 24, 32);
        this.offsetTable = new int[numObjects];
        int i = 0;
        while (i < numObjects) {
            this.offsetTable[i] = (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, offsetTableOffset + i * offsetSize, offsetTableOffset + (i + 1) * offsetSize);
            ++i;
        }
        return this.parseObject(topObject);
    }

    public static NSObject parse(InputStream is) throws IOException, PropertyListFormatException {
        byte[] buf = PropertyListParser.readAll(is);
        return BinaryPropertyListParser.parse(buf);
    }

    public static NSObject parse(File f) throws IOException, PropertyListFormatException {
        return BinaryPropertyListParser.parse(new FileInputStream(f));
    }

    private NSObject parseObject(int obj) throws PropertyListFormatException, UnsupportedEncodingException {
        int offset = this.offsetTable[obj];
        byte type = this.bytes[offset];
        int objType = (type & 0xF0) >> 4;
        int objInfo = type & 0xF;
        switch (objType) {
            case 0: {
                switch (objInfo) {
                    case 0: {
                        return null;
                    }
                    case 8: {
                        return new NSNumber(false);
                    }
                    case 9: {
                        return new NSNumber(true);
                    }
                    case 12: {
                        throw new UnsupportedOperationException("The given binary property list contains a URL object. Parsing of this object type is not yet implemented.");
                    }
                    case 13: {
                        throw new UnsupportedOperationException("The given binary property list contains a URL object. Parsing of this object type is not yet implemented.");
                    }
                    case 14: {
                        throw new UnsupportedOperationException("The given binary property list contains a UUID object. Parsing of this object type is not yet implemented.");
                    }
                }
                throw new PropertyListFormatException("The given binary property list contains an object of unknown type (" + objType + ")");
            }
            case 1: {
                int length = (int)Math.pow(2.0, objInfo);
                return new NSNumber(this.bytes, offset + 1, offset + 1 + length, 0);
            }
            case 2: {
                int length = (int)Math.pow(2.0, objInfo);
                return new NSNumber(this.bytes, offset + 1, offset + 1 + length, 1);
            }
            case 3: {
                if (objInfo != 3) {
                    throw new PropertyListFormatException("The given binary property list contains a date object of an unknown type (" + objInfo + ")");
                }
                return new NSDate(this.bytes, offset + 1, offset + 9);
            }
            case 4: {
                int[] lengthAndOffset = this.readLengthAndOffset(objInfo, offset);
                int length = lengthAndOffset[0];
                int dataOffset = lengthAndOffset[1];
                return new NSData(BinaryPropertyListParser.copyOfRange(this.bytes, offset + dataOffset, offset + dataOffset + length));
            }
            case 5: {
                int[] lengthAndOffset = this.readLengthAndOffset(objInfo, offset);
                int length = lengthAndOffset[0];
                int strOffset = lengthAndOffset[1];
                return new NSString(this.bytes, offset + strOffset, offset + strOffset + length, "ASCII");
            }
            case 6: {
                int[] lengthAndOffset = this.readLengthAndOffset(objInfo, offset);
                int characters = lengthAndOffset[0];
                int strOffset = lengthAndOffset[1];
                int length = characters * 2;
                return new NSString(this.bytes, offset + strOffset, offset + strOffset + length, "UTF-16BE");
            }
            case 7: {
                int[] lengthAndOffset = this.readLengthAndOffset(objInfo, offset);
                int strOffset = lengthAndOffset[1];
                int characters = lengthAndOffset[0];
                int length = this.calculateUtf8StringLength(this.bytes, offset + strOffset, characters);
                return new NSString(this.bytes, offset + strOffset, offset + strOffset + length, "UTF-8");
            }
            case 8: {
                int length = objInfo + 1;
                return new UID(String.valueOf(obj), BinaryPropertyListParser.copyOfRange(this.bytes, offset + 1, offset + 1 + length));
            }
            case 10: {
                int[] lengthAndOffset = this.readLengthAndOffset(objInfo, offset);
                int length = lengthAndOffset[0];
                int arrayOffset = lengthAndOffset[1];
                NSArray array = new NSArray(length);
                int i = 0;
                while (i < length) {
                    int objRef = (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, offset + arrayOffset + i * this.objectRefSize, offset + arrayOffset + (i + 1) * this.objectRefSize);
                    array.setValue(i, this.parseObject(objRef));
                    ++i;
                }
                return array;
            }
            case 11: {
                int[] lengthAndOffset = this.readLengthAndOffset(objInfo, offset);
                int length = lengthAndOffset[0];
                int contentOffset = lengthAndOffset[1];
                NSSet set = new NSSet(true);
                int i = 0;
                while (i < length) {
                    int objRef = (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, offset + contentOffset + i * this.objectRefSize, offset + contentOffset + (i + 1) * this.objectRefSize);
                    set.addObject(this.parseObject(objRef));
                    ++i;
                }
                return set;
            }
            case 12: {
                int[] lengthAndOffset = this.readLengthAndOffset(objInfo, offset);
                int length = lengthAndOffset[0];
                int contentOffset = lengthAndOffset[1];
                NSSet set = new NSSet();
                int i = 0;
                while (i < length) {
                    int objRef = (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, offset + contentOffset + i * this.objectRefSize, offset + contentOffset + (i + 1) * this.objectRefSize);
                    set.addObject(this.parseObject(objRef));
                    ++i;
                }
                return set;
            }
            case 13: {
                int[] lengthAndOffset = this.readLengthAndOffset(objInfo, offset);
                int length = lengthAndOffset[0];
                int contentOffset = lengthAndOffset[1];
                NSDictionary dict = new NSDictionary();
                int i = 0;
                while (i < length) {
                    int keyRef = (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, offset + contentOffset + i * this.objectRefSize, offset + contentOffset + (i + 1) * this.objectRefSize);
                    int valRef = (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, offset + contentOffset + length * this.objectRefSize + i * this.objectRefSize, offset + contentOffset + length * this.objectRefSize + (i + 1) * this.objectRefSize);
                    NSObject key = this.parseObject(keyRef);
                    NSObject val = this.parseObject(valRef);
                    assert (key != null);
                    dict.put(key.toString(), val);
                    ++i;
                }
                return dict;
            }
        }
        throw new PropertyListFormatException("The given binary property list contains an object of unknown type (" + objType + ")");
    }

    private int[] readLengthAndOffset(int objInfo, int offset) {
        int lengthValue = objInfo;
        int offsetValue = 1;
        if (objInfo == 15) {
            byte int_type = this.bytes[offset + 1];
            int intType = (int_type & 0xF0) >> 4;
            if (intType != 1) {
                System.err.println("BinaryPropertyListParser: Length integer has an unexpected type" + intType + ". Attempting to parse anyway...");
            }
            int intInfo = int_type & 0xF;
            int intLength = (int)Math.pow(2.0, intInfo);
            offsetValue = 2 + intLength;
            lengthValue = intLength < 3 ? (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, offset + 2, offset + 2 + intLength) : new BigInteger(BinaryPropertyListParser.copyOfRange(this.bytes, offset + 2, offset + 2 + intLength)).intValue();
        }
        return new int[]{lengthValue, offsetValue};
    }

    private int calculateUtf8StringLength(byte[] bytes, int offset, int numCharacters) {
        int length = 0;
        int i = 0;
        while (i < numCharacters) {
            int tempOffset = offset + length;
            if (bytes.length <= tempOffset) {
                return numCharacters;
            }
            if (bytes[tempOffset] < 128) {
                ++length;
            }
            if (bytes[tempOffset] < 194) {
                return numCharacters;
            }
            if (bytes[tempOffset] < 224) {
                if ((bytes[tempOffset + 1] & 0xC0) != 128) {
                    return numCharacters;
                }
                length += 2;
            } else if (bytes[tempOffset] < 240) {
                if ((bytes[tempOffset + 1] & 0xC0) != 128 || (bytes[tempOffset + 2] & 0xC0) != 128) {
                    return numCharacters;
                }
                length += 3;
            } else if (bytes[tempOffset] < 245) {
                if ((bytes[tempOffset + 1] & 0xC0) != 128 || (bytes[tempOffset + 2] & 0xC0) != 128 || (bytes[tempOffset + 3] & 0xC0) != 128) {
                    return numCharacters;
                }
                length += 4;
            }
            ++i;
        }
        return length;
    }

    public static long parseUnsignedInt(byte[] bytes) {
        return BinaryPropertyListParser.parseUnsignedInt(bytes, 0, bytes.length);
    }

    public static long parseUnsignedInt(byte[] bytes, int startIndex, int endIndex) {
        long l = 0L;
        int i = startIndex;
        while (i < endIndex) {
            l <<= 8;
            l |= (long)(bytes[i] & 0xFF);
            ++i;
        }
        return l &= 0xFFFFFFFFL;
    }

    public static long parseLong(byte[] bytes) {
        return BinaryPropertyListParser.parseLong(bytes, 0, bytes.length);
    }

    public static long parseLong(byte[] bytes, int startIndex, int endIndex) {
        long l = 0L;
        int i = startIndex;
        while (i < endIndex) {
            l <<= 8;
            l |= (long)(bytes[i] & 0xFF);
            ++i;
        }
        return l;
    }

    public static double parseDouble(byte[] bytes) {
        return BinaryPropertyListParser.parseDouble(bytes, 0, bytes.length);
    }

    public static double parseDouble(byte[] bytes, int startIndex, int endIndex) {
        if (endIndex - startIndex == 8) {
            return Double.longBitsToDouble(BinaryPropertyListParser.parseLong(bytes, startIndex, endIndex));
        }
        if (endIndex - startIndex == 4) {
            return Float.intBitsToFloat((int)BinaryPropertyListParser.parseLong(bytes, startIndex, endIndex));
        }
        throw new IllegalArgumentException("endIndex (" + endIndex + ") - startIndex (" + startIndex + ") != 4 or 8");
    }

    public static byte[] copyOfRange(byte[] src, int startIndex, int endIndex) {
        int length = endIndex - startIndex;
        if (length < 0) {
            throw new IllegalArgumentException("startIndex (" + startIndex + ")" + " > endIndex (" + endIndex + ")");
        }
        byte[] dest = new byte[length];
        System.arraycopy(src, startIndex, dest, 0, length);
        return dest;
    }
}

