/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.NSSet;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class BinaryPropertyListWriter {
    public static final int VERSION_00 = 0;
    public static final int VERSION_10 = 10;
    public static final int VERSION_15 = 15;
    public static final int VERSION_20 = 20;
    private int version = 0;
    private OutputStream out;
    private long count;
    private Map<NSObject, Integer> idMap = new HashMap<NSObject, Integer>();
    private int idSizeInBytes;

    private static int getMinimumRequiredVersion(NSObject root) {
        int minVersion;
        block7: {
            block8: {
                block6: {
                    minVersion = 0;
                    if (root == null) {
                        minVersion = 10;
                    }
                    if (!(root instanceof NSDictionary)) break block6;
                    NSDictionary dict = (NSDictionary)root;
                    for (NSObject o : dict.getHashMap().values()) {
                        int v = BinaryPropertyListWriter.getMinimumRequiredVersion(o);
                        if (v <= minVersion) continue;
                        minVersion = v;
                    }
                    break block7;
                }
                if (!(root instanceof NSArray)) break block8;
                NSArray array = (NSArray)root;
                NSObject[] nSObjectArray = array.getArray();
                int n = nSObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NSObject o = nSObjectArray[n2];
                    int v = BinaryPropertyListWriter.getMinimumRequiredVersion(o);
                    if (v > minVersion) {
                        minVersion = v;
                    }
                    ++n2;
                }
                break block7;
            }
            if (!(root instanceof NSSet)) break block7;
            minVersion = 10;
            NSSet set = (NSSet)root;
            NSObject[] nSObjectArray = set.allObjects();
            int n = nSObjectArray.length;
            int n3 = 0;
            while (n3 < n) {
                NSObject o = nSObjectArray[n3];
                int v = BinaryPropertyListWriter.getMinimumRequiredVersion(o);
                if (v > minVersion) {
                    minVersion = v;
                }
                ++n3;
            }
        }
        return minVersion;
    }

    public static void write(File file, NSObject root) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        BinaryPropertyListWriter.write(out, root);
        ((OutputStream)out).close();
    }

    public static void write(OutputStream out, NSObject root) throws IOException {
        int minVersion = BinaryPropertyListWriter.getMinimumRequiredVersion(root);
        if (minVersion > 0) {
            String versionString = minVersion == 10 ? "v1.0" : (minVersion == 15 ? "v1.5" : (minVersion == 20 ? "v2.0" : "v0.0"));
            throw new IOException("The given property list structure cannot be saved. The required version of the binary format (" + versionString + ") is not yet supported.");
        }
        BinaryPropertyListWriter w = new BinaryPropertyListWriter(out, minVersion);
        w.write(root);
    }

    public static byte[] writeToArray(NSObject root) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        BinaryPropertyListWriter.write(bout, root);
        return bout.toByteArray();
    }

    BinaryPropertyListWriter(OutputStream outStr) throws IOException {
        this.out = new BufferedOutputStream(outStr);
    }

    BinaryPropertyListWriter(OutputStream outStr, int version) throws IOException {
        this.version = version;
        this.out = new BufferedOutputStream(outStr);
    }

    void write(NSObject root) throws IOException {
        this.write(new byte[]{98, 112, 108, 105, 115, 116});
        switch (this.version) {
            case 0: {
                this.write(new byte[]{48, 48});
                break;
            }
            case 10: {
                this.write(new byte[]{49, 48});
                break;
            }
            case 15: {
                this.write(new byte[]{49, 53});
                break;
            }
            case 20: {
                this.write(new byte[]{50, 48});
            }
        }
        root.assignIDs(this);
        this.idSizeInBytes = BinaryPropertyListWriter.computeIdSizeInBytes(this.idMap.size());
        long[] offsets = new long[this.idMap.size()];
        for (Map.Entry<NSObject, Integer> entry : this.idMap.entrySet()) {
            NSObject obj = entry.getKey();
            int id = entry.getValue();
            offsets[id] = this.count;
            if (obj == null) {
                this.write(0);
                continue;
            }
            obj.toBinary(this);
        }
        long offsetTableOffset = this.count;
        int offsetSizeInBytes = this.computeOffsetSizeInBytes(this.count);
        long[] lArray = offsets;
        int n = offsets.length;
        int n2 = 0;
        while (n2 < n) {
            long offset = lArray[n2];
            this.writeBytes(offset, offsetSizeInBytes);
            ++n2;
        }
        if (this.version != 15) {
            this.write(new byte[6]);
            this.write(offsetSizeInBytes);
            this.write(this.idSizeInBytes);
            this.writeLong(this.idMap.size());
            this.writeLong(this.idMap.get(root).intValue());
            this.writeLong(offsetTableOffset);
        }
        this.out.flush();
    }

    void assignID(NSObject obj) {
        if (!this.idMap.containsKey(obj)) {
            this.idMap.put(obj, this.idMap.size());
        }
    }

    int getID(NSObject obj) {
        return this.idMap.get(obj);
    }

    private static int computeIdSizeInBytes(int numberOfIds) {
        if (numberOfIds < 256) {
            return 1;
        }
        if (numberOfIds < 65536) {
            return 2;
        }
        return 4;
    }

    private int computeOffsetSizeInBytes(long maxOffset) {
        if (maxOffset < 256L) {
            return 1;
        }
        if (maxOffset < 65536L) {
            return 2;
        }
        if (maxOffset < 0x100000000L) {
            return 4;
        }
        return 8;
    }

    void writeIntHeader(int kind, int value) throws IOException {
        assert (value >= 0);
        if (value < 15) {
            this.write((kind << 4) + value);
        } else if (value < 256) {
            this.write((kind << 4) + 15);
            this.write(16);
            this.writeBytes(value, 1);
        } else if (value < 65536) {
            this.write((kind << 4) + 15);
            this.write(17);
            this.writeBytes(value, 2);
        } else {
            this.write((kind << 4) + 15);
            this.write(18);
            this.writeBytes(value, 4);
        }
    }

    void write(int b) throws IOException {
        this.out.write(b);
        ++this.count;
    }

    void write(byte[] bytes) throws IOException {
        this.out.write(bytes);
        this.count += (long)bytes.length;
    }

    void writeBytes(long value, int bytes) throws IOException {
        int i = bytes - 1;
        while (i >= 0) {
            this.write((int)(value >> 8 * i));
            --i;
        }
    }

    void writeID(int id) throws IOException {
        this.writeBytes(id, this.idSizeInBytes);
    }

    void writeLong(long value) throws IOException {
        this.writeBytes(value, 8);
    }

    void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(value));
    }
}

