/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSData;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import java.io.IOException;
import java.util.Arrays;

public class NSArray
extends NSObject {
    private NSObject[] array;

    public NSArray(int length) {
        this.array = new NSObject[length];
    }

    public NSArray(NSObject ... a) {
        this.array = a;
    }

    public NSObject objectAtIndex(int i) {
        return this.array[i];
    }

    public void remove(int i) {
        if (i >= this.array.length || i < 0) {
            throw new ArrayIndexOutOfBoundsException("invalid index:" + i + ";the array length is " + this.array.length);
        }
        NSObject[] newArray = new NSObject[this.array.length - 1];
        System.arraycopy(this.array, 0, newArray, 0, i);
        System.arraycopy(this.array, i + 1, newArray, i, this.array.length - i - 1);
        this.array = newArray;
    }

    public void setValue(int key, Object value) {
        this.array[key] = NSObject.wrap(value);
    }

    public NSObject[] getArray() {
        return this.array;
    }

    public int count() {
        return this.array.length;
    }

    public boolean containsObject(Object obj) {
        NSObject nso = NSObject.wrap(obj);
        NSObject[] nSObjectArray = this.array;
        int n = this.array.length;
        int n2 = 0;
        while (n2 < n) {
            NSObject elem = nSObjectArray[n2];
            if (elem == null ? obj == null : elem.equals(nso)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int indexOfObject(Object obj) {
        NSObject nso = NSObject.wrap(obj);
        int i = 0;
        while (i < this.array.length) {
            if (this.array[i].equals(nso)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOfIdenticalObject(Object obj) {
        NSObject nso = NSObject.wrap(obj);
        int i = 0;
        while (i < this.array.length) {
            if (this.array[i] == nso) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public NSObject lastObject() {
        return this.array[this.array.length - 1];
    }

    public NSObject[] objectsAtIndexes(int ... indexes) {
        NSObject[] result = new NSObject[indexes.length];
        Arrays.sort(indexes);
        int i = 0;
        while (i < indexes.length) {
            result[i] = this.array[indexes[i]];
            ++i;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(NSArray.class)) {
            return Arrays.equals(((NSArray)obj).getArray(), this.array);
        }
        NSObject nso = NSObject.wrap(obj);
        if (nso.getClass().equals(NSArray.class)) {
            return Arrays.equals(((NSArray)nso).getArray(), this.array);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Arrays.deepHashCode(this.array);
        return hash;
    }

    @Override
    void toXML(StringBuilder xml, int level) {
        this.indent(xml, level);
        xml.append("<array>");
        xml.append(NSObject.NEWLINE);
        NSObject[] nSObjectArray = this.array;
        int n = this.array.length;
        int n2 = 0;
        while (n2 < n) {
            NSObject o = nSObjectArray[n2];
            o.toXML(xml, level + 1);
            xml.append(NSObject.NEWLINE);
            ++n2;
        }
        this.indent(xml, level);
        xml.append("</array>");
    }

    @Override
    void assignIDs(BinaryPropertyListWriter out) {
        super.assignIDs(out);
        NSObject[] nSObjectArray = this.array;
        int n = this.array.length;
        int n2 = 0;
        while (n2 < n) {
            NSObject obj = nSObjectArray[n2];
            obj.assignIDs(out);
            ++n2;
        }
    }

    @Override
    void toBinary(BinaryPropertyListWriter out) throws IOException {
        out.writeIntHeader(10, this.array.length);
        NSObject[] nSObjectArray = this.array;
        int n = this.array.length;
        int n2 = 0;
        while (n2 < n) {
            NSObject obj = nSObjectArray[n2];
            out.writeID(out.getID(obj));
            ++n2;
        }
    }

    public String toASCIIPropertyList() {
        StringBuilder ascii = new StringBuilder();
        this.toASCII(ascii, 0);
        ascii.append(NEWLINE);
        return ascii.toString();
    }

    public String toGnuStepASCIIPropertyList() {
        StringBuilder ascii = new StringBuilder();
        this.toASCIIGnuStep(ascii, 0);
        ascii.append(NEWLINE);
        return ascii.toString();
    }

    @Override
    protected void toASCII(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        ascii.append('(');
        int indexOfLastNewLine = ascii.lastIndexOf(NEWLINE);
        int i = 0;
        while (i < this.array.length) {
            Class<?> objClass = this.array[i].getClass();
            if ((objClass.equals(NSDictionary.class) || objClass.equals(NSArray.class) || objClass.equals(NSData.class)) && indexOfLastNewLine != ascii.length()) {
                ascii.append(NEWLINE);
                indexOfLastNewLine = ascii.length();
                this.array[i].toASCII(ascii, level + 1);
            } else {
                if (i != 0) {
                    ascii.append(" ");
                }
                this.array[i].toASCII(ascii, 0);
            }
            if (i != this.array.length - 1) {
                ascii.append(',');
            }
            if (ascii.length() - indexOfLastNewLine > 80) {
                ascii.append(NEWLINE);
                indexOfLastNewLine = ascii.length();
            }
            ++i;
        }
        ascii.append(')');
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        ascii.append('(');
        int indexOfLastNewLine = ascii.lastIndexOf(NEWLINE);
        int i = 0;
        while (i < this.array.length) {
            Class<?> objClass = this.array[i].getClass();
            if ((objClass.equals(NSDictionary.class) || objClass.equals(NSArray.class) || objClass.equals(NSData.class)) && indexOfLastNewLine != ascii.length()) {
                ascii.append(NEWLINE);
                indexOfLastNewLine = ascii.length();
                this.array[i].toASCIIGnuStep(ascii, level + 1);
            } else {
                if (i != 0) {
                    ascii.append(" ");
                }
                this.array[i].toASCIIGnuStep(ascii, 0);
            }
            if (i != this.array.length - 1) {
                ascii.append(',');
            }
            if (ascii.length() - indexOfLastNewLine > 80) {
                ascii.append(NEWLINE);
                indexOfLastNewLine = ascii.length();
            }
            ++i;
        }
        ascii.append(')');
    }
}

