/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ASCIIPropertyListParser;
import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.XMLPropertyListParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class PropertyListParser {
    private static final int TYPE_XML = 0;
    private static final int TYPE_BINARY = 1;
    private static final int TYPE_ASCII = 2;
    private static final int TYPE_ERROR_BLANK = 10;
    private static final int TYPE_ERROR_UNKNOWN = 11;
    private static final int READ_BUFFER_LENGTH = 2048;

    protected PropertyListParser() {
    }

    private static int determineType(String dataBeginning) {
        if ((dataBeginning = dataBeginning.trim()).length() == 0) {
            return 10;
        }
        if (dataBeginning.startsWith("bplist")) {
            return 1;
        }
        if (dataBeginning.startsWith("(") || dataBeginning.startsWith("{") || dataBeginning.startsWith("/")) {
            return 2;
        }
        if (dataBeginning.startsWith("<")) {
            return 0;
        }
        return 11;
    }

    private static int determineType(byte[] bytes) {
        int offset = 0;
        if (bytes.length >= 3 && (bytes[0] & 0xFF) == 239 && (bytes[1] & 0xFF) == 187 && (bytes[2] & 0xFF) == 191) {
            offset += 3;
        }
        while (offset < bytes.length && bytes[offset] == 32 || bytes[offset] == 9 || bytes[offset] == 13 || bytes[offset] == 10 || bytes[offset] == 12) {
            ++offset;
        }
        return PropertyListParser.determineType(new String(bytes, offset, Math.min(8, bytes.length - offset)));
    }

    private static int determineType(InputStream is) throws IOException {
        int b;
        byte[] magicBytes = new byte[8];
        long index = -1L;
        boolean bom = false;
        do {
            if (is.markSupported()) {
                is.mark(16);
            }
            b = is.read();
            boolean bl = bom = ++index < 3L && (index == 0L && b == 239 || bom && (index == 1L && b == 187 || index == 2L && b == 191));
        } while (b != -1 && b == 32 || b == 9 || b == 13 || b == 10 || b == 12 || bom);
        magicBytes[0] = (byte)b;
        int read = is.read(magicBytes, 1, 7);
        int type = PropertyListParser.determineType(new String(magicBytes, 0, read));
        if (is.markSupported()) {
            is.reset();
        }
        return type;
    }

    protected static byte[] readAll(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        while ((read = in.read(buf, 0, 2048)) != -1) {
            outputStream.write(buf, 0, read);
        }
        return outputStream.toByteArray();
    }

    public static NSObject parse(String filePath) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        return PropertyListParser.parse(new File(filePath));
    }

    public static NSObject parse(File f) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        FileInputStream fis = new FileInputStream(f);
        int type = PropertyListParser.determineType(fis);
        fis.close();
        switch (type) {
            case 1: {
                return BinaryPropertyListParser.parse(f);
            }
            case 0: {
                return XMLPropertyListParser.parse(f);
            }
            case 2: {
                return ASCIIPropertyListParser.parse(f);
            }
        }
        throw new PropertyListFormatException("The given file is not a property list of a supported format.");
    }

    public static NSObject parse(byte[] bytes) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        switch (PropertyListParser.determineType(bytes)) {
            case 1: {
                return BinaryPropertyListParser.parse(bytes);
            }
            case 0: {
                return XMLPropertyListParser.parse(bytes);
            }
            case 2: {
                return ASCIIPropertyListParser.parse(bytes);
            }
        }
        throw new PropertyListFormatException("The given data is not a property list of a supported format.");
    }

    public static NSObject parse(InputStream is) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        return PropertyListParser.parse(PropertyListParser.readAll(is));
    }

    public static void saveAsXML(NSObject root, File out) throws IOException {
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        FileOutputStream fous = new FileOutputStream(out);
        PropertyListParser.saveAsXML(root, fous);
        fous.close();
    }

    public static void saveAsXML(NSObject root, OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, "UTF-8");
        w.write(root.toXMLPropertyList());
        w.close();
    }

    public static void convertToXml(File in, File out) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject root = PropertyListParser.parse(in);
        PropertyListParser.saveAsXML(root, out);
    }

    public static void saveAsBinary(NSObject root, File out) throws IOException {
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        BinaryPropertyListWriter.write(out, root);
    }

    public static void saveAsBinary(NSObject root, OutputStream out) throws IOException {
        BinaryPropertyListWriter.write(out, root);
    }

    public static void convertToBinary(File in, File out) throws IOException, ParserConfigurationException, ParseException, SAXException, PropertyListFormatException {
        NSObject root = PropertyListParser.parse(in);
        PropertyListParser.saveAsBinary(root, out);
    }

    public static void saveAsASCII(NSDictionary root, File out) throws IOException {
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "ASCII");
        w.write(root.toASCIIPropertyList());
        w.close();
    }

    public static void saveAsASCII(NSArray root, File out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "ASCII");
        w.write(root.toASCIIPropertyList());
        w.close();
    }

    public static void convertToASCII(File in, File out) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject root = PropertyListParser.parse(in);
        if (root instanceof NSDictionary) {
            PropertyListParser.saveAsASCII((NSDictionary)root, out);
        } else if (root instanceof NSArray) {
            PropertyListParser.saveAsASCII((NSArray)root, out);
        } else {
            throw new PropertyListFormatException("The root of the given input property list is neither a Dictionary nor an Array!");
        }
    }

    public static void saveAsGnuStepASCII(NSDictionary root, File out) throws IOException {
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "ASCII");
        w.write(root.toGnuStepASCIIPropertyList());
        w.close();
    }

    public static void saveAsGnuStepASCII(NSArray root, File out) throws IOException {
        File parent = out.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "ASCII");
        w.write(root.toGnuStepASCIIPropertyList());
        w.close();
    }

    public static void convertToGnuStepASCII(File in, File out) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject root = PropertyListParser.parse(in);
        if (root instanceof NSDictionary) {
            PropertyListParser.saveAsGnuStepASCII((NSDictionary)root, out);
        } else if (root instanceof NSArray) {
            PropertyListParser.saveAsGnuStepASCII((NSArray)root, out);
        } else {
            throw new PropertyListFormatException("The root of the given input property list is neither a Dictionary nor an Array!");
        }
    }
}

