/*
 * Decompiled with CFR 0.152.
 */
package mbookbinder.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mbookbinder.data.SectionData;
import mbookbinder.data.TocData;

public class BindObject {
    public ArrayList<SectionData> mArySectionData;
    public ArrayList<TocData> mAryTocData;

    public BindObject() {
        this.initialize();
    }

    public void initialize() {
        this.mArySectionData = new ArrayList();
        this.mAryTocData = new ArrayList();
    }

    public int countArySectionData() {
        return this.mArySectionData.size();
    }

    public int countPageOfArySectionData() {
        int retPages = 0;
        for (SectionData tmpDict : this.mArySectionData) {
            retPages += Integer.parseInt(tmpDict.getNumberOfPages());
        }
        return retPages;
    }

    public ArrayList<SectionData> getArySectionData() {
        return this.mArySectionData;
    }

    public ArrayList<TocData> getAryTocData() {
        return this.mAryTocData;
    }

    public void setArySectioncData(ArrayList<SectionData> tmpArySectionData) {
        this.mArySectionData = tmpArySectionData;
    }

    public void setAryTocData(ArrayList<TocData> tmpAryTocData) {
        this.mAryTocData = tmpAryTocData;
    }

    public void removeTocItemBySectionName(String sectionName) {
        Iterator<TocData> it = this.mAryTocData.iterator();
        while (it.hasNext()) {
            TocData tocData = it.next();
            if (!tocData.getSectionName().equals(sectionName)) continue;
            it.remove();
        }
    }

    public ArrayList<Map<String, Object>> getMapedSectionAry() {
        ArrayList<Map<String, Object>> retAry = new ArrayList<Map<String, Object>>();
        for (SectionData sectionData : this.mArySectionData) {
            retAry.add(this.convertSectionDataToMap(sectionData));
        }
        return retAry;
    }

    public Map<String, Object> convertSectionDataToMap(SectionData sectionData) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put(SectionData.Item.Path.name(), sectionData.get(SectionData.Item.Path));
        return retMap;
    }

    public ArrayList<Map<String, Object>> getMapedTocAry() {
        ArrayList<Map<String, Object>> retAry = new ArrayList<Map<String, Object>>();
        for (TocData tocData : this.mAryTocData) {
            retAry.add(this.convertTocDataToMap(tocData));
        }
        return retAry;
    }

    public Map<String, Object> convertTocDataToMap(TocData tocData) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("Title", tocData.getTitle());
        retMap.put("SectionName", tocData.getSectionName());
        retMap.put("PageNo", tocData.getPageIndex());
        retMap.put("Description", tocData.getDescription());
        return retMap;
    }
}

