/*
 * Decompiled with CFR 0.152.
 */
package mbookbinder.ui;

import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.basic.BasicTextFieldUI;
import mbookbinder.Binder;
import mbookbinder.data.BindObject;
import mbookbinder.data.BinderFileChooser;
import mbookbinder.data.SectionData;
import mbookbinder.data.TocData;
import mbookbinder.swingui.JTextFieldHintUI;
import mbookbinder.ui.TocFrame;
import mbookbinder.util.FileUtil;
import mbookbinder.util.GenerateMBook;
import mbookbinder.util.SectionTableModel;
import mbookbinder.util.TableRowTransferHandler;
import mbookbinder.util.XmlParser;

public class MainFrame
extends JFrame
implements ActionListener {
    private JMenuItem menuItem_newBind;
    private JMenuItem menuItem_loadBind;
    private JMenuItem menuItem_thisSaveBind;
    private JMenuItem menuItem_newSaveBind;
    private JPanel mTablePanel;
    private JScrollPane mTableScrollPane;
    private JTable mSectionTable;
    private SectionTableModel tableModel;
    private JButton mBtnSectionAdd;
    private JButton mBtnSectionDel;
    private JButton mBtnSectionSort;
    private JTextField mTfPages;
    private JTextField mTfSections;
    private JTextArea mTaSectionDesc;
    private JLabel mLbSectionDescTextLimit;
    private JTextField mTfSectionTitle;
    private JLabel mLbSectionThumbnail;
    private JButton mBtSectionThumbChange;
    private JButton mBtnApplySectionChanged;
    private JPanel mOptionPanel;
    private JTextField mTfBookTitle;
    private JTextField mTfSubTitle;
    private JTextField mTfAuthor;
    private JTextField mTfPublisher;
    private JTextArea mTfDescription;
    private JTextField mTfCoverImage;
    private JButton mBtnCoverImage;
    private JLabel mLbCoverMovie;
    private JTextField mTfCoverMovie;
    private JButton mBtnCoverMovie;
    private JLabel mLbIapId;
    private JTextField mTfIapId;
    private JLabel mLbIapStartPage;
    private JTextField mTfIapStartPage;
    private ButtonGroup mbgOrientation;
    private JRadioButton mRbOrientation_Both;
    private JRadioButton mRbOrientation_Portrait;
    private JRadioButton mRbOrientation_Landscape;
    private static final String ACTION_ORI_BOTH = "0";
    private static final String ACTION_ORI_PORTRAIT = "1";
    private static final String ACTION_ORI_LANDSCAPE = "2";
    private JCheckBox mCbBlockAllWebBoxes;
    private JCheckBox mCbPageCurling;
    private JCheckBox mCbPageSoundVolumeOff;
    private JButton mBtnEditToc;
    private JComboBox<String> mCbGenerateType;
    private JButton mBtnGenerate;
    private JProgressBar mProgress = new JProgressBar();
    private JFileChooser mFcAddSection;
    private JFileChooser mFcCoverImage;
    private JFileChooser mFcCoverMovie;
    private JFileChooser mFcExportMBook;
    private JFileChooser mFcLoadBind;
    private JFileChooser mFcSaveBind;
    private JFileChooser mFcSectionThumbnail;
    private File[] addTargetDirs;
    private File mFileCoverImage;
    private File mFileCoverMovie;
    private File mFileLoadBind;
    private File mFileSectionThumbnail;
    private BindObject MBookBinder = new BindObject();
    private SectionData mSelectedSectionData;
    private static final String EXTENSION_MBOOK = ".mBook";
    private static final String EXTENSION_BIND = ".bind";
    private static final String EXTENSION_ZIP = ".zip";
    public static int MAX_DESC_LIMIT = 30;

    public MainFrame() {
        this.initialize();
    }

    public BindObject getBinder() {
        return this.MBookBinder;
    }

    private void initialize() {
        this.setTitle("mbook Binder");
        try {
            this.setIconImage(ImageIO.read(MainFrame.class.getResource("/mbookbinder/resource/binder_icon.png")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mFcAddSection = new JFileChooser();
        this.mFcAddSection.setMultiSelectionEnabled(true);
        this.mFcAddSection.setFileSelectionMode(1);
        this.mFcExportMBook = new BinderFileChooser();
        this.mFcExportMBook.setFileSelectionMode(0);
        this.mFcExportMBook.setFileFilter(new FileNameExtensionFilter(EXTENSION_ZIP, "zip"));
        this.mFcCoverImage = new JFileChooser();
        this.mFcCoverImage.setFileSelectionMode(0);
        this.mFcCoverImage.setFileFilter(new FileNameExtensionFilter("Image files", ImageIO.getReaderFileSuffixes()));
        this.mFcCoverMovie = new JFileChooser();
        this.mFcCoverMovie.setFileSelectionMode(0);
        this.mFcCoverMovie.setFileFilter(new FileNameExtensionFilter(".avi", "avi"));
        this.mFcLoadBind = new JFileChooser();
        this.mFcLoadBind.setFileSelectionMode(0);
        this.mFcLoadBind.setFileFilter(new FileNameExtensionFilter(EXTENSION_BIND, "bind"));
        this.mFcSaveBind = new JFileChooser();
        this.mFcSaveBind.setFileSelectionMode(0);
        this.mFcSaveBind.setFileFilter(new FileNameExtensionFilter(EXTENSION_BIND, "bind"));
        this.mFcSectionThumbnail = new JFileChooser();
        this.mFcSectionThumbnail.setFileSelectionMode(0);
        this.mFcSectionThumbnail.setFileFilter(new FileNameExtensionFilter("Image files", ImageIO.getReaderFileSuffixes()));
        this.getContentPane().setLayout(new BorderLayout());
        this.setBounds(0, 0, 1200, 700);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        this.menuItem_newBind = new JMenuItem("New .bind");
        this.menuItem_newBind.addActionListener(this);
        menu.add(this.menuItem_newBind);
        this.menuItem_loadBind = new JMenuItem("Open .bind");
        this.menuItem_loadBind.addActionListener(this);
        menu.add(this.menuItem_loadBind);
        this.menuItem_thisSaveBind = new JMenuItem("Save .bind");
        this.menuItem_thisSaveBind.addActionListener(this);
        menu.add(this.menuItem_thisSaveBind);
        this.menuItem_newSaveBind = new JMenuItem("Save as .bind");
        this.menuItem_newSaveBind.addActionListener(this);
        menu.add(this.menuItem_newSaveBind);
        this.tableModel = new SectionTableModel(this.MBookBinder);
        this.mSectionTable = new JTable(this.tableModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                String tip = null;
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                try {
                    if (rowIndex >= 0) {
                        tip = ((SectionTableModel)this.getModel()).getRowAt(rowIndex).getPath();
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return tip;
            }
        };
        this.mSectionTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = MainFrame.this.mSectionTable.getSelectedRow();
                if (!e.getValueIsAdjusting() && selectedRow != -1) {
                    MainFrame.this.setSectionInfoEnable(true);
                    MainFrame.this.mSelectedSectionData = MainFrame.this.tableModel.getRowAt(selectedRow);
                    MainFrame.this.setSectionInfo(MainFrame.this.mSelectedSectionData);
                } else {
                    MainFrame.this.setSectionInfoEnable(false);
                }
            }
        });
        this.mSectionTable.setDragEnabled(true);
        this.mSectionTable.setDropMode(DropMode.INSERT_ROWS);
        this.mSectionTable.setTransferHandler(new TableRowTransferHandler(this.mSectionTable));
        this.mSectionTable.getColumnModel().getColumn(2).setMinWidth(60);
        this.mSectionTable.getColumnModel().getColumn(2).setMaxWidth(60);
        this.mSectionTable.getColumnModel().getColumn(3).setMinWidth(100);
        this.mSectionTable.getColumnModel().getColumn(3).setMaxWidth(100);
        this.mSectionTable.getColumnModel().getColumn(4).setMinWidth(80);
        this.mSectionTable.getColumnModel().getColumn(4).setMaxWidth(80);
        this.mTableScrollPane = new JScrollPane(this.mSectionTable);
        JPanel mTableOptionPanel = new JPanel();
        mTableOptionPanel.setLayout(new BoxLayout(mTableOptionPanel, 1));
        JPanel tableSecondOptionPanel = new JPanel();
        tableSecondOptionPanel.setLayout(new BoxLayout(tableSecondOptionPanel, 0));
        mTableOptionPanel.add(tableSecondOptionPanel);
        JPanel tableSecondLeftOptionPanel = new JPanel(new FlowLayout(0, 10, 8));
        this.mBtnSectionAdd = new JButton("+");
        this.mBtnSectionAdd.addActionListener(this);
        this.mBtnSectionDel = new JButton("-");
        this.mBtnSectionDel.addActionListener(this);
        this.mBtnSectionSort = new JButton("Sort");
        this.mBtnSectionSort.addActionListener(this);
        tableSecondOptionPanel.add(tableSecondLeftOptionPanel);
        tableSecondLeftOptionPanel.add(this.mBtnSectionSort);
        tableSecondLeftOptionPanel.add(this.mBtnSectionAdd);
        tableSecondLeftOptionPanel.add(this.mBtnSectionDel);
        JPanel tableSecondRightOptionPanel = new JPanel(new FlowLayout(2, 10, 8));
        JLabel mLbPages = new JLabel("Pages");
        this.mTfPages = new JTextField(ACTION_ORI_BOTH);
        this.mTfPages.setEditable(false);
        this.mTfPages.setHorizontalAlignment(4);
        this.mTfPages.setPreferredSize(new Dimension(50, 25));
        JLabel mLbSections = new JLabel("Sections");
        this.mTfSections = new JTextField(ACTION_ORI_BOTH);
        this.mTfSections.setEditable(false);
        this.mTfSections.setHorizontalAlignment(4);
        this.mTfSections.setPreferredSize(new Dimension(50, 25));
        tableSecondOptionPanel.add(tableSecondRightOptionPanel);
        tableSecondRightOptionPanel.add(mLbPages);
        tableSecondRightOptionPanel.add(this.mTfPages);
        tableSecondRightOptionPanel.add(mLbSections);
        tableSecondRightOptionPanel.add(this.mTfSections);
        JPanel tableFirstOptionPanel = new JPanel();
        tableFirstOptionPanel.setPreferredSize(new Dimension(0, 200));
        tableFirstOptionPanel.setLayout(null);
        mTableOptionPanel.add(tableFirstOptionPanel);
        JLabel lbSectionInfo = new JLabel("Section Info");
        lbSectionInfo.setBounds(12, 10, 80, 15);
        tableFirstOptionPanel.add(lbSectionInfo);
        JSeparator separator_1 = new JSeparator();
        separator_1.setBounds(94, 17, 528, 12);
        tableFirstOptionPanel.add(separator_1);
        JLabel lbSectionTitle = new JLabel("Title");
        lbSectionTitle.setHorizontalAlignment(4);
        lbSectionTitle.setBounds(22, 42, 65, 15);
        tableFirstOptionPanel.add(lbSectionTitle);
        this.mTfSectionTitle = new JTextField();
        this.mTfSectionTitle.setBounds(99, 35, 232, 30);
        tableFirstOptionPanel.add(this.mTfSectionTitle);
        this.mTfSectionTitle.setColumns(10);
        JLabel lbSectionDesc = new JLabel("Description");
        lbSectionDesc.setBounds(22, 81, 65, 15);
        tableFirstOptionPanel.add(lbSectionDesc);
        this.mTaSectionDesc = new JTextArea();
        this.mTaSectionDesc.setBounds(99, 74, 232, 90);
        this.mTaSectionDesc.setLineWrap(true);
        this.mTaSectionDesc.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                MainFrame.this.mLbSectionDescTextLimit.setText("( " + MainFrame.this.mTaSectionDesc.getText().length() + " / " + MAX_DESC_LIMIT + " )");
                if (MainFrame.this.mTaSectionDesc.getText().length() <= MAX_DESC_LIMIT) {
                    MainFrame.this.mLbSectionDescTextLimit.setForeground(Color.black);
                } else {
                    MainFrame.this.mLbSectionDescTextLimit.setForeground(Color.RED);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        tableFirstOptionPanel.add(this.mTaSectionDesc);
        this.mLbSectionDescTextLimit = new JLabel("( 0 / " + MAX_DESC_LIMIT + " )");
        this.mLbSectionDescTextLimit.setHorizontalAlignment(4);
        this.mLbSectionDescTextLimit.setBounds(274, 175, 57, 15);
        tableFirstOptionPanel.add(this.mLbSectionDescTextLimit);
        this.mLbSectionThumbnail = new JLabel("");
        this.mLbSectionThumbnail.setBounds(351, 21, 154, 143);
        this.mLbSectionThumbnail.setHorizontalAlignment(0);
        tableFirstOptionPanel.add(this.mLbSectionThumbnail);
        this.mBtSectionThumbChange = new JButton("Thumbnail Path...");
        this.mBtSectionThumbChange.setBounds(351, 167, 154, 23);
        this.mBtSectionThumbChange.addActionListener(this);
        tableFirstOptionPanel.add(this.mBtSectionThumbChange);
        this.mBtnApplySectionChanged = new JButton("Apply");
        this.mBtnApplySectionChanged.addActionListener(this);
        this.mBtnApplySectionChanged.setBounds(552, 167, 70, 23);
        tableFirstOptionPanel.add(this.mBtnApplySectionChanged);
        this.mTablePanel = new JPanel(new BorderLayout());
        this.mTablePanel.add((Component)this.mTableScrollPane, "Center");
        this.mTablePanel.add((Component)mTableOptionPanel, "Last");
        this.getContentPane().add((Component)this.mTablePanel, "Center");
        this.mOptionPanel = new JPanel(null);
        this.mOptionPanel.setPreferredSize(new Dimension(550, 0));
        JLabel mLbBookTitle = new JLabel("Title");
        mLbBookTitle.setBounds(22, 30, 120, 30);
        mLbBookTitle.setHorizontalAlignment(4);
        this.mTfBookTitle = new JTextField("");
        this.mTfBookTitle.setBounds(152, 30, 300, 30);
        JLabel mLbSubTitle = new JLabel("SubTitle");
        mLbSubTitle.setBounds(22, 70, 120, 30);
        mLbSubTitle.setHorizontalAlignment(4);
        this.mTfSubTitle = new JTextField();
        this.mTfSubTitle.setBounds(152, 70, 300, 30);
        JLabel mLbAuthor = new JLabel("Copyright");
        mLbAuthor.setHorizontalAlignment(4);
        mLbAuthor.setBounds(22, 110, 120, 30);
        this.mTfAuthor = new JTextField();
        this.mTfAuthor.setBounds(152, 110, 300, 30);
        JLabel mLbPublisher = new JLabel("Company");
        mLbPublisher.setBounds(22, 150, 120, 30);
        mLbPublisher.setHorizontalAlignment(4);
        this.mTfPublisher = new JTextField();
        this.mTfPublisher.setBounds(152, 150, 300, 30);
        this.mTfDescription = new JTextArea();
        this.mTfDescription.setBounds(152, 191, 300, 87);
        JLabel mLbCoverImage = new JLabel("CoverImage");
        mLbCoverImage.setBounds(22, 299, 120, 30);
        mLbCoverImage.setHorizontalAlignment(4);
        this.mTfCoverImage = new JTextField();
        this.mTfCoverImage.setBounds(152, 299, 300, 30);
        this.mBtnCoverImage = new JButton("Path...");
        this.mBtnCoverImage.setBounds(472, 299, 70, 30);
        this.mBtnCoverImage.addActionListener(this);
        this.mLbCoverMovie = new JLabel("CoverMovie");
        this.mLbCoverMovie.setBounds(20, 60, 120, 30);
        this.mLbCoverMovie.setHorizontalAlignment(4);
        this.mTfCoverMovie = new JTextField();
        this.mTfCoverMovie.setBounds(150, 60, 300, 30);
        this.mBtnCoverMovie = new JButton("Path...");
        this.mBtnCoverMovie.setBounds(470, 60, 70, 30);
        this.mBtnCoverMovie.addActionListener(this);
        this.mLbIapId = new JLabel("IAP ID");
        this.mLbIapId.setBounds(20, 100, 120, 30);
        this.mLbIapId.setHorizontalAlignment(4);
        this.mTfIapId = new JTextField();
        this.mTfIapId.setBounds(150, 100, 300, 30);
        this.mLbIapStartPage = new JLabel("IAP Start Page");
        this.mLbIapStartPage.setBounds(20, 140, 120, 30);
        this.mLbIapStartPage.setHorizontalAlignment(4);
        this.mTfIapStartPage = new JTextField();
        this.mTfIapStartPage.setBounds(150, 140, 300, 30);
        JLabel mLbOrientation = new JLabel("Orientation");
        mLbOrientation.setBounds(22, 352, 120, 30);
        mLbOrientation.setHorizontalAlignment(4);
        this.mbgOrientation = new ButtonGroup();
        this.mRbOrientation_Both = new JRadioButton("Both", true);
        this.mRbOrientation_Both.setBounds(152, 352, 100, 30);
        this.mRbOrientation_Both.setActionCommand(ACTION_ORI_BOTH);
        this.mbgOrientation.add(this.mRbOrientation_Both);
        this.mRbOrientation_Portrait = new JRadioButton("Portrait", false);
        this.mRbOrientation_Portrait.setBounds(152, 382, 100, 30);
        this.mRbOrientation_Portrait.setActionCommand(ACTION_ORI_PORTRAIT);
        this.mbgOrientation.add(this.mRbOrientation_Portrait);
        this.mRbOrientation_Landscape = new JRadioButton("Landscape", false);
        this.mRbOrientation_Landscape.setBounds(152, 412, 100, 30);
        this.mRbOrientation_Landscape.setActionCommand(ACTION_ORI_LANDSCAPE);
        this.mbgOrientation.add(this.mRbOrientation_Landscape);
        this.mCbBlockAllWebBoxes = new JCheckBox("Block All WebBoxes");
        this.mCbBlockAllWebBoxes.setBounds(150, 300, 150, 30);
        this.mCbPageCurling = new JCheckBox("Page Curling");
        this.mCbPageCurling.setBounds(150, 360, 170, 30);
        this.mCbPageSoundVolumeOff = new JCheckBox("Page Sound Volume Off");
        this.mCbPageSoundVolumeOff.setBounds(150, 330, 170, 30);
        this.mProgress = new JProgressBar();
        this.mProgress.setIndeterminate(true);
        this.mProgress.setVisible(false);
        this.mProgress.setBounds(22, 587, 330, 30);
        this.mBtnEditToc = new JButton("Edit TOC");
        this.mBtnEditToc.setBounds(372, 547, 170, 30);
        this.mBtnEditToc.addActionListener(this);
        this.mCbGenerateType = new JComboBox();
        this.mCbGenerateType.setBounds(370, 355, 170, 30);
        this.mCbGenerateType.addItem("Only Zip File");
        this.mCbGenerateType.addItem("Only Folder");
        this.mCbGenerateType.addItem("Both Folder & Zip File");
        JLabel mVersionLabel = new JLabel("MBookBinder Ver. 1.3.0");
        mVersionLabel.setBounds(22, 590, 200, 30);
        mVersionLabel.setHorizontalAlignment(4);
        this.mOptionPanel.add(mVersionLabel);
        this.mBtnGenerate = new JButton("Generate mbook");
        this.mBtnGenerate.setBounds(372, 587, 170, 30);
        this.mBtnGenerate.addActionListener(this);
        JLabel lbBookInfo = new JLabel("Book Info");
        lbBookInfo.setBounds(12, 10, 67, 15);
        this.mOptionPanel.add(lbBookInfo);
        JSeparator separator = new JSeparator();
        separator.setBounds(80, 17, 458, 12);
        this.mOptionPanel.add(separator);
        JSeparator separator_2 = new JSeparator();
        separator_2.setOrientation(1);
        separator_2.setBounds(0, 0, 12, 641);
        this.mOptionPanel.add(separator_2);
        this.mOptionPanel.add(mLbBookTitle);
        this.mOptionPanel.add(this.mTfBookTitle);
        this.mOptionPanel.add(mLbSubTitle);
        this.mOptionPanel.add(this.mTfSubTitle);
        this.mOptionPanel.add(mLbAuthor);
        this.mOptionPanel.add(this.mTfAuthor);
        this.mOptionPanel.add(mLbPublisher);
        this.mOptionPanel.add(this.mTfPublisher);
        JLabel mLbDescription = new JLabel("Description");
        mLbDescription.setBounds(22, 190, 120, 30);
        this.mOptionPanel.add(mLbDescription);
        mLbDescription.setHorizontalAlignment(4);
        this.mOptionPanel.add(this.mTfDescription);
        this.mOptionPanel.add(mLbCoverImage);
        this.mOptionPanel.add(this.mTfCoverImage);
        this.mOptionPanel.add(this.mBtnCoverImage);
        this.mOptionPanel.add(mLbOrientation);
        this.mOptionPanel.add(this.mRbOrientation_Both);
        this.mOptionPanel.add(this.mRbOrientation_Portrait);
        this.mOptionPanel.add(this.mRbOrientation_Landscape);
        this.mOptionPanel.add(this.mProgress);
        this.mOptionPanel.add(this.mBtnEditToc);
        this.mOptionPanel.add(this.mBtnGenerate);
        this.getContentPane().add((Component)this.mOptionPanel, "East");
        this.setSectionInfoEnable(false);
    }

    @Override
    public void dispose() {
        if (Binder.isLastBinder()) {
            System.exit(0);
        }
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.mBtnSectionAdd) {
            this.openSectionDirs();
        } else if (source == this.mBtnSectionDel) {
            this.delSelection();
        } else if (source == this.mBtnCoverImage) {
            this.openCoverImage();
        } else if (source == this.mBtnCoverMovie) {
            this.openCoverMovie();
        } else if (source == this.mBtnEditToc) {
            this.openEditTocFrame();
        } else if (source == this.mBtnGenerate) {
            this.generate();
        } else if (source == this.menuItem_newBind) {
            this.newBind();
        } else if (source == this.menuItem_loadBind) {
            this.openBind();
        } else if (source == this.menuItem_newSaveBind) {
            this.saveBind(true);
        } else if (source == this.menuItem_thisSaveBind) {
            this.saveBind(false);
        } else if (source == this.mBtnSectionSort) {
            this.sortSection();
        } else if (source == this.mBtnApplySectionChanged) {
            this.applySectionChanged();
        } else if (source == this.mBtSectionThumbChange) {
            this.changeSectionThumbnail();
        }
    }

    private void applySectionChanged() {
        if (this.mSelectedSectionData == null) {
            return;
        }
        if (this.mFileSectionThumbnail != null) {
            File jpgFile = new File(String.valueOf(this.mSelectedSectionData.getPath()) + File.separator + "thumb.jpg");
            File pngFile = new File(String.valueOf(this.mSelectedSectionData.getPath()) + File.separator + "thumb.png");
            if (jpgFile.exists()) {
                jpgFile.delete();
            }
            if (pngFile.exists()) {
                pngFile.delete();
            }
            String selectedThumbnailPath = this.mFileSectionThumbnail.getName().substring(this.mFileSectionThumbnail.getName().lastIndexOf("."));
            File targetFile = new File(String.valueOf(this.mSelectedSectionData.getPath()) + File.separator + "thumb" + selectedThumbnailPath);
            FileUtil.copy(this.mFileSectionThumbnail, targetFile);
            this.mSelectedSectionData.setSectionThumbnail(targetFile.getName());
            this.mFileSectionThumbnail = null;
        }
        this.mSelectedSectionData.setTitle(this.mTfSectionTitle.getText());
        String descText = this.mTaSectionDesc.getText();
        if (descText.length() > MAX_DESC_LIMIT) {
            descText = descText.substring(0, MAX_DESC_LIMIT);
        }
        this.mSelectedSectionData.setDescription(descText);
        XmlParser.overWriteSectionInfo(this.mSelectedSectionData);
        SectionData sectionData = XmlParser.parseSectionInfo(new File(String.valueOf(this.mSelectedSectionData.getPath()) + File.separator + "SectionInfo.xml"));
        this.tableModel.replaceSectionData(sectionData);
        JOptionPane.showMessageDialog(null, "\"" + this.mSelectedSectionData.getName() + "\" Section's Changes are applyed.");
        this.mSelectedSectionData = null;
    }

    private void changeSectionThumbnail() {
        if (this.mFcSectionThumbnail.showOpenDialog(this) == 0) {
            this.mFileSectionThumbnail = this.mFcSectionThumbnail.getSelectedFile();
            this.createImageIcon(this.mFileSectionThumbnail);
        } else {
            this.mFileSectionThumbnail = null;
        }
    }

    private void findCorverExtension(String str) {
        File jpgFile = new File(String.valueOf(str) + File.separator + "thumb.jpg");
        File pngFile = new File(String.valueOf(str) + File.separator + "thumb.png");
        if (jpgFile.exists()) {
            this.createImageIcon(jpgFile);
        } else if (pngFile.exists()) {
            this.createImageIcon(pngFile);
        }
    }

    private void createImageIcon(File file) {
        try {
            ImageIcon imgIcon = new ImageIcon(Files.readAllBytes(file.toPath()));
            float wFactor = (float)this.mLbSectionThumbnail.getWidth() / (float)imgIcon.getIconWidth();
            float hFactor = (float)this.mLbSectionThumbnail.getHeight() / (float)imgIcon.getIconHeight();
            float scaledWidth = Math.min(wFactor, hFactor) * (float)imgIcon.getIconWidth();
            float scaledHeight = Math.min(wFactor, hFactor) * (float)imgIcon.getIconHeight();
            this.mLbSectionThumbnail.setIcon(new ImageIcon(imgIcon.getImage().getScaledInstance((int)scaledWidth, (int)scaledHeight, 4)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setSectionInfoEnable(boolean enable) {
        this.mTfSectionTitle.setEnabled(enable);
        this.mTaSectionDesc.setEnabled(enable);
        this.mBtnApplySectionChanged.setEnabled(enable);
        this.mBtSectionThumbChange.setEnabled(enable);
        if (!enable) {
            this.mTfSectionTitle.setUI(new BasicTextFieldUI());
            this.mTaSectionDesc.setUI(new BasicTextFieldUI());
        }
    }

    private void setSectionInfo(SectionData sectionData) {
        this.mTfSectionTitle.setUI(new JTextFieldHintUI(sectionData.getTitle(), Color.GRAY));
        this.mTfSectionTitle.setText(sectionData.getTitle());
        this.mTaSectionDesc.setUI(new JTextFieldHintUI(sectionData.getDescription(), Color.GRAY));
        this.mTaSectionDesc.setText(sectionData.getDescription());
        this.mLbSectionThumbnail.setIcon(null);
        this.findCorverExtension(sectionData.getPath());
        this.mLbSectionDescTextLimit.setText("( 0 / " + MAX_DESC_LIMIT + " )");
        this.mLbSectionDescTextLimit.setForeground(Color.black);
    }

    private void sortSection() {
        this.tableModel.sort();
    }

    private void openSectionDirs() {
        if (this.mFcAddSection.showOpenDialog(this) == 0) {
            File[] fileArray = this.addTargetDirs = this.mFcAddSection.getSelectedFiles();
            int n = this.addTargetDirs.length;
            int n2 = 0;
            while (n2 < n) {
                File tmpFile = fileArray[n2];
                this.addSectionDir(tmpFile);
                ++n2;
            }
        }
    }

    private void addSectionDir(File dir) {
        File[] childFiles;
        File sectionInfoXml = null;
        File[] fileArray = childFiles = dir.listFiles();
        int n = childFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File tmpFile = fileArray[n2];
            if (tmpFile.getName().equals("SectionInfo.xml")) {
                sectionInfoXml = tmpFile;
                break;
            }
            ++n2;
        }
        if (sectionInfoXml == null) {
            return;
        }
        SectionData sectionData = XmlParser.parseSectionInfo(sectionInfoXml);
        if (sectionData != null) {
            if (this.tableModel.checkContainsSectionName(sectionData)) {
                JOptionPane.showMessageDialog(null, "\"" + sectionData.getName() + "\" SectionName is exists. \nSo add \"" + sectionData.getPath() + "\" is rejected.");
            } else {
                this.tableModel.addRow(sectionData);
                this.countPageAndSection();
            }
        }
    }

    private void delSelection() {
        int[] rows = this.mSectionTable.getSelectedRows();
        int i = rows.length - 1;
        while (i >= 0) {
            int row = rows[i];
            this.tableModel.removeRowWithCheckTocAry(row);
            --i;
        }
        this.countPageAndSection();
    }

    private void countPageAndSection() {
        this.mTfPages.setText(String.valueOf(this.MBookBinder.countPageOfArySectionData()));
        this.mTfSections.setText(String.valueOf(this.MBookBinder.countArySectionData()));
    }

    private void openEditTocFrame() {
        if (this.MBookBinder.countArySectionData() > 0) {
            TocFrame window = new TocFrame("Edit Toc", this);
            window.setVisible(true);
            this.setEnabled(false);
        } else {
            JOptionPane.showMessageDialog(null, "No Section exist.");
        }
    }

    private void openCoverImage() {
        if (this.mFcCoverImage.showOpenDialog(this) == 0) {
            this.mFileCoverImage = this.mFcCoverImage.getSelectedFile();
            if (this.mFileCoverImage != null) {
                this.mTfCoverImage.setText(this.mFileCoverImage.getPath());
            }
        }
    }

    private void openCoverMovie() {
        if (this.mFcCoverMovie.showOpenDialog(this) == 0) {
            this.mFileCoverMovie = this.mFcCoverMovie.getSelectedFile();
            if (this.mFileCoverMovie != null) {
                this.mTfCoverMovie.setText(this.mFileCoverMovie.getPath());
            }
        }
    }

    private void newBind() {
        Binder.runNewBinder();
    }

    private void openBind() {
        block25: {
            if (this.mFcLoadBind.showOpenDialog(this) != 0) break block25;
            if (this.mFcLoadBind.getSelectedFile() == null) {
                return;
            }
            this.mFileLoadBind = this.mFcLoadBind.getSelectedFile();
            try {
                NSDictionary subDict;
                NSObject obj;
                int n;
                int n2;
                NSObject[] nSObjectArray;
                NSDictionary rootDict = (NSDictionary)PropertyListParser.parse(this.mFileLoadBind);
                this.mTfBookTitle.setText(rootDict.objectForKey("BookTitle").toString());
                this.mTfSubTitle.setText(rootDict.objectForKey("SubTitle").toString());
                this.mTfAuthor.setText(rootDict.objectForKey("Author").toString());
                this.mTfPublisher.setText(rootDict.objectForKey("Publisher").toString());
                this.mTfDescription.setText(rootDict.objectForKey("Description").toString());
                this.mTfCoverImage.setText(rootDict.objectForKey("CoverPath").toString());
                this.mFileCoverImage = new File(this.mTfCoverImage.getText());
                this.mTfCoverMovie.setText(rootDict.objectForKey("CoverMovie").toString());
                this.mFileCoverMovie = new File(this.mTfCoverMovie.getText());
                this.mTfIapId.setText(rootDict.objectForKey("iOSInAppID").toString());
                this.mTfIapStartPage.setText(rootDict.objectForKey("InAppStartPage").toString());
                switch (rootDict.objectForKey("Orientation").toString()) {
                    case "0": {
                        this.mRbOrientation_Both.setSelected(true);
                        break;
                    }
                    case "1": {
                        this.mRbOrientation_Portrait.setSelected(true);
                        break;
                    }
                    case "2": {
                        this.mRbOrientation_Landscape.setSelected(true);
                    }
                }
                this.mCbBlockAllWebBoxes.setSelected(rootDict.objectForKey("BlockWebbox").toString().equals(ACTION_ORI_PORTRAIT));
                this.mCbPageCurling.setSelected(rootDict.objectForKey("PageCurling").toString().equals(ACTION_ORI_PORTRAIT));
                this.mCbPageSoundVolumeOff.setSelected(rootDict.objectForKey("PageVolumeOff").toString().equals(ACTION_ORI_PORTRAIT));
                if (rootDict.objectForKey("Sections") != null) {
                    NSObject[] sectionsAry;
                    ArrayList<SectionData> tmpSectionsAry = new ArrayList<SectionData>();
                    nSObjectArray = sectionsAry = ((NSArray)rootDict.objectForKey("Sections")).getArray();
                    n2 = sectionsAry.length;
                    n = 0;
                    while (n < n2) {
                        obj = nSObjectArray[n];
                        subDict = (NSDictionary)obj;
                        SectionData tmpSectionData = null;
                        for (String key : subDict.keySet()) {
                            if (SectionData.Item.valueOf(key) != SectionData.Item.Path) continue;
                            tmpSectionData = XmlParser.parseSectionInfo(new File(String.valueOf(subDict.get(key).toString()) + File.separator + "SectionInfo.xml"));
                        }
                        if (tmpSectionData != null) {
                            tmpSectionsAry.add(tmpSectionData);
                        }
                        ++n;
                    }
                    this.MBookBinder.setArySectioncData(tmpSectionsAry);
                }
                if (rootDict.objectForKey("TOC") != null) {
                    NSObject[] tocAry;
                    ArrayList<TocData> tmpTocAry = new ArrayList<TocData>();
                    nSObjectArray = tocAry = ((NSArray)rootDict.objectForKey("TOC")).getArray();
                    n2 = tocAry.length;
                    n = 0;
                    while (n < n2) {
                        obj = nSObjectArray[n];
                        subDict = (NSDictionary)obj;
                        TocData tmpTocData = new TocData();
                        for (String key : subDict.keySet()) {
                            tmpTocData.put(key, subDict.get(key).toString());
                        }
                        boolean addData = false;
                        for (SectionData sectionData : this.MBookBinder.getArySectionData()) {
                            if (!tmpTocData.getSectionName().equals(sectionData.getName())) continue;
                            addData = true;
                        }
                        if (addData) {
                            tmpTocAry.add(tmpTocData);
                        }
                        ++n;
                    }
                    this.MBookBinder.setAryTocData(tmpTocAry);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.tableModel.initRow();
            this.countPageAndSection();
            this.mFileSectionThumbnail = null;
            this.mSelectedSectionData = null;
        }
    }

    private void saveBind(boolean isNew) {
        File destFile = null;
        if (isNew) {
            if (this.mFcSaveBind.showSaveDialog(this) == 0) {
                if (this.mFcSaveBind.getSelectedFile() == null) {
                    return;
                }
                String destPath = this.mFcSaveBind.getSelectedFile().getPath();
                if (!destPath.endsWith(EXTENSION_BIND)) {
                    destPath = String.valueOf(destPath) + EXTENSION_BIND;
                }
                destFile = new File(destPath);
            }
        } else {
            if (this.mFileLoadBind == null) {
                JOptionPane.showMessageDialog(null, "This File isn't Opened .bind");
                return;
            }
            destFile = this.mFileLoadBind;
        }
        if (destFile.exists() && JOptionPane.showConfirmDialog(null, String.valueOf(destFile.getPath()) + " is exists.\nDo you want overriding ? ", "Waring", 0) == 1) {
            return;
        }
        try {
            PropertyListParser.saveAsXML((NSObject)this.makeBindNSDict(), destFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private NSDictionary makeBindNSDict() {
        System.out.println("makeBindNSDict");
        NSDictionary root = new NSDictionary();
        root.put("BookTitle", (Object)this.mTfBookTitle.getText());
        root.put("SubTitle", (Object)this.mTfSubTitle.getText());
        root.put("Author", (Object)this.mTfAuthor.getText());
        root.put("Publisher", (Object)this.mTfPublisher.getText());
        root.put("Description", (Object)this.mTfDescription.getText());
        root.put("CoverPath", (Object)this.mTfCoverImage.getText());
        root.put("CoverMovie", (Object)this.mTfCoverMovie.getText());
        root.put("iOSInAppID", (Object)this.mTfIapId.getText());
        root.put("InAppStartPage", (Object)this.mTfIapStartPage.getText());
        root.put("Orientation", (Object)this.mbgOrientation.getSelection().getActionCommand());
        root.put("BlockWebbox", (Object)(this.mCbBlockAllWebBoxes.isSelected() ? ACTION_ORI_PORTRAIT : ACTION_ORI_BOTH));
        root.put("PageCurling", (Object)(this.mCbPageCurling.isSelected() ? ACTION_ORI_PORTRAIT : ACTION_ORI_BOTH));
        root.put("PageVolumeOff", (Object)(this.mCbPageSoundVolumeOff.isSelected() ? ACTION_ORI_PORTRAIT : ACTION_ORI_BOTH));
        root.put("Sections", (Object)this.MBookBinder.getMapedSectionAry());
        if (this.MBookBinder.getMapedTocAry().size() > 0) {
            root.put("TOC", (Object)this.MBookBinder.getMapedTocAry());
        }
        return root;
    }

    private void generate() {
        if (this.MBookBinder.getArySectionData().size() == 0) {
            JOptionPane.showMessageDialog(null, "SectionTable is empty.");
            return;
        }
        for (SectionData sectionData : this.MBookBinder.getArySectionData()) {
            File tmpSec = new File(sectionData.getPath());
            if (tmpSec.exists()) continue;
            JOptionPane.showMessageDialog(null, "\"" + sectionData.getPath() + "\" Section is not exists.");
            return;
        }
        if (this.mFileCoverImage == null || !this.mFileCoverImage.exists()) {
            JOptionPane.showMessageDialog(null, "CoverImage is not exists.");
            return;
        }
        if (this.mFcExportMBook.showSaveDialog(this) == 0) {
            if (this.mFcExportMBook.getSelectedFile() == null) {
                return;
            }
            String destPath = this.mFcExportMBook.getSelectedFile().getPath();
            if (destPath.endsWith(EXTENSION_ZIP)) {
                destPath = destPath.replace(EXTENSION_ZIP, "");
            }
            if (!destPath.endsWith(EXTENSION_MBOOK)) {
                destPath = String.valueOf(destPath) + EXTENSION_MBOOK;
            }
            File destFile = new File(destPath);
            File destZip = new File(String.valueOf(destPath) + EXTENSION_ZIP);
            if (destZip.exists() && JOptionPane.showConfirmDialog(null, String.valueOf(destZip.getPath()) + " is exists.\nDo you want overriding ? ", "Waring", 0) == 1) {
                return;
            }
            this.mProgress.setVisible(true);
            new GenerateMBook(this.mProgress, this.MBookBinder).setExportDir(destFile).setBind(this.makeBindNSDict()).start();
        }
    }
}

