/*
 * Decompiled with CFR 0.152.
 */
package mbookbinder.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.DefaultCellEditor;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.PlainDocument;
import mbookbinder.data.BindObject;
import mbookbinder.data.SectionData;
import mbookbinder.data.TocData;
import mbookbinder.ui.MainFrame;
import mbookbinder.util.NumberDocFilter;
import mbookbinder.util.TableRowTransferHandler;
import mbookbinder.util.TocDataTableModel;

public class TocFrame
extends JFrame
implements ActionListener {
    private JFrame owner;
    GridBagConstraints gbc;
    GridBagLayout gBag;
    private JPanel mTablePanel;
    private JScrollPane mTableScrollPane;
    private JTable mSectionTable;
    private JPanel mTableOptionPanel;
    private JButton mBtnSectionAdd;
    private JButton mBtnSectionDel;
    private JButton mBtnSectionReset;
    private JButton mBtnLoadFromSectionList;
    private JTextField mTfRemoveTextLength;
    private JButton mBtnRemoveFront;
    private JButton mBtnRemoveBack;
    private TocDataTableModel tableModel;
    private Vector<String> tableRow = new Vector();
    private JPanel mDescriptionPane;
    private JLabel mLbDescription;
    private JLabel mLbCountDescription;
    private JTextArea mTfDescription;
    private JPanel mButtonPane;
    private JButton mBtnOk;
    private JButton mBtnCancel;
    private BindObject MBookBinder;
    private int currentSelectedIndex = -1;

    public TocFrame(String title, JFrame owner) {
        super(title);
        this.owner = owner;
        this.MBookBinder = ((MainFrame)owner).getBinder();
        this.initializeUI();
        this.initializeData();
    }

    @Override
    public void dispose() {
        this.owner.toFront();
        this.owner.setEnabled(true);
        super.dispose();
    }

    private void initializeUI() {
        this.setLayout(new BorderLayout());
        this.setBounds(0, 0, 800, 500);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        try {
            this.setIconImage(ImageIO.read(TocFrame.class.getResource("/mbookbinder/resource/binder_icon.png")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.tableModel = new TocDataTableModel(this.MBookBinder);
        this.initSectionTable();
        this.mTableScrollPane = new JScrollPane(this.mSectionTable);
        this.gBag = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.mTableOptionPanel = new JPanel(this.gBag);
        this.mBtnSectionAdd = new JButton("+");
        this.mBtnSectionAdd.addActionListener(this);
        this.mBtnSectionDel = new JButton("-");
        this.mBtnSectionDel.addActionListener(this);
        this.mBtnSectionReset = new JButton("Revert");
        this.mBtnSectionReset.addActionListener(this);
        this.mBtnLoadFromSectionList = new JButton("Import all");
        this.mBtnLoadFromSectionList.addActionListener(this);
        this.gbAdd(this.mBtnSectionReset, 0, 0, 1, 1, 0, 0);
        this.gbAdd(this.mBtnLoadFromSectionList, 1, 0, 1, 1, 0, 0);
        this.gbAdd(new JLabel(" "), 2, 0, 1, 1, 1, 1);
        this.gbAdd(this.mBtnSectionAdd, 3, 0, 1, 1, 0, 0);
        this.gbAdd(this.mBtnSectionDel, 4, 0, 1, 1, 0, 0);
        JPanel titleRemovePanel = new JPanel(new FlowLayout(0));
        JLabel tFtitleRemove = new JLabel("Remove Title From : ");
        this.mTfRemoveTextLength = new JTextField(2);
        this.mTfRemoveTextLength.setText("0");
        PlainDocument doc = (PlainDocument)this.mTfRemoveTextLength.getDocument();
        doc.setDocumentFilter(new NumberDocFilter());
        this.mBtnRemoveFront = new JButton("Front");
        this.mBtnRemoveFront.addActionListener(this);
        this.mBtnRemoveBack = new JButton("Back");
        this.mBtnRemoveBack.addActionListener(this);
        titleRemovePanel.add(tFtitleRemove);
        titleRemovePanel.add(this.mBtnRemoveFront);
        titleRemovePanel.add(this.mTfRemoveTextLength);
        titleRemovePanel.add(this.mBtnRemoveBack);
        this.gbAdd(titleRemovePanel, 0, 1, 0, 0, 0, 1);
        this.mTablePanel = new JPanel(new BorderLayout());
        this.mTablePanel.add((Component)this.mTableScrollPane, "Center");
        this.mTablePanel.add((Component)this.mTableOptionPanel, "South");
        this.add((Component)this.mTablePanel, "Center");
        this.mDescriptionPane = new JPanel(null);
        this.mDescriptionPane.setPreferredSize(new Dimension(300, 0));
        this.mLbDescription = new JLabel("Description");
        this.mLbDescription.setBounds(10, 0, 120, 30);
        this.mTfDescription = new JTextArea();
        this.mTfDescription.setBounds(10, 40, 280, 150);
        this.mTfDescription.setLineWrap(true);
        this.mTfDescription.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                TocFrame.this.mLbCountDescription.setText("( " + TocFrame.this.mTfDescription.getText().length() + " / " + MainFrame.MAX_DESC_LIMIT + ")");
                if (TocFrame.this.mTfDescription.getText().length() <= MainFrame.MAX_DESC_LIMIT) {
                    TocFrame.this.mLbCountDescription.setForeground(Color.black);
                    if (TocFrame.this.currentSelectedIndex != -1) {
                        TocFrame.this.tableModel.getRowAt(TocFrame.this.currentSelectedIndex).setDescription(TocFrame.this.mTfDescription.getText());
                    }
                } else {
                    TocFrame.this.mLbCountDescription.setForeground(Color.RED);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.mLbCountDescription = new JLabel("( 0 / 20)");
        this.mLbCountDescription.setBounds(240, 190, 50, 30);
        this.mDescriptionPane.add(this.mLbDescription);
        this.mDescriptionPane.add(this.mTfDescription);
        this.mDescriptionPane.add(this.mLbCountDescription);
        this.add((Component)this.mDescriptionPane, "East");
        this.mBtnOk = new JButton("OK");
        this.mBtnOk.addActionListener(this);
        this.mBtnCancel = new JButton("Cancel");
        this.mBtnCancel.addActionListener(this);
        this.mButtonPane = new JPanel(new FlowLayout(1));
        this.mButtonPane.add(this.mBtnCancel);
        this.mButtonPane.add(this.mBtnOk);
        this.add((Component)this.mButtonPane, "South");
    }

    private void gbAdd(JComponent c, int x, int y, int w, int h, int weight, int fill) {
        this.gbc.fill = fill;
        this.gbc.gridx = x;
        this.gbc.gridy = y;
        this.gbc.gridwidth = w;
        this.gbc.gridheight = h;
        this.gbc.weightx = weight;
        this.gbc.insets = new Insets(2, 2, 2, 2);
        this.mTableOptionPanel.add((Component)c, this.gbc);
    }

    private void initSectionTable() {
        this.mSectionTable = new JTable(this.tableModel);
        this.mSectionTable.setDragEnabled(true);
        this.mSectionTable.setDropMode(DropMode.INSERT_ROWS);
        this.mSectionTable.setTransferHandler(new TableRowTransferHandler(this.mSectionTable));
        this.mSectionTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                System.out.println(String.valueOf(TocFrame.this.mSectionTable.getSelectedRow()) + " " + event.getFirstIndex() + " " + event.getLastIndex() + " " + event.getValueIsAdjusting());
                if (event.getValueIsAdjusting()) {
                    TocFrame.this.currentSelectedIndex = event.getFirstIndex();
                } else if (TocFrame.this.mSectionTable.getSelectedRow() != -1) {
                    TocFrame.this.currentSelectedIndex = TocFrame.this.mSectionTable.getSelectedRow();
                }
                TocFrame.this.mTfDescription.setText(TocFrame.this.tableModel.getRowAt(TocFrame.this.currentSelectedIndex).getDescription());
                TocFrame.this.mLbCountDescription.setText("( " + TocFrame.this.mTfDescription.getText().length() + " / " + MainFrame.MAX_DESC_LIMIT + ")");
            }
        });
        JComboBox<String> cbSectionName = new JComboBox<String>();
        ArrayList<SectionData> tmpAryDictData = this.MBookBinder.getArySectionData();
        for (SectionData tmpDict : tmpAryDictData) {
            cbSectionName.addItem(tmpDict.getName());
        }
        this.mSectionTable.getColumnModel().getColumn(0).setMinWidth(150);
        this.mSectionTable.getColumnModel().getColumn(1).setMinWidth(150);
        this.mSectionTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(cbSectionName));
        this.mSectionTable.getColumnModel().getColumn(2).setMinWidth(70);
        this.mSectionTable.getColumnModel().getColumn(2).setMaxWidth(70);
    }

    private void initializeData() {
        this.tableModel.initRowData(this.MBookBinder.getAryTocData());
    }

    private void addSection() {
        TocData tmpTocData = new TocData("title", "", "0", "");
        this.tableModel.addRow(tmpTocData);
    }

    private void delSelection() {
        int[] rows = this.mSectionTable.getSelectedRows();
        int i = rows.length - 1;
        while (i >= 0) {
            int row = rows[i];
            this.tableModel.removeRow(row);
            --i;
        }
        this.mTfDescription.setText("");
    }

    private void resetSelection() {
        int targetIndex = this.mSectionTable.getSelectedRow();
        if (targetIndex == -1) {
            JOptionPane.showMessageDialog(null, "Toc is not Selected");
            return;
        }
        this.tableModel.resetRow(targetIndex);
    }

    private void disposeWithOk() {
        ArrayList<TocData> tmpAryToc = this.tableModel.getAllRows();
        if (tmpAryToc.size() > 0) {
            int lastSectionOrder = -1;
            HashMap<String, Integer> sectionOrderMap = new HashMap<String, Integer>();
            int i = 0;
            while (i < this.MBookBinder.getArySectionData().size()) {
                sectionOrderMap.put(this.MBookBinder.getArySectionData().get(i).getName(), i);
                ++i;
            }
            for (TocData tmpToc : tmpAryToc) {
                if (tmpToc.getSectionName().equals("")) {
                    JOptionPane.showMessageDialog(null, "Item not specified section exists.");
                    return;
                }
                System.out.println(String.valueOf(lastSectionOrder) + " ? " + sectionOrderMap.get(tmpToc.getSectionName()) + " size :" + sectionOrderMap.size());
                if ((Integer)sectionOrderMap.get(tmpToc.getSectionName()) >= lastSectionOrder) {
                    lastSectionOrder = (Integer)sectionOrderMap.get(tmpToc.getSectionName());
                    continue;
                }
                JOptionPane.showMessageDialog(null, "Invalid TOC order");
                return;
            }
            this.MBookBinder.setAryTocData(tmpAryToc);
        }
        this.dispose();
    }

    private void loadFromSectionList() {
        for (SectionData sectionData : this.MBookBinder.getArySectionData()) {
            String sectionName;
            String string = sectionName = sectionData.getTitle().isEmpty() ? sectionData.getName() : sectionData.getTitle();
            if (sectionName.contains(".section")) {
                sectionName = sectionName.substring(0, sectionName.indexOf(".section"));
            }
            TocData tmpTocData = new TocData(sectionName, sectionData.getName(), "0", "");
            tmpTocData.setDescription(sectionData.getDescription());
            this.tableModel.addRow(tmpTocData);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.mBtnSectionAdd) {
            this.addSection();
        } else if (source == this.mBtnSectionDel) {
            this.delSelection();
        } else if (source == this.mBtnSectionReset) {
            this.resetSelection();
        } else if (source == this.mBtnOk) {
            this.disposeWithOk();
        } else if (source == this.mBtnCancel) {
            this.dispose();
        } else if (source == this.mBtnLoadFromSectionList) {
            this.loadFromSectionList();
        } else if (source == this.mBtnRemoveFront) {
            this.tableModel.removeTitleFront(Integer.parseInt(this.mTfRemoveTextLength.getText()));
        } else if (source == this.mBtnRemoveBack) {
            this.tableModel.removeTitleBack(Integer.parseInt(this.mTfRemoveTextLength.getText()));
        }
    }
}

