/*
 * Decompiled with CFR 0.152.
 */
package mbookbinder.util;

import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.util.ArrayList;
import javax.activation.DataHandler;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import mbookbinder.util.TableUtil;
import mbookbinder.util.multiReorderableTableModel;

public class TableRowTransferHandler
extends TransferHandler {
    private final DataFlavor localObjectFlavor = new DataFlavor(Integer.class, "Integer Row Index");
    private JTable table = null;

    public TableRowTransferHandler(JTable table) {
        this.table = table;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        assert (c == this.table);
        return new DataHandler((Object)new Integer(this.table.getSelectedRow()), this.localObjectFlavor.getMimeType());
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        boolean b = info.getComponent() == this.table && info.isDrop() && info.isDataFlavorSupported(this.localObjectFlavor);
        this.table.setCursor(b ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
        return b;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        JTable target = (JTable)info.getComponent();
        JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
        int index = dl.getRow();
        int max = this.table.getModel().getRowCount();
        if (index < 0 || index > max) {
            index = max;
        }
        target.setCursor(Cursor.getPredefinedCursor(0));
        try {
            Integer rowFrom = (Integer)info.getTransferable().getTransferData(this.localObjectFlavor);
            if (rowFrom != -1 && rowFrom != index) {
                int[] rows = this.table.getSelectedRows();
                Object objRow = ((multiReorderableTableModel)this.table.getModel()).CloneRow();
                int dist = 0;
                Object object = rows;
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    int row = object[n2];
                    if (index > row) {
                        ++dist;
                    }
                    ++n2;
                }
                index -= dist;
                ArrayList<Object> list = TableUtil.getSelectedList(this.table);
                TableUtil.removeSelected(this.table);
                ArrayList<Integer> sels = new ArrayList<Integer>();
                object = list.iterator();
                while (object.hasNext()) {
                    Object obj = object.next();
                    sels.add(index);
                    TableUtil.addRowAt(this.table, obj, index++);
                }
                TableUtil.selectMultipleRow(this.table, sels);
                ((multiReorderableTableModel)this.table.getModel()).reorderEnd(objRow);
                ((multiReorderableTableModel)this.table.getModel()).printDebug();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent c, Transferable t, int act) {
        if (act == 2) {
            this.table.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

