/*
 * Decompiled with CFR 0.152.
 */
package mbookbinder.util;

import com.dd.plist.NSDictionary;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import mbookbinder.data.BindObject;
import mbookbinder.data.SectionData;
import mbookbinder.data.TocData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlParser {
    private static final String SECTION_TITLE = "SectionTitle";
    private static final String DESCRIPTION = "Description";
    private static final String SECTION_THUMBNAIL = "SectionThumbnail";
    private static final String NUMBER_OF_PAGES = "NumberOfPages";
    private static final String PAGE_SIZE = "PageSize";
    private static final String PATH = "Path";
    private static final String VERSION = "Version";

    public static void overWriteSectionInfo(SectionData sectionData) {
        try {
            DocumentBuilderFactory docBuildFact = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuild = docBuildFact.newDocumentBuilder();
            FileInputStream in = new FileInputStream(String.valueOf(sectionData.getPath()) + File.separator + "SectionInfo.xml");
            Document doc = docBuild.parse(in, "UTF-8");
            XPath xpath = XPathFactory.newInstance().newXPath();
            SectionData.Item[] itemArray = SectionData.Item.values();
            int n = itemArray.length;
            int n2 = 0;
            while (n2 < n) {
                SectionData.Item item = itemArray[n2];
                Node node = ((NodeList)xpath.evaluate("/xml/" + (Object)((Object)item), doc, XPathConstants.NODESET)).item(0);
                if (node != null) {
                    node.setTextContent(sectionData.get(item));
                }
                ++n2;
            }
            doc.setXmlStandalone(true);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new FileOutputStream(String.valueOf(sectionData.getPath()) + File.separator + "SectionInfo.xml"));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static SectionData parseSectionInfo(File sectionInfoFile) {
        SectionData tmpSectionData = null;
        try {
            DocumentBuilder docBuild = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            FileInputStream in = new FileInputStream(sectionInfoFile);
            XPath xpath = XPathFactory.newInstance().newXPath();
            Document doc = docBuild.parse(in, "UTF-8");
            tmpSectionData = new SectionData();
            try {
                SectionData.Item[] itemArray = SectionData.Item.values();
                int n = itemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SectionData.Item item = itemArray[n2];
                    if (item == SectionData.Item.Path) {
                        tmpSectionData.put(item, sectionInfoFile.getParent());
                    } else {
                        Node node = ((NodeList)xpath.evaluate("/xml/" + (Object)((Object)item), doc, XPathConstants.NODESET)).item(0).getFirstChild();
                        if (node != null) {
                            tmpSectionData.put(item, node.getNodeValue());
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tmpSectionData;
    }

    private static void addElement(Document doc, Element targetElement, String key, String val) {
        Element subEle = doc.createElement(key);
        subEle.appendChild(doc.createTextNode(val));
        targetElement.appendChild(subEle);
    }

    public static File writeBookInfoXml(File exportDir, NSDictionary bind, BindObject MBookBinder) {
        StreamResult result = null;
        File bookInfoXml = new File(String.valueOf(exportDir.getPath()) + File.separator + "BookInfo.xml");
        System.out.println("writeBookInfoXml " + bookInfoXml.getPath());
        try {
            try {
                if (!exportDir.exists()) {
                    exportDir.mkdir();
                }
                if (!bookInfoXml.exists()) {
                    bookInfoXml.createNewFile();
                }
                DocumentBuilderFactory docBuildFact = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuild = docBuildFact.newDocumentBuilder();
                Document doc = docBuild.newDocument();
                Element rootEle = doc.createElement("xml");
                doc.appendChild(rootEle);
                XmlParser.addElement(doc, rootEle, VERSION, "2.5");
                XmlParser.addElement(doc, rootEle, "BookTitle", bind.objectForKey("BookTitle").toString());
                XmlParser.addElement(doc, rootEle, "SubTitle", bind.objectForKey("SubTitle").toString());
                XmlParser.addElement(doc, rootEle, "Author", bind.objectForKey("Author").toString());
                XmlParser.addElement(doc, rootEle, "Publisher", bind.objectForKey("Publisher").toString());
                XmlParser.addElement(doc, rootEle, DESCRIPTION, bind.objectForKey(DESCRIPTION).toString());
                XmlParser.addElement(doc, rootEle, "iOS.InAppID", bind.objectForKey("iOSInAppID").toString());
                XmlParser.addElement(doc, rootEle, "InAppStartPage", bind.objectForKey("InAppStartPage").toString());
                XmlParser.addElement(doc, rootEle, "CoverImage", "cover.jpg");
                XmlParser.addElement(doc, rootEle, "CoverThumbnail", "thumb.jpg");
                XmlParser.addElement(doc, rootEle, "CoverMedium", "medium.jpg");
                XmlParser.addElement(doc, rootEle, "CoverMovie", new File(bind.objectForKey("CoverMovie").toString()).getName());
                XmlParser.addElement(doc, rootEle, "DisableWebboxReaction", bind.objectForKey("BlockWebbox").toString().equals("1") ? "YES" : "NO");
                XmlParser.addElement(doc, rootEle, "PageCurling", bind.objectForKey("PageCurling").toString().equals("1") ? "YES" : "NO");
                XmlParser.addElement(doc, rootEle, "PageVolumeOff", bind.objectForKey("PageVolumeOff").toString().equals("1") ? "YES" : "NO");
                XmlParser.addElement(doc, rootEle, "ViewMode", bind.objectForKey("Orientation").toString());
                XmlParser.addElement(doc, rootEle, NUMBER_OF_PAGES, String.valueOf(MBookBinder.countPageOfArySectionData()));
                XmlParser.addElement(doc, rootEle, PAGE_SIZE, MBookBinder.getArySectionData().get(0).getPageSize());
                Element secEle = doc.createElement("Sections");
                rootEle.appendChild(secEle);
                for (SectionData sectiondata : MBookBinder.getArySectionData()) {
                    Element tmpSecEle = doc.createElement("Section");
                    secEle.appendChild(tmpSecEle);
                    XmlParser.addElement(doc, tmpSecEle, SECTION_TITLE, sectiondata.getName().substring(0, sectiondata.getName().indexOf(".section")));
                    XmlParser.addElement(doc, tmpSecEle, "SectionFolder", sectiondata.getName());
                    XmlParser.addElement(doc, tmpSecEle, DESCRIPTION, " ");
                    XmlParser.addElement(doc, tmpSecEle, "ShowInTOC", "YES");
                    XmlParser.addElement(doc, tmpSecEle, NUMBER_OF_PAGES, sectiondata.getNumberOfPages());
                }
                if (MBookBinder.getAryTocData().size() > 0) {
                    Element tocEle = doc.createElement("TOC");
                    rootEle.appendChild(tocEle);
                    for (TocData tocdata : MBookBinder.getAryTocData()) {
                        Element tmpTocEle = doc.createElement("Item");
                        tocEle.appendChild(tmpTocEle);
                        XmlParser.addElement(doc, tmpTocEle, "Title", tocdata.getTitle());
                        XmlParser.addElement(doc, tmpTocEle, "SectionName", tocdata.getSectionRealName());
                        XmlParser.addElement(doc, tmpTocEle, "PageIndex", tocdata.getPageIndex());
                        XmlParser.addElement(doc, tmpTocEle, DESCRIPTION, tocdata.getDescription());
                    }
                }
                doc.setXmlStandalone(true);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("cdata-section-elements", "BookTitle SubTitle Author Publisher Description CoverImage SectionTitle SectionFolder Description Title SectionName PageIndex");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                DOMSource source = new DOMSource(doc);
                result = new StreamResult(new FileOutputStream(bookInfoXml));
                transformer.transform(source, result);
                System.out.println("File saved!");
            }
            catch (Exception e) {
                e.printStackTrace();
                bookInfoXml = null;
                try {
                    result.getOutputStream().flush();
                    result.getOutputStream().close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                result.getOutputStream().flush();
                result.getOutputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bookInfoXml;
    }
}

