/*
 * Decompiled with CFR 0.152.
 */
package mbookbinder.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import net.sf.jazzlib.ZipEntry;
import net.sf.jazzlib.ZipInputStream;
import net.sf.jazzlib.ZipOutputStream;

public class ZipUtils {
    private static final byte[] buf = new byte[1024];

    public static void createZipFile(String targetPath, String zipPath) throws Exception {
        ZipUtils.createZipFile(targetPath, zipPath, false);
    }

    public static void createZipFile(String targetPath, String zipPath, boolean isDirCre) throws Exception {
        File fTargetPath = new File(targetPath);
        File[] files = null;
        files = fTargetPath.isDirectory() ? fTargetPath.listFiles() : new File[]{fTargetPath};
        File path = new File(zipPath);
        File dir = null;
        dir = new File(path.getParent());
        if (isDirCre) {
            dir.mkdirs();
        }
        ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(path));
        ZipUtils.makeZipFile(files, zipOut, String.valueOf(fTargetPath.getName()) + "/");
        zipOut.close();
    }

    public static void createZipFile(String[] targetFiles, String zipPath) throws Exception {
        ZipUtils.createZipFile(targetFiles, zipPath, false);
    }

    public static void createZipFile(String[] targetFiles, String zipPath, boolean isDirCre) throws Exception {
        File[] files = new File[targetFiles.length];
        int i = 0;
        while (i < files.length) {
            files[i] = new File(targetFiles[i]);
            ++i;
        }
        File path = new File(zipPath);
        File dir = null;
        dir = new File(path.getParent());
        if (isDirCre) {
            dir.mkdirs();
        }
        ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(path));
        ZipUtils.makeZipFile(files, zipOut, "");
        zipOut.close();
    }

    public static void unZipFile(String targetZip, String completeDir) throws Exception {
        ZipUtils.unZipFile(targetZip, completeDir, false);
    }

    public static void unZipFile(String targetZip, String completeDir, boolean isDirCre) throws Exception {
        try (ZipInputStream in = null;){
            try {
                File fCompleteDir = null;
                fCompleteDir = new File(completeDir);
                if (isDirCre) {
                    fCompleteDir.mkdirs();
                }
                in = new ZipInputStream(new FileInputStream(targetZip));
                ZipEntry entry = null;
                while ((entry = in.getNextEntry()) != null) {
                    int bytes_read;
                    System.out.println("entry : " + entry);
                    String entryName = entry.getName();
                    if (entry.getName().lastIndexOf("/") > 0) {
                        String mkDirNm = entryName.substring(0, entryName.lastIndexOf("/"));
                        System.out.println("mkDirNm : " + mkDirNm);
                        new File(String.valueOf(completeDir) + mkDirNm).mkdirs();
                    }
                    FileOutputStream out = new FileOutputStream(String.valueOf(completeDir) + entry.getName());
                    while ((bytes_read = in.read(buf)) != -1) {
                        System.out.println("bytes_read : " + bytes_read);
                        out.write(buf, 0, bytes_read);
                    }
                    out.close();
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
    }

    public static byte[] compressToZip(byte[] src) throws Exception {
        byte[] retSrc = null;
        try (ByteArrayOutputStream baos = null;){
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(src);
                baos = new ByteArrayOutputStream();
                ZipOutputStream zos = new ZipOutputStream(baos);
                zos.putNextEntry(new ZipEntry("temp.tmp"));
                int bytes_read = 0;
                while ((bytes_read = bais.read(buf)) != -1) {
                    zos.write(buf, 0, bytes_read);
                }
                bais.close();
                zos.close();
                retSrc = baos.toByteArray();
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        return retSrc;
    }

    private static void makeZipFile(byte[] src, String zipPath) throws Exception {
        FileOutputStream fos = null;
        ByteArrayInputStream bais = null;
        try {
            try {
                fos = new FileOutputStream(zipPath);
                bais = new ByteArrayInputStream(src);
                int bytes_read = 0;
                while ((bytes_read = bais.read(buf)) != -1) {
                    fos.write(buf, 0, bytes_read);
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        finally {
            fos.close();
            bais.close();
        }
    }

    public static byte[] unZip(byte[] src) throws Exception {
        byte[] retSrc = null;
        ByteArrayOutputStream baos = null;
        ZipInputStream zis = null;
        int bytes_read = 0;
        try {
            try {
                zis = new ZipInputStream(new ByteArrayInputStream(src));
                baos = new ByteArrayOutputStream();
                zis.getNextEntry();
                while ((bytes_read = zis.read(buf)) != -1) {
                    baos.write(buf, 0, bytes_read);
                }
                retSrc = baos.toByteArray();
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        finally {
            baos.close();
            zis.close();
        }
        return retSrc;
    }

    public static byte[] compressToZip(String src) throws Exception {
        return ZipUtils.compressToZip(src.getBytes("UTF-8"));
    }

    public static void srcToZipFile(byte[] src, String zipPath) throws Exception {
        byte[] retSrc = null;
        retSrc = ZipUtils.compressToZip(src);
        ZipUtils.makeZipFile(retSrc, zipPath);
    }

    public static void srcToZipFile(String src, String zipPath) throws Exception {
        byte[] retSrc = null;
        retSrc = ZipUtils.compressToZip(src.getBytes("UTF-8"));
        ZipUtils.makeZipFile(retSrc, zipPath);
    }

    public static byte[] zipFileToSrc(String zipPath) throws Exception {
        byte[] retSrc = null;
        return retSrc;
    }

    public static void makeZipFile(File[] files, ZipOutputStream zipOut, String targetDir) throws Exception {
        int i = 0;
        while (i < files.length) {
            File compPath = new File(files[i].getPath());
            if (compPath.isDirectory()) {
                File[] subFiles = compPath.listFiles();
                ZipUtils.makeZipFile(subFiles, zipOut, String.valueOf(targetDir) + compPath.getName() + "/");
            } else {
                int data;
                FileInputStream in = new FileInputStream(compPath);
                zipOut.putNextEntry(new ZipEntry(String.valueOf(targetDir) + "/" + files[i].getName()));
                while ((data = in.read(buf)) > 0) {
                    zipOut.write(buf, 0, data);
                }
                zipOut.closeEntry();
                in.close();
            }
            ++i;
        }
    }
}

