/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jazzlib;

import net.sf.jazzlib.Adler32;
import net.sf.jazzlib.DataFormatException;
import net.sf.jazzlib.InflaterDynHeader;
import net.sf.jazzlib.InflaterHuffmanTree;
import net.sf.jazzlib.OutputWindow;
import net.sf.jazzlib.StreamManipulator;

public class Inflater {
    private static final int[] CPLENS = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258};
    private static final int[] CPLEXT;
    private static final int[] CPDIST;
    private static final int[] CPDEXT;
    private static final int DECODE_HEADER = 0;
    private static final int DECODE_DICT = 1;
    private static final int DECODE_BLOCKS = 2;
    private static final int DECODE_STORED_LEN1 = 3;
    private static final int DECODE_STORED_LEN2 = 4;
    private static final int DECODE_STORED = 5;
    private static final int DECODE_DYN_HEADER = 6;
    private static final int DECODE_HUFFMAN = 7;
    private static final int DECODE_HUFFMAN_LENBITS = 8;
    private static final int DECODE_HUFFMAN_DIST = 9;
    private static final int DECODE_HUFFMAN_DISTBITS = 10;
    private static final int DECODE_CHKSUM = 11;
    private static final int FINISHED = 12;
    private int mode;
    private int readAdler;
    private int neededBits;
    private int repLength;
    private int repDist;
    private int uncomprLen;
    private boolean isLastBlock;
    private int totalOut;
    private int totalIn;
    private boolean nowrap;
    private StreamManipulator input;
    private OutputWindow outputWindow;
    private InflaterDynHeader dynHeader;
    private InflaterHuffmanTree litlenTree;
    private InflaterHuffmanTree distTree;
    private Adler32 adler;

    static {
        int[] nArray = new int[29];
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[11] = 1;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 2;
        nArray[15] = 2;
        nArray[16] = 3;
        nArray[17] = 3;
        nArray[18] = 3;
        nArray[19] = 3;
        nArray[20] = 4;
        nArray[21] = 4;
        nArray[22] = 4;
        nArray[23] = 4;
        nArray[24] = 5;
        nArray[25] = 5;
        nArray[26] = 5;
        nArray[27] = 5;
        CPLEXT = nArray;
        CPDIST = new int[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
        int[] nArray2 = new int[30];
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = 2;
        nArray2[7] = 2;
        nArray2[8] = 3;
        nArray2[9] = 3;
        nArray2[10] = 4;
        nArray2[11] = 4;
        nArray2[12] = 5;
        nArray2[13] = 5;
        nArray2[14] = 6;
        nArray2[15] = 6;
        nArray2[16] = 7;
        nArray2[17] = 7;
        nArray2[18] = 8;
        nArray2[19] = 8;
        nArray2[20] = 9;
        nArray2[21] = 9;
        nArray2[22] = 10;
        nArray2[23] = 10;
        nArray2[24] = 11;
        nArray2[25] = 11;
        nArray2[26] = 12;
        nArray2[27] = 12;
        nArray2[28] = 13;
        nArray2[29] = 13;
        CPDEXT = nArray2;
    }

    public Inflater() {
        this(false);
    }

    public Inflater(boolean nowrap) {
        this.nowrap = nowrap;
        this.adler = new Adler32();
        this.input = new StreamManipulator();
        this.outputWindow = new OutputWindow();
        this.mode = nowrap ? 2 : 0;
    }

    protected void finalize() {
    }

    public void end() {
        this.outputWindow = null;
        this.input = null;
        this.dynHeader = null;
        this.litlenTree = null;
        this.distTree = null;
        this.adler = null;
    }

    public boolean finished() {
        return this.mode == 12 && this.outputWindow.getAvailable() == 0;
    }

    public int getAdler() {
        return this.needsDictionary() ? this.readAdler : (int)this.adler.getValue();
    }

    public int getRemaining() {
        return this.input.getAvailableBytes();
    }

    public int getTotalIn() {
        return this.totalIn - this.getRemaining();
    }

    public int getTotalOut() {
        return this.totalOut;
    }

    public int inflate(byte[] buf) throws DataFormatException {
        return this.inflate(buf, 0, buf.length);
    }

    public int inflate(byte[] buf, int off, int len) throws DataFormatException {
        if (len == 0) {
            return 0;
        }
        if (off < 0 || off > off + len || off + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int count = 0;
        do {
            if (this.mode == 11) continue;
            int more = this.outputWindow.copyOutput(buf, off, len);
            this.adler.update(buf, off, more);
            off += more;
            count += more;
            this.totalOut += more;
            if ((len -= more) != 0) continue;
            return count;
        } while (this.decode() || this.outputWindow.getAvailable() > 0 && this.mode != 11);
        return count;
    }

    public boolean needsDictionary() {
        return this.mode == 1 && this.neededBits == 0;
    }

    public boolean needsInput() {
        return this.input.needsInput();
    }

    public void reset() {
        this.mode = this.nowrap ? 2 : 0;
        this.totalOut = 0;
        this.totalIn = 0;
        this.input.reset();
        this.outputWindow.reset();
        this.dynHeader = null;
        this.litlenTree = null;
        this.distTree = null;
        this.isLastBlock = false;
        this.adler.reset();
    }

    public void setDictionary(byte[] buffer) {
        this.setDictionary(buffer, 0, buffer.length);
    }

    public void setDictionary(byte[] buffer, int off, int len) {
        if (!this.needsDictionary()) {
            throw new IllegalStateException();
        }
        this.adler.update(buffer, off, len);
        if ((int)this.adler.getValue() != this.readAdler) {
            throw new IllegalArgumentException("Wrong adler checksum");
        }
        this.adler.reset();
        this.outputWindow.copyDict(buffer, off, len);
        this.mode = 2;
    }

    public void setInput(byte[] buf) {
        this.setInput(buf, 0, buf.length);
    }

    public void setInput(byte[] buf, int off, int len) {
        this.input.setInput(buf, off, len);
        this.totalIn += len;
    }

    private boolean decodeHeader() throws DataFormatException {
        int header = this.input.peekBits(16);
        if (header < 0) {
            return false;
        }
        this.input.dropBits(16);
        header = (header << 8 | header >> 8) & 0xFFFF;
        if (header % 31 != 0) {
            throw new DataFormatException("Header checksum illegal");
        }
        if ((header & 0xF00) != 2048) {
            throw new DataFormatException("Compression Method unknown");
        }
        if ((header & 0x20) == 0) {
            this.mode = 2;
        } else {
            this.mode = 1;
            this.neededBits = 32;
        }
        return true;
    }

    private boolean decodeDict() {
        while (this.neededBits > 0) {
            int dictByte = this.input.peekBits(8);
            if (dictByte < 0) {
                return false;
            }
            this.input.dropBits(8);
            this.readAdler = this.readAdler << 8 | dictByte;
            this.neededBits -= 8;
        }
        return false;
    }

    private boolean decodeHuffman() throws DataFormatException {
        int free = this.outputWindow.getFreeSpace();
        while (free >= 258) {
            switch (this.mode) {
                case 7: {
                    int symbol;
                    while (((symbol = this.litlenTree.getSymbol(this.input)) & 0xFFFFFF00) == 0) {
                        this.outputWindow.write(symbol);
                        if (--free >= 258) continue;
                        return true;
                    }
                    if (symbol < 257) {
                        if (symbol < 0) {
                            return false;
                        }
                        this.distTree = null;
                        this.litlenTree = null;
                        this.mode = 2;
                        return true;
                    }
                    try {
                        this.repLength = CPLENS[symbol - 257];
                        this.neededBits = CPLEXT[symbol - 257];
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        throw new DataFormatException("Illegal rep length code");
                    }
                }
                case 8: {
                    int i;
                    if (this.neededBits > 0) {
                        this.mode = 8;
                        i = this.input.peekBits(this.neededBits);
                        if (i < 0) {
                            return false;
                        }
                        this.input.dropBits(this.neededBits);
                        this.repLength += i;
                    }
                    this.mode = 9;
                }
                case 9: {
                    int symbol = this.distTree.getSymbol(this.input);
                    if (symbol < 0) {
                        return false;
                    }
                    try {
                        this.repDist = CPDIST[symbol];
                        this.neededBits = CPDEXT[symbol];
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        throw new DataFormatException("Illegal rep dist code");
                    }
                }
                case 10: {
                    int i;
                    if (this.neededBits > 0) {
                        this.mode = 10;
                        i = this.input.peekBits(this.neededBits);
                        if (i < 0) {
                            return false;
                        }
                        this.input.dropBits(this.neededBits);
                        this.repDist += i;
                    }
                    this.outputWindow.repeat(this.repLength, this.repDist);
                    free -= this.repLength;
                    this.mode = 7;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return true;
    }

    private boolean decodeChksum() throws DataFormatException {
        while (this.neededBits > 0) {
            int chkByte = this.input.peekBits(8);
            if (chkByte < 0) {
                return false;
            }
            this.input.dropBits(8);
            this.readAdler = this.readAdler << 8 | chkByte;
            this.neededBits -= 8;
        }
        if ((int)this.adler.getValue() != this.readAdler) {
            throw new DataFormatException("Adler chksum doesn't match: " + Integer.toHexString((int)this.adler.getValue()) + " vs. " + Integer.toHexString(this.readAdler));
        }
        this.mode = 12;
        return false;
    }

    private boolean decode() throws DataFormatException {
        switch (this.mode) {
            case 0: {
                return this.decodeHeader();
            }
            case 1: {
                return this.decodeDict();
            }
            case 11: {
                return this.decodeChksum();
            }
            case 2: {
                if (this.isLastBlock) {
                    if (this.nowrap) {
                        this.mode = 12;
                        return false;
                    }
                    this.input.skipToByteBoundary();
                    this.neededBits = 32;
                    this.mode = 11;
                    return true;
                }
                int type = this.input.peekBits(3);
                if (type < 0) {
                    return false;
                }
                this.input.dropBits(3);
                if ((type & 1) != 0) {
                    this.isLastBlock = true;
                }
                switch (type >> 1) {
                    case 0: {
                        this.input.skipToByteBoundary();
                        this.mode = 3;
                        break;
                    }
                    case 1: {
                        this.litlenTree = InflaterHuffmanTree.defLitLenTree;
                        this.distTree = InflaterHuffmanTree.defDistTree;
                        this.mode = 7;
                        break;
                    }
                    case 2: {
                        this.dynHeader = new InflaterDynHeader();
                        this.mode = 6;
                        break;
                    }
                    default: {
                        throw new DataFormatException("Unknown block type " + type);
                    }
                }
                return true;
            }
            case 3: {
                this.uncomprLen = this.input.peekBits(16);
                if (this.uncomprLen < 0) {
                    return false;
                }
                this.input.dropBits(16);
                this.mode = 4;
            }
            case 4: {
                int nlen = this.input.peekBits(16);
                if (nlen < 0) {
                    return false;
                }
                this.input.dropBits(16);
                if (nlen != (this.uncomprLen ^ 0xFFFF)) {
                    throw new DataFormatException("broken uncompressed block");
                }
                this.mode = 5;
            }
            case 5: {
                int more = this.outputWindow.copyStored(this.input, this.uncomprLen);
                this.uncomprLen -= more;
                if (this.uncomprLen == 0) {
                    this.mode = 2;
                    return true;
                }
                return !this.input.needsInput();
            }
            case 6: {
                if (!this.dynHeader.decode(this.input)) {
                    return false;
                }
                this.litlenTree = this.dynHeader.buildLitLenTree();
                this.distTree = this.dynHeader.buildDistTree();
                this.mode = 7;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return this.decodeHuffman();
            }
            case 12: {
                return false;
            }
        }
        throw new IllegalStateException();
    }
}

