/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jazzlib;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sf.jazzlib.DataFormatException;
import net.sf.jazzlib.Inflater;
import net.sf.jazzlib.ZipException;

public class InflaterInputStream
extends FilterInputStream {
    protected Inflater inf;
    protected byte[] buf;
    protected int len = 0;
    private byte[] onebytebuffer = new byte[1];

    public InflaterInputStream(InputStream in) {
        this(in, new Inflater(), 4096);
    }

    public InflaterInputStream(InputStream in, Inflater inf) {
        this(in, inf, 4096);
    }

    public InflaterInputStream(InputStream in, Inflater inf, int size) {
        super(in);
        if (in == null) {
            throw new NullPointerException("in may not be null");
        }
        if (inf == null) {
            throw new NullPointerException("inf may not be null");
        }
        if (size < 0) {
            throw new IllegalArgumentException("size may not be negative");
        }
        this.inf = inf;
        this.buf = new byte[size];
    }

    public int available() throws IOException {
        return this.inf.finished() ? 0 : 1;
    }

    public synchronized void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.in = null;
    }

    protected void fill() throws IOException {
        if (this.in == null) {
            throw new ZipException("InflaterInputStream is closed");
        }
        this.len = this.in.read(this.buf, 0, this.buf.length);
        if (this.len < 0) {
            throw new ZipException("Deflated stream ends early.");
        }
        this.inf.setInput(this.buf, 0, this.len);
    }

    public int read() throws IOException {
        int nread = this.read(this.onebytebuffer, 0, 1);
        if (nread > 0) {
            return this.onebytebuffer[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        while (true) {
            int count;
            try {
                count = this.inf.inflate(b, off, len);
            }
            catch (DataFormatException dfe) {
                throw new ZipException(dfe.getMessage());
            }
            if (count > 0) {
                return count;
            }
            if (this.inf.needsDictionary() | this.inf.finished()) {
                return -1;
            }
            if (!this.inf.needsInput()) break;
            this.fill();
        }
        throw new InternalError("Don't know what to do");
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        if (n == 0L) {
            return 0L;
        }
        int buflen = n > 2048L ? 2048 : (int)n;
        byte[] tmpbuf = new byte[buflen];
        long origN = n;
        while (n > 0L) {
            int numread = this.read(tmpbuf, 0, n > (long)buflen ? buflen : (int)n);
            if (numread <= 0) break;
            n -= (long)numread;
        }
        return origN - n;
    }
}

