/*
 * Decompiled with CFR 0.152.
 */
package kr.co.soluwin.installer;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.UIManager;
import kr.co.soluwin.installer.data.Version;
import kr.co.soluwin.installer.resource.Strings;
import kr.co.soluwin.installer.ui.IntroPanel;
import kr.co.soluwin.installer.ui.ManagerFrame;

public class Installer {
    private static final Logger logger = Logger.getLogger(Installer.class.getName());
    public static final Version INSTALLER_VERSION = new Version("1.0.5");
    public static Version BINDER_VERSION = null;
    public static Version EXTENSION_VERSION = null;
    public static final boolean isWindow = System.getProperty("os.name").toLowerCase().startsWith("win");
    private static ManagerFrame managerFrame;

    public static void main(String ... args) {
        final JWindow window = new JWindow();
        try {
            JLabel splashLabel = new JLabel();
            window.setBackground(new Color(0, 0, 0, 0));
            BufferedImage img = ImageIO.read(IntroPanel.class.getResource("/kr/co/soluwin/installer/resource/splash.png"));
            splashLabel.setIcon(new ImageIcon(img));
            window.getContentPane().add((Component)splashLabel, 0);
            window.pack();
            window.setLocationRelativeTo(null);
            window.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Installer.initInstaller();
        Installer.initVersion();
        managerFrame = new ManagerFrame();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                managerFrame.setVisible(true);
                window.setVisible(false);
            }
        });
    }

    private static void initInstaller() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            UIManager.put("TextPane.font", new Font("gulim", 0, 12));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initVersion() {
        try {
            File tmp;
            block16: {
                tmp = File.createTempFile("tempBinder", ".jar");
                Throwable throwable = null;
                Object var2_4 = null;
                try {
                    ReadableByteChannel channel = Channels.newChannel(Installer.class.getResourceAsStream(Strings.getBinderJarPath()));
                    try {
                        try (FileChannel fileChannel = new RandomAccessFile(tmp, "rw").getChannel();){
                            ByteBuffer bb = ByteBuffer.allocate(1024);
                            while (channel.read(bb) > 0) {
                                bb.flip();
                                fileChannel.write(bb);
                                bb.clear();
                            }
                        }
                        if (channel == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (channel == null) throw throwable;
                        channel.close();
                        throw throwable;
                    }
                    channel.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            tmp.setExecutable(true);
            BINDER_VERSION = Version.getBinderVersion(tmp.getPath());
            tmp.delete();
            EXTENSION_VERSION = Version.getExtensionVersion(Strings.getExtensionPath()[3]);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

