/*
 * Decompiled with CFR 0.152.
 */
package kr.co.soluwin.installer.model;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.AbstractBorder;
import javax.swing.table.TableCellRenderer;
import kr.co.soluwin.installer.util.FontManager;

public class IndesignTableRenderer
implements TableCellRenderer {
    private int columnCount = 0;

    public IndesignTableRenderer(int columnCount) {
        this.columnCount = columnCount;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent comp;
        if (value instanceof Boolean) {
            comp = new JCheckBox();
            ImageIcon noIcon = new ImageIcon(IndesignTableRenderer.class.getResource("/kr/co/soluwin/installer/resource/select_no.png"));
            ImageIcon yesIcon = new ImageIcon(IndesignTableRenderer.class.getResource("/kr/co/soluwin/installer/resource/select_yes.png"));
            ((JCheckBox)comp).setIcon(noIcon);
            ((JCheckBox)comp).setSelectedIcon(yesIcon);
            ((JCheckBox)comp).setSelected(value != null && (Boolean)value != false);
            ((JCheckBox)comp).setBorderPainted(true);
            ((JCheckBox)comp).setHorizontalAlignment(0);
        } else {
            comp = new JLabel();
            ((JLabel)comp).setText(value == null ? "" : " " + value.toString());
        }
        comp.setFont(FontManager.Nanum.deriveFont(12.0f));
        comp.setBackground(Color.white);
        comp.setBorder(new IndesignBorder(row, column));
        comp.setOpaque(true);
        return comp;
    }

    class IndesignBorder
    extends AbstractBorder {
        private Color verticalColor = Color.decode("#A8A8A8");
        private Color horizontalColor = Color.decode("#E4E4E4");
        private int row;
        private int column;
        private int thickness = 2;

        public IndesignBorder(int row, int column) {
            this.row = row;
            this.column = column;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Insets insets = this.getBorderInsets();
            Graphics2D g2 = (Graphics2D)g;
            g2.translate(x, y);
            g2.setColor(this.horizontalColor);
            g2.fillRect(insets.left, height - insets.bottom, width - insets.left, insets.bottom);
            g2.setColor(this.verticalColor);
            if (insets.right != 0) {
                g2.setStroke(new BasicStroke(insets.right, 0, 2, 1.0f, new float[]{2.0f}, 1.0f));
                g2.drawLine(width - insets.right, 0, width - insets.right, height);
            }
        }

        public Insets getBorderInsets() {
            Insets insets = new Insets(0, 0, 0, 0);
            if (this.row != -1 && this.column > 0 && this.column < IndesignTableRenderer.this.columnCount - 1) {
                insets.right = this.thickness;
            }
            if (this.row == -1) {
                insets.bottom = this.thickness;
            }
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return super.isBorderOpaque();
        }
    }
}

