/*
 * Decompiled with CFR 0.152.
 */
package kr.co.soluwin.installer.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import kr.co.soluwin.installer.ui.IntroPanel;
import kr.co.soluwin.installer.ui.ManagerFrame;
import kr.co.soluwin.installer.util.FontManager;

public class DefaultPanel
extends JPanel {
    private JButton btnLeft;
    private JButton btnRight;
    private JButton btnSub;
    private JPanel footerPanel;
    private static ManagerFrame mParentFrame;
    private JLabel lblTitleLogo;
    private JLabel lblSubTitlePane;
    private JTextPane taDesc;
    private JLabel lblCopyright;
    private JLabel lblLogo;
    private static int panelIndex;

    static {
        panelIndex = 0;
    }

    public DefaultPanel(ManagerFrame parentFrame) {
        ++panelIndex;
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createLineBorder(Color.decode("#dcdddd"), 1));
        mParentFrame = parentFrame;
        this.setPreferredSize(new Dimension(680, 460));
        this.setLayout(null);
        this.lblTitleLogo = new JLabel("");
        this.add(this.lblTitleLogo);
        this.lblTitleLogo.setBounds(29, 25, 324, 38);
        this.lblSubTitlePane = new JLabel();
        this.lblSubTitlePane.setBounds(28, 90, 533, 38);
        this.lblSubTitlePane.setFont(FontManager.Nanum_Bold.deriveFont(0, 18.0f));
        this.lblSubTitlePane.setForeground(Color.decode("#898989"));
        this.lblSubTitlePane.setOpaque(false);
        this.lblSubTitlePane.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.add(this.lblSubTitlePane);
        this.taDesc = new JTextPane(new DefaultStyledDocument());
        this.taDesc.setBounds(28, 135, 533, 192);
        this.taDesc.setOpaque(false);
        this.taDesc.setEnabled(false);
        this.taDesc.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MouseEvent newE = this.adjuestEvent(e);
            }

            private MouseEvent adjuestEvent(MouseEvent e) {
                return new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), e.getX() + DefaultPanel.this.taDesc.getX(), e.getY() + DefaultPanel.this.taDesc.getY(), e.getClickCount(), e.isPopupTrigger());
            }
        });
        this.taDesc.setForeground(Color.decode("#898989"));
        this.taDesc.setFont(FontManager.Nanum.deriveFont(0, 14.0f));
        SimpleAttributeSet set = new SimpleAttributeSet(this.taDesc.getParagraphAttributes());
        StyleConstants.setLineSpacing(set, 0.6f);
        this.taDesc.setParagraphAttributes(set, true);
        this.add(this.taDesc);
        this.btnLeft = new JButton(""){

            @Override
            public void setEnabled(boolean b) {
                super.setEnabled(b);
                if (b) {
                    this.setBackground(Color.decode("#6267a4"));
                } else {
                    this.setBackground(Color.gray);
                }
            }
        };
        this.btnLeft.setBackground(Color.decode("#6267a4"));
        this.btnLeft.setForeground(Color.WHITE);
        this.btnLeft.setContentAreaFilled(false);
        this.btnLeft.setBorderPainted(false);
        this.btnLeft.setOpaque(true);
        this.btnLeft.setBounds(262, 368, 74, 27);
        this.btnLeft.setFont(FontManager.Nanum.deriveFont(0, 14.0f));
        this.add(this.btnLeft);
        this.btnRight = new JButton(""){

            @Override
            public void setEnabled(boolean b) {
                super.setEnabled(b);
                if (b) {
                    this.setBackground(Color.decode("#6267a4"));
                } else {
                    this.setBackground(Color.gray);
                }
            }
        };
        this.btnRight.setForeground(Color.WHITE);
        this.btnRight.setContentAreaFilled(false);
        this.btnRight.setBorderPainted(false);
        this.btnRight.setOpaque(true);
        this.btnRight.setBackground(Color.decode("#6267a4"));
        this.btnRight.setBounds(346, 368, 74, 27);
        this.btnRight.setFont(FontManager.Nanum.deriveFont(0, 14.0f));
        this.add(this.btnRight);
        this.btnSub = new JButton("ADD InDesign"){

            @Override
            public void setEnabled(boolean b) {
                super.setEnabled(b);
                if (b) {
                    this.setBackground(Color.decode("#6267a4"));
                } else {
                    this.setBackground(Color.gray);
                }
            }
        };
        this.btnSub.setBounds(537, 368, 112, 27);
        this.btnSub.setForeground(Color.decode("#6267a4"));
        this.btnSub.setBackground(Color.WHITE);
        this.btnSub.setOpaque(true);
        this.btnSub.setContentAreaFilled(false);
        this.btnSub.setBorder(BorderFactory.createLineBorder(Color.decode("#6267a4"), 1));
        this.btnSub.setFont(FontManager.Nanum.deriveFont(0, 14.0f));
        this.add(this.btnSub);
        this.footerPanel = new JPanel();
        this.footerPanel.setBounds(new Rectangle(1, 421, 678, 38));
        this.footerPanel.setBackground(Color.decode("#cccccc"));
        this.add(this.footerPanel);
        this.footerPanel.setLayout(new BoxLayout(this.footerPanel, 0));
        this.lblCopyright = new JLabel("Copyright \u00a9 2016 Soluwin Corp. All rights reserved.");
        this.lblCopyright.setPreferredSize(new Dimension(340, 38));
        this.lblCopyright.setMaximumSize(new Dimension(340, 38));
        this.lblCopyright.setMinimumSize(new Dimension(340, 38));
        this.lblCopyright.setHorizontalAlignment(2);
        this.lblCopyright.setForeground(Color.white);
        this.lblCopyright.setBorder(new EmptyBorder(10, 20, 0, 0));
        this.lblCopyright.setFont(FontManager.Din_Regular.deriveFont(0, 12.0f));
        this.footerPanel.add(this.lblCopyright);
        this.lblLogo = new JLabel("");
        ImageIcon imgIcon = new ImageIcon(DefaultPanel.class.getResource("/kr/co/soluwin/installer/resource/footer_logo.png"));
        this.lblLogo.setIcon(imgIcon);
        this.lblLogo.setSize(imgIcon.getIconWidth(), imgIcon.getIconHeight());
        this.lblLogo.setPreferredSize(new Dimension(340, 38));
        this.lblLogo.setMaximumSize(new Dimension(340, 38));
        this.lblLogo.setMinimumSize(new Dimension(340, 38));
        this.lblLogo.setBorder(new EmptyBorder(0, 0, 0, 25));
        this.lblLogo.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.footerPanel.add(this.lblLogo);
        this.setTitleLogo();
    }

    private void setTitleLogo() {
        try {
            String logoPath = "/kr/co/soluwin/installer/resource/step_" + panelIndex + ".png";
            BufferedImage img = ImageIO.read(IntroPanel.class.getResource(logoPath));
            int imageWidth = ((Image)img).getWidth(null);
            int imageHeight = ((Image)img).getHeight(null);
            this.lblTitleLogo.setIcon(new ImageIcon(img.getScaledInstance(imageWidth, imageHeight, 16)));
            this.lblTitleLogo.setSize(imageWidth, imageHeight);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void setSubTitle(String htmlBody) {
        this.lblSubTitlePane.setText(htmlBody);
    }

    protected void setDesc(String htmlBody) {
        this.taDesc.setText(htmlBody);
    }

    private void initButton(final ButtonType buttonType, JButton btn) {
        switch (buttonType) {
            case PREVIOUS: {
                btn.setText("\uc774\uc804");
                btn.setIcon(new ImageIcon(DefaultPanel.class.getResource("/kr/co/soluwin/installer/resource/pre.png")));
                btn.setIconTextGap(10);
                break;
            }
            case NEXT: 
            case SETUP: {
                btn.setText(buttonType == ButtonType.NEXT ? "\ub2e4\uc74c" : "\uc124\uce58");
                btn.setVerticalTextPosition(3);
                btn.setHorizontalTextPosition(2);
                btn.setIconTextGap(10);
                btn.setIcon(new ImageIcon(DefaultPanel.class.getResource("/kr/co/soluwin/installer/resource/next.png")));
                break;
            }
            case COMPLETE: {
                btn.setText("\uc644\ub8cc");
                btn.setIcon(new ImageIcon(DefaultPanel.class.getResource("/kr/co/soluwin/installer/resource/close.png")));
                break;
            }
            case CANCEL: {
                btn.setText("\ucde8\uc18c");
                break;
            }
            case NONE: {
                btn.setVisible(false);
            }
        }
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (buttonType) {
                    case PREVIOUS: {
                        mParentFrame.PreviousPanel();
                        break;
                    }
                    case NEXT: 
                    case SETUP: {
                        mParentFrame.nextPanel();
                        break;
                    }
                    case COMPLETE: 
                    case CANCEL: {
                        mParentFrame.closeFrame();
                        break;
                    }
                    case ADD_INDESIGN: {
                        DefaultPanel.this.subActionPerformed();
                    }
                }
            }
        });
    }

    protected void setLeftButton(ButtonType buttonType) {
        this.initButton(buttonType, this.btnLeft);
    }

    protected void setRightButton(ButtonType buttonType) {
        this.initButton(buttonType, this.btnRight);
    }

    protected void setSubButton(ButtonType buttonType) {
        this.initButton(buttonType, this.btnSub);
    }

    protected JButton getRightButton() {
        return this.btnRight;
    }

    protected ManagerFrame getMainFrame() {
        return mParentFrame;
    }

    protected void subActionPerformed() {
    }

    protected static enum ButtonType {
        PREVIOUS,
        NEXT,
        COMPLETE,
        CANCEL,
        SETUP,
        ADD_INDESIGN,
        NONE;

    }
}

