/*
 * Decompiled with CFR 0.152.
 */
package kr.co.soluwin.installer.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.swing.JOptionPane;
import kr.co.soluwin.installer.Installer;
import kr.co.soluwin.installer.data.ProgramData;
import kr.co.soluwin.installer.resource.Strings;
import kr.co.soluwin.installer.util.WinRegistry;
import org.apache.commons.io.FileUtils;

public class FileUtil {
    public static File setupBinderDir = new File(Installer.isWindow ? String.valueOf(System.getenv("ProgramFiles")) + File.separator + "mbook Binder" + File.separator + "mbook Binder.exe" : String.valueOf(File.separator) + "Applications" + File.separator + "mbook Binder" + File.separator + "mbook Binder.jar");
    private static final String BINDER_EXTENTION = ".bind";
    private static final String BINDER_PROGID = "binderfile";
    private static final String BINDER_EXTENTION_ROOT = "HKEY_CLASSES_ROOT\\.bind";
    private static final String BINDER_PROGID_ROOT = "HKEY_CLASSES_ROOT\\binderfile";
    private static final String BINDER_ICON_PATH = String.valueOf(setupBinderDir.getParent()) + File.separator + "bindFile.ico";

    public static void installBinderToDir(ProgramData programData) throws IOException {
        FileUtil.setAssociationBinder();
        String[] stringArray = Strings.getBinderPath();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String resPath = stringArray[n2];
            String targetFilePath = programData.getPath();
            targetFilePath = String.valueOf(targetFilePath) + File.separator + resPath.substring(resPath.lastIndexOf("/") + 1);
            FileUtil.copyResourceToFile(resPath, targetFilePath);
            ++n2;
        }
    }

    public static void installBinderShortcut() throws IOException, InterruptedException {
        File target = new File(setupBinderDir.getPath());
        File link = new File(Strings.getBinderLnkTargetPath());
        if (link.exists()) {
            link.delete();
        }
        System.out.println("installBinderShortcut : target - " + target.getPath() + " exists ? " + target.exists() + "  link - " + link.getPath() + " exists ? " + target.exists());
        if (Installer.isWindow) {
            Files.createLink(Paths.get(link.getPath(), new String[0]), Paths.get(target.getPath(), new String[0]));
        } else {
            String[] cmd = new String[]{"ln", "-s", target.getAbsolutePath(), link.getAbsolutePath()};
            int exitCode = Runtime.getRuntime().exec(cmd).waitFor();
            if (exitCode != 0) {
                throw new IOException("ln signaled an error with exit code " + exitCode);
            }
        }
    }

    public static void installExtensionToDir(ProgramData programData) throws IOException {
        String[] stringArray = Strings.getExtensionPath();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String resPath = stringArray[n2];
            String targetFilePath = programData.getPath();
            targetFilePath = String.valueOf(targetFilePath) + (resPath.contains("/SD/") ? Strings.STR_ORIGINAL_PATH_EXTENSION_SD : Strings.STR_ORIGINAL_PATH_EXTENSION_STARTUP) + resPath.substring(resPath.lastIndexOf("/") + 1);
            FileUtil.copyResourceToFile(resPath, targetFilePath);
            ++n2;
        }
    }

    public static void removeBinderToDir(ProgramData programData) {
        new File(String.valueOf(programData.getPath()) + File.separator + (Installer.isWindow ? "mbook Binder.exe" : "mbook Binder.jar")).delete();
    }

    public static void removeExtensionToDir(ProgramData programData) {
        String[] stringArray = Strings.getExtensionPath();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String resPath = stringArray[n2];
            FileUtil.deleteFileReferResource(resPath, programData.getPath());
            ++n2;
        }
    }

    public static void updateBinderToDir(ProgramData programData) throws IOException {
        FileUtil.removeBinderToDir(programData);
        FileUtil.installBinderToDir(programData);
    }

    public static void updateExtensionToDir(ProgramData programData) throws IOException {
        FileUtil.removeExtensionToDir(programData);
        FileUtil.installExtensionToDir(programData);
    }

    private static void showOptionPane(String title, String str) {
        JOptionPane.showMessageDialog(null, str, title, -1, null);
    }

    private static void setAssociationBinder() {
        if (WinRegistry.isAvailable()) {
            WinRegistry.createKey(BINDER_EXTENTION_ROOT);
            WinRegistry.writeValue(BINDER_EXTENTION_ROOT, "", BINDER_PROGID);
            WinRegistry.createKey("HKEY_CLASSES_ROOT\\binderfile\\DefaultIcon");
            WinRegistry.writeValue("HKEY_CLASSES_ROOT\\binderfile\\DefaultIcon", "", BINDER_ICON_PATH);
            WinRegistry.createKey("HKEY_CLASSES_ROOT\\binderfile\\shell\\open\\command");
            WinRegistry.writeValue("HKEY_CLASSES_ROOT\\binderfile\\shell\\open\\command", "", "\"" + setupBinderDir.getPath() + "\"" + "\"%1\"");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean existsExtensionFile(String compareDirPath) {
        try {
            String[] stringArray = Strings.getExtensionPath();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                String extensionRes = stringArray[n2];
                extensionRes = extensionRes.replace("/scripts/", "/Scripts/");
                extensionRes = extensionRes.replace("/SD/", "/SDScripts/");
                extensionRes = extensionRes.replace("/startup/", "/startup scripts/");
                extensionRes = extensionRes.replace("/", File.separator);
                extensionRes = extensionRes.substring(extensionRes.indexOf(String.valueOf(File.separator) + "Scripts" + File.separator));
                File compareFile = new File(String.valueOf(compareDirPath) + extensionRes);
                if (!compareFile.exists()) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private static void copyResourceToFile(String resPath, String targetFilePath) throws IOException {
        URL url = FileUtil.class.getResource(resPath);
        File targetFile = new File(targetFilePath);
        System.out.println("copyResourceToFile " + url.getPath() + "       " + targetFilePath);
        FileUtils.copyURLToFile(url, targetFile);
        targetFile.setReadable(true, false);
        targetFile.setWritable(true, false);
        targetFile.setExecutable(true, false);
    }

    private static void deleteFileReferResource(String resPath, String targetDirPath) {
        URL url = FileUtil.class.getResource(resPath);
        targetDirPath = String.valueOf(targetDirPath) + resPath.substring(resPath.lastIndexOf("/"));
        try {
            System.out.println(targetDirPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

