/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util;

import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.IDispatch;
import com.sun.jna.platform.win32.COM.util.ComThread;
import com.sun.jna.platform.win32.COM.util.IRunningObjectTable;
import com.sun.jna.platform.win32.COM.util.ProxyObject;
import com.sun.jna.platform.win32.COM.util.RunningObjectTable;
import com.sun.jna.platform.win32.COM.util.annotation.ComObject;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class Factory {
    ComThread comThread;
    WeakHashMap<ProxyObject, Integer> registeredObjects;

    public Factory() {
        this(new ComThread("Default Factory COM Thread", 5000L, new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e2) {
            }
        }));
    }

    public Factory(ComThread comThread) {
        this.comThread = comThread;
        this.registeredObjects = new WeakHashMap();
    }

    protected void finalize() throws Throwable {
        try {
            this.disposeAll();
        }
        finally {
            super.finalize();
        }
    }

    public ComThread getComThread() {
        return this.comThread;
    }

    public IRunningObjectTable getRunningObjectTable() {
        try {
            final PointerByReference rotPtr = new PointerByReference();
            WinNT.HRESULT hr = this.comThread.execute(new Callable<WinNT.HRESULT>(){

                @Override
                public WinNT.HRESULT call() throws Exception {
                    return Ole32.INSTANCE.GetRunningObjectTable(new WinDef.DWORD(0L), rotPtr);
                }
            });
            COMUtils.checkRC(hr);
            com.sun.jna.platform.win32.COM.RunningObjectTable raw = new com.sun.jna.platform.win32.COM.RunningObjectTable(rotPtr.getValue());
            RunningObjectTable rot = new RunningObjectTable(raw, this);
            return rot;
        }
        catch (InterruptedException e2) {
            throw new RuntimeException(e2);
        }
        catch (ExecutionException e3) {
            throw new RuntimeException(e3);
        }
        catch (TimeoutException e4) {
            throw new RuntimeException(e4);
        }
    }

    public <T> T createProxy(Class<T> comInterface, IDispatch dispatch) {
        ProxyObject jop = new ProxyObject(comInterface, dispatch, this);
        Object proxy = Proxy.newProxyInstance(comInterface.getClassLoader(), new Class[]{comInterface}, (InvocationHandler)jop);
        T result = comInterface.cast(proxy);
        return result;
    }

    <T> T createProxy(Class<T> comInterface, long unknownId, IDispatch dispatch) {
        ProxyObject jop = new ProxyObject(comInterface, unknownId, dispatch, this);
        Object proxy = Proxy.newProxyInstance(comInterface.getClassLoader(), new Class[]{comInterface}, (InvocationHandler)jop);
        T result = comInterface.cast(proxy);
        return result;
    }

    public <T> T createObject(Class<T> comInterface) {
        try {
            ComObject comObectAnnotation = comInterface.getAnnotation(ComObject.class);
            if (null == comObectAnnotation) {
                throw new COMException("createObject: Interface must define a value for either clsId or progId via the ComInterface annotation");
            }
            final Guid.GUID guid = this.discoverClsId(comObectAnnotation);
            final PointerByReference ptrDisp = new PointerByReference();
            WinNT.HRESULT hr = this.comThread.execute(new Callable<WinNT.HRESULT>(){

                @Override
                public WinNT.HRESULT call() throws Exception {
                    return Ole32.INSTANCE.CoCreateInstance(guid, null, 21, IDispatch.IID_IDISPATCH, ptrDisp);
                }
            });
            COMUtils.checkRC(hr);
            Dispatch d2 = new Dispatch(ptrDisp.getValue());
            T t = this.createProxy(comInterface, d2);
            int n2 = d2.Release();
            return t;
        }
        catch (InterruptedException e2) {
            throw new RuntimeException(e2);
        }
        catch (ExecutionException e3) {
            throw new RuntimeException(e3);
        }
        catch (TimeoutException e4) {
            throw new RuntimeException(e4);
        }
    }

    public <T> T fetchObject(Class<T> comInterface) {
        try {
            ComObject comObectAnnotation = comInterface.getAnnotation(ComObject.class);
            if (null == comObectAnnotation) {
                throw new COMException("createObject: Interface must define a value for either clsId or progId via the ComInterface annotation");
            }
            final Guid.GUID guid = this.discoverClsId(comObectAnnotation);
            final PointerByReference ptrDisp = new PointerByReference();
            WinNT.HRESULT hr = this.comThread.execute(new Callable<WinNT.HRESULT>(){

                @Override
                public WinNT.HRESULT call() throws Exception {
                    return OleAuto.INSTANCE.GetActiveObject(guid, null, ptrDisp);
                }
            });
            COMUtils.checkRC(hr);
            Dispatch d2 = new Dispatch(ptrDisp.getValue());
            T t = this.createProxy(comInterface, d2);
            d2.Release();
            return t;
        }
        catch (InterruptedException e2) {
            throw new RuntimeException(e2);
        }
        catch (ExecutionException e3) {
            throw new RuntimeException(e3);
        }
        catch (TimeoutException e4) {
            throw new RuntimeException(e4);
        }
    }

    Guid.GUID discoverClsId(ComObject annotation) {
        try {
            String clsIdStr = annotation.clsId();
            final String progIdStr = annotation.progId();
            if (null != clsIdStr && !clsIdStr.isEmpty()) {
                return new Guid.CLSID(clsIdStr);
            }
            if (null != progIdStr && !progIdStr.isEmpty()) {
                final Guid.CLSID.ByReference rclsid = new Guid.CLSID.ByReference();
                WinNT.HRESULT hr = this.comThread.execute(new Callable<WinNT.HRESULT>(){

                    @Override
                    public WinNT.HRESULT call() throws Exception {
                        return Ole32.INSTANCE.CLSIDFromProgID(progIdStr, rclsid);
                    }
                });
                COMUtils.checkRC(hr);
                return rclsid;
            }
            throw new COMException("ComObject must define a value for either clsId or progId");
        }
        catch (InterruptedException e2) {
            throw new RuntimeException(e2);
        }
        catch (ExecutionException e3) {
            throw new RuntimeException(e3);
        }
        catch (TimeoutException e4) {
            throw new RuntimeException(e4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ProxyObject proxyObject) {
        WeakHashMap<ProxyObject, Integer> weakHashMap = this.registeredObjects;
        synchronized (weakHashMap) {
            if (this.registeredObjects.containsKey(proxyObject)) {
                int r2 = this.registeredObjects.get(proxyObject);
                this.registeredObjects.put(proxyObject, r2 + 1);
            } else {
                this.registeredObjects.put(proxyObject, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ProxyObject proxyObject, int d2) {
        WeakHashMap<ProxyObject, Integer> weakHashMap = this.registeredObjects;
        synchronized (weakHashMap) {
            if (this.registeredObjects.containsKey(proxyObject)) {
                int r2 = this.registeredObjects.get(proxyObject);
                if (r2 > 1) {
                    this.registeredObjects.put(proxyObject, r2 - d2);
                } else {
                    this.registeredObjects.remove(proxyObject);
                }
            } else {
                throw new RuntimeException("Tried to dispose a ProxyObject that is not registered");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAll() {
        WeakHashMap<ProxyObject, Integer> weakHashMap = this.registeredObjects;
        synchronized (weakHashMap) {
            HashSet<ProxyObject> s = new HashSet<ProxyObject>(this.registeredObjects.keySet());
            for (ProxyObject proxyObject : s) {
                int r2 = this.registeredObjects.get(proxyObject);
                proxyObject.dispose(r2);
            }
            this.registeredObjects.clear();
        }
    }
}

