/*
 * Decompiled with CFR 0.152.
 */
package io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class ByteReader
extends InputStream {
    private static boolean le = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
    private InputStream stream;
    private int pos = 0;

    public ByteReader(InputStream in) {
        this.stream = in;
    }

    public int getPosition() {
        return this.pos;
    }

    public ByteReader changeEndiannes() {
        le = !le;
        return this;
    }

    public boolean seek(int n2) throws IOException {
        if (n2 <= 0) {
            return false;
        }
        int i2 = 0;
        while (i2 < n2) {
            this.read();
            ++i2;
        }
        return true;
    }

    @Override
    public int read() throws IOException {
        ++this.pos;
        return this.stream.read();
    }

    public long read2bytes() throws IOException {
        long b0 = this.read();
        long b1 = this.read();
        if (le) {
            return b0 | b1 << 8;
        }
        return b1 | b0 << 8;
    }

    public long read3bytes() throws IOException {
        long b0 = this.read();
        long b1 = this.read();
        long b2 = this.read();
        if (le) {
            return b0 | b1 << 8 | b2 << 16;
        }
        return b2 | b1 << 8 | b0 << 16;
    }

    public long read4bytes() throws IOException {
        long b0 = this.read();
        long b1 = this.read();
        long b2 = this.read();
        long b3 = this.read();
        if (le) {
            return b0 | b1 << 8 | b2 << 16 | b3 << 24;
        }
        return b3 | b2 << 8 | b1 << 16 | b0 << 24;
    }

    public long read5bytes() throws IOException {
        long b0 = this.read();
        long b1 = this.read();
        long b2 = this.read();
        long b3 = this.read();
        long b4 = this.read();
        if (le) {
            return b0 | b1 << 8 | b2 << 16 | b3 << 24 | b4 << 32;
        }
        return b4 | b3 << 8 | b2 << 16 | b1 << 24 | b0 << 32;
    }

    public long read6bytes() throws IOException {
        long b0 = this.read();
        long b1 = this.read();
        long b2 = this.read();
        long b3 = this.read();
        long b4 = this.read();
        long b5 = this.read();
        if (le) {
            return b0 | b1 << 8 | b2 << 16 | b3 << 24 | b4 << 32 | b5 << 40;
        }
        return b5 | b4 << 8 | b3 << 16 | b2 << 24 | b1 << 32 | b0 << 40;
    }

    public long read7bytes() throws IOException {
        long b0 = this.read();
        long b1 = this.read();
        long b2 = this.read();
        long b3 = this.read();
        long b4 = this.read();
        long b5 = this.read();
        long b6 = this.read();
        if (le) {
            return b0 | b1 << 8 | b2 << 16 | b3 << 24 | b4 << 32 | b5 << 40 | b6 << 48;
        }
        return b6 | b5 << 8 | b4 << 16 | b3 << 24 | b2 << 32 | b1 << 40 | b0 << 48;
    }

    public long read8bytes() throws IOException {
        long b0 = this.read();
        long b1 = this.read();
        long b2 = this.read();
        long b3 = this.read();
        long b4 = this.read();
        long b5 = this.read();
        long b6 = this.read();
        long b7 = this.read();
        if (le) {
            return b0 | b1 << 8 | b2 << 16 | b3 << 24 | b4 << 32 | b5 << 40 | b6 << 48 | b7 << 56;
        }
        return b7 | b6 << 8 | b5 << 16 | b4 << 24 | b3 << 32 | b2 << 40 | b1 << 48 | b0 << 56;
    }

    public String readString(int sz) throws IOException {
        if (sz == 0) {
            return null;
        }
        byte[] buf = new byte[sz];
        int i2 = 0;
        while (i2 < sz) {
            int b2 = this.read();
            if (b2 == 0) break;
            buf[i2] = (byte)b2;
            ++i2;
        }
        if (i2 == 0) {
            return null;
        }
        return new String(buf, 0, i2);
    }

    public String readUnicodeString(int sz) throws IOException {
        if (sz == 0) {
            return null;
        }
        char[] buf = new char[sz];
        int i2 = 0;
        while (i2 < sz) {
            char c2 = (char)this.read2bytes();
            if (c2 == '\u0000') break;
            buf[i2] = c2;
            ++i2;
        }
        if (i2 == 0) {
            return null;
        }
        return new String(buf, 0, i2);
    }

    public String readUnicodeString() throws IOException {
        int c2 = (int)this.read2bytes();
        char[] buf = new char[c2];
        int i2 = 0;
        while (i2 < c2) {
            buf[i2] = (char)this.read2bytes();
            ++i2;
        }
        return new String(buf);
    }
}

