/*
 * Decompiled with CFR 0.152.
 */
package kr.co.soluwin.installer.data;

import java.io.File;
import kr.co.soluwin.installer.Installer;
import kr.co.soluwin.installer.data.IndesignVersion;
import kr.co.soluwin.installer.data.SetupState;
import kr.co.soluwin.installer.data.Version;
import kr.co.soluwin.installer.util.FileUtil;
import kr.co.soluwin.installer.util.WinRegistry;

public class ProgramData {
    public static final String _NAME = "Indesign Ver.";
    public static final String _PATH = "path";
    public static final String _SETUPSTATE = "situation";
    public static final String _VERSION = "version";
    public static final String _WILLSETUP = "";
    public String name = null;
    public String path = null;
    public SetupState setupState = null;
    public Version version = null;
    private boolean isDefault = false;
    private boolean isBinder = false;
    private boolean willSetup = false;

    public ProgramData() {
    }

    public ProgramData(File dir, boolean isBinder) {
        this.name = dir.getName();
        this.path = dir.getPath();
        this.isBinder = isBinder;
        this.version = Version.getVersion(this);
        this.checkSetupStateChanged();
        if (this.setupState != SetupState.INSTALL) {
            this.willSetup = true;
        }
    }

    public static ProgramData getDefaultBinderData() {
        ProgramData retProgramData = null;
        File programDir = FileUtil.setupBinderDir;
        retProgramData = new ProgramData(programDir.getParentFile(), true);
        retProgramData.isDefault = true;
        return retProgramData;
    }

    public static ProgramData getDefaultIndesignData(IndesignVersion indesignVersion) {
        ProgramData retProgramData = null;
        if (Installer.isWindow) {
            File programDir;
            block20: {
                programDir = null;
                String clsId = _WILLSETUP;
                try {
                    try {
                        clsId = WinRegistry.readValue(indesignVersion.getClsIdPath(), _WILLSETUP);
                    }
                    catch (Exception e2) {
                        try {
                            clsId = WinRegistry.readValue(indesignVersion.getJClsIdPath(), _WILLSETUP);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!clsId.equals(_WILLSETUP)) {
                            try {
                                programDir = new File(WinRegistry.readValue("HKEY_CLASSES_ROOT\\CLSID\\" + clsId + "\\LocalServer32", _WILLSETUP)).getParentFile();
                            }
                            catch (Exception exception) {}
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (!clsId.equals(_WILLSETUP)) {
                        try {
                            programDir = new File(WinRegistry.readValue("HKEY_CLASSES_ROOT\\CLSID\\" + clsId + "\\LocalServer32", _WILLSETUP)).getParentFile();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (!clsId.equals(_WILLSETUP)) {
                    try {
                        programDir = new File(WinRegistry.readValue("HKEY_CLASSES_ROOT\\CLSID\\" + clsId + "\\LocalServer32", _WILLSETUP)).getParentFile();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (programDir != null) {
                retProgramData = new ProgramData(programDir, false);
                retProgramData.isDefault = true;
            }
        } else {
            File programDir = new File(String.valueOf(File.separator) + "Applications" + File.separator + indesignVersion.getMacName());
            if (programDir.exists()) {
                retProgramData = new ProgramData(programDir.getParentFile(), false);
                retProgramData.isDefault = true;
            }
        }
        return retProgramData;
    }

    public static ProgramData transFileToProgamData(File sourceF) {
        ProgramData retProgramData = null;
        if (Installer.isWindow) {
            if (new File(String.valueOf(sourceF.getPath()) + File.separator + "indesign.exe").exists()) {
                retProgramData = new ProgramData(sourceF, false);
            }
        } else if (new File(String.valueOf(sourceF.getPath()) + File.separator + sourceF.getName() + ".app").exists()) {
            retProgramData = new ProgramData(sourceF, false);
        }
        return retProgramData;
    }

    public void checkSetupStateChanged() {
        this.setupState = this.getVersion() != null && (this.isBinder && new File(String.valueOf(this.getPath()) + File.separator + "mbook Binder.exe").exists() || !this.isBinder && FileUtil.existsExtensionFile(this.getPath())) ? (this.getVersion().compareTo(this.isBinder ? Installer.BINDER_VERSION : Installer.EXTENSION_VERSION) < 0 ? SetupState.NEED_UPDATE : SetupState.INSTALL) : SetupState.NOT_INSTALL;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public SetupState getSetupStatus() {
        return this.setupState;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setSetupStatus(SetupState setupState) {
        this.setupState = setupState;
    }

    public void setVersion(String versionStr) {
        this.version = new Version(versionStr);
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isBinder() {
        return this.isBinder;
    }

    public boolean isWillSetup() {
        return this.willSetup;
    }

    public void setWillSetup(boolean willSetup) {
        this.willSetup = willSetup;
    }

    public String toString() {
        return "ProgramData [name=" + this.name + ", path=" + this.path + ", setupState=" + (Object)((Object)this.setupState) + ", version=" + this.version + ", isDefault=" + this.isDefault + ", isBinder=" + this.isBinder + ", willSetup=" + this.willSetup + "]";
    }
}

