/*
 * Decompiled with CFR 0.152.
 */
package kr.co.soluwin.installer.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public final class WinRegistry {
    private static final Map<String, Integer> hives = new HashMap<String, Integer>();
    private static final int INFO_HANDLE = 0;
    private static final int INFO_COUNT_KEYS = 0;
    private static final int INFO_ERROR_CODE = 1;
    private static final int INFO_COUNT_VALUES = 2;
    private static final int INFO_MAX_KEY_LENGTH = 3;
    private static final int INFO_MAX_VALUE_LENGTH = 4;
    private static final int KEY_READ = 131097;
    private static final int KEY_WRITE = 131078;
    private static final int ERROR_SUCCESS = 0;
    private static final int ERROR_FILE_NOT_FOUND = 2;
    private static final int ERROR_ACCESS_DENIED = 5;
    private static final Method regOpenKey;
    private static final Method regCloseKey;
    private static final Method regQueryValueEx;
    private static final Method regQueryInfoKey;
    private static final Method regEnumValue;
    private static final Method regEnumKeyEx;
    private static final Method regSetValueEx;
    private static final Method regDeleteValue;
    private static final Method regDeleteKey;
    private static final Method regCreateKeyEx;
    private static Throwable initError;

    static {
        hives.put("HKEY_CLASSES_ROOT", Integer.MIN_VALUE);
        hives.put("HKCR", Integer.MIN_VALUE);
        hives.put("HKEY_CURRENT_USER", -2147483647);
        hives.put("HKCU", -2147483647);
        hives.put("HKEY_LOCAL_MACHINE", -2147483646);
        hives.put("HKLM", -2147483646);
        hives.put("HKEY_USERS", -2147483645);
        hives.put("HKU", -2147483645);
        hives.put("HKEY_CURRENT_CONFIG", -2147483643);
        hives.put("HKCC", -2147483643);
        regOpenKey = WinRegistry.getMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
        regCloseKey = WinRegistry.getMethod("WindowsRegCloseKey", Integer.TYPE);
        regQueryValueEx = WinRegistry.getMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
        regQueryInfoKey = WinRegistry.getMethod("WindowsRegQueryInfoKey", Integer.TYPE);
        regEnumValue = WinRegistry.getMethod("WindowsRegEnumValue", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        regEnumKeyEx = WinRegistry.getMethod("WindowsRegEnumKeyEx", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        regSetValueEx = WinRegistry.getMethod("WindowsRegSetValueEx", Integer.TYPE, byte[].class, byte[].class);
        regDeleteValue = WinRegistry.getMethod("WindowsRegDeleteValue", Integer.TYPE, byte[].class);
        regDeleteKey = WinRegistry.getMethod("WindowsRegDeleteKey", Integer.TYPE, byte[].class);
        regCreateKeyEx = WinRegistry.getMethod("WindowsRegCreateKeyEx", Integer.TYPE, byte[].class);
    }

    public static boolean isAvailable() {
        return initError == null;
    }

    public static String readValue(String keyName, String valueName) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Key key = Key.open(keyName, 131097);){
            return WinRegistry.fromByteArray((byte[])WinRegistry.invoke(regQueryValueEx, key.handle, WinRegistry.toByteArray(valueName)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Map<String, String> readValues(String keyName) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Key key = Key.open(keyName, 131097);){
            int[] info = (int[])WinRegistry.invoke(regQueryInfoKey, key.handle);
            WinRegistry.checkError(info[1]);
            int count = info[2];
            int maxlen = info[4] + 1;
            HashMap<String, String> values = new HashMap<String, String>();
            int i2 = 0;
            while (i2 < count) {
                String valueName = WinRegistry.fromByteArray((byte[])WinRegistry.invoke(regEnumValue, key.handle, i2, maxlen));
                values.put(valueName, WinRegistry.readValue(keyName, valueName));
                ++i2;
            }
            return values;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static List<String> readSubkeys(String keyName) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Key key = Key.open(keyName, 131097);){
            int[] info = (int[])WinRegistry.invoke(regQueryInfoKey, key.handle);
            WinRegistry.checkError(info[1]);
            int count = info[0];
            int maxlen = info[3] + 1;
            ArrayList<String> subkeys = new ArrayList<String>(count);
            int i2 = 0;
            while (i2 < count) {
                subkeys.add(WinRegistry.fromByteArray((byte[])WinRegistry.invoke(regEnumKeyEx, key.handle, i2, maxlen)));
                ++i2;
            }
            return subkeys;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void writeValue(String keyName, String valueName, String value) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Key key = Key.open(keyName, 131078);){
            WinRegistry.checkError((Integer)WinRegistry.invoke(regSetValueEx, key.handle, WinRegistry.toByteArray(valueName), WinRegistry.toByteArray(value)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void deleteValue(String keyName, String valueName) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Key key = Key.open(keyName, 131078);){
            WinRegistry.checkError((Integer)WinRegistry.invoke(regDeleteValue, key.handle, WinRegistry.toByteArray(valueName)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void deleteKey(String keyName) {
        WinRegistry.checkError((Integer)WinRegistry.invoke(regDeleteKey, WinRegistry.keyParts(keyName)));
    }

    public static void createKey(String keyName) {
        int[] info = (int[])WinRegistry.invoke(regCreateKeyEx, WinRegistry.keyParts(keyName));
        WinRegistry.checkError(info[1]);
        WinRegistry.invoke(regCloseKey, info[0]);
    }

    private WinRegistry() {
    }

    private static Object[] keyParts(String fullKeyName) {
        int x = fullKeyName.indexOf(92);
        String hiveName = x >= 0 ? fullKeyName.substring(0, x) : fullKeyName;
        String keyName = x >= 0 ? fullKeyName.substring(x + 1) : "";
        Integer hkey = hives.get(hiveName);
        if (hkey == null) {
            throw new RegError("Unknown registry hive: " + hiveName, null);
        }
        return new Object[]{hkey, WinRegistry.toByteArray(keyName)};
    }

    private static void checkError(int e2) {
        if (e2 == 0) {
            return;
        }
        throw new RegError(e2 == 2 ? "Key not found" : (e2 == 5 ? "Access denied" : "Error number " + e2), null);
    }

    private static Method getMethod(String methodName, Class<?> ... parameterTypes) {
        try {
            Method m2 = Preferences.systemRoot().getClass().getDeclaredMethod(methodName, parameterTypes);
            m2.setAccessible(true);
            return m2;
        }
        catch (Throwable t) {
            initError = t;
            return null;
        }
    }

    private static <T> T invoke(Method method, Object ... args) {
        if (initError != null) {
            throw new RegError("Registry methods are not available", initError);
        }
        try {
            return (T)method.invoke(null, args);
        }
        catch (Exception e2) {
            throw new RegError(null, e2);
        }
    }

    private static byte[] toByteArray(String str) {
        byte[] bytes = new byte[str.length() + 1];
        int i2 = 0;
        while (i2 < str.length()) {
            bytes[i2] = (byte)str.charAt(i2);
            ++i2;
        }
        return bytes;
    }

    private static String fromByteArray(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] chars = new char[bytes.length - 1];
        int i2 = 0;
        while (i2 < chars.length) {
            chars[i2] = (char)(bytes[i2] & 0xFF);
            ++i2;
        }
        return new String(chars);
    }

    private static class Key
    implements AutoCloseable {
        final int handle;

        private Key(int handle) {
            this.handle = handle;
        }

        static Key open(String keyName, int accessMode) {
            Object[] keyParts = WinRegistry.keyParts(keyName);
            int[] ret = (int[])WinRegistry.invoke(regOpenKey, new Object[]{keyParts[0], keyParts[1], accessMode});
            WinRegistry.checkError(ret[1]);
            return new Key(ret[0]);
        }

        @Override
        public void close() {
            WinRegistry.invoke(regCloseKey, new Object[]{this.handle});
        }
    }

    public static class RegError
    extends RuntimeException {
        public RegError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

