/*
 * Decompiled with CFR 0.152.
 */
package mslinks;

import io.ByteReader;
import io.ByteWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.UnsupportedCLSIDException;
import mslinks.data.ItemID;

public class LinkTargetIDList
extends LinkedList<ItemID>
implements Serializable {
    public LinkTargetIDList() {
    }

    public LinkTargetIDList(ByteReader data) throws IOException, ShellLinkException {
        int size = (int)data.read2bytes();
        int pos = data.getPosition();
        boolean binary = false;
        int s = (int)data.read2bytes();
        while (s != 0) {
            s -= 2;
            if (binary) {
                byte[] b2 = new byte[s];
                int i2 = 0;
                while (i2 < s) {
                    b2[i2] = (byte)data.read();
                    ++i2;
                }
                this.add(new ItemID(b2));
            } else {
                try {
                    this.add(new ItemID(data));
                }
                catch (UnsupportedCLSIDException e2) {
                    System.err.println("unsupported CLSID");
                    binary = true;
                }
            }
            s = (int)data.read2bytes();
        }
        pos = data.getPosition() - pos;
        if (pos != size) {
            throw new ShellLinkException();
        }
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        Object j22;
        int size = 2;
        byte[][] b2 = new byte[this.size()][];
        int i2 = 0;
        for (Object j22 : this) {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            ByteWriter w = new ByteWriter(ba);
            ((ItemID)j22).serialize(w);
            b2[i2++] = ba.toByteArray();
        }
        byte[][] byArrayArray = b2;
        int n2 = b2.length;
        int n3 = 0;
        while (n3 < n2) {
            j22 = byArrayArray[n3];
            size += ((Object)j22).length + 2;
            ++n3;
        }
        bw.write2bytes(size);
        byArrayArray = b2;
        n2 = b2.length;
        n3 = 0;
        while (n3 < n2) {
            j22 = byArrayArray[n3];
            bw.write2bytes(((Object)j22).length + 2);
            bw.writeBytes((byte[])j22);
            ++n3;
        }
        bw.write2bytes(0L);
    }

    public boolean isCorrect() {
        for (ItemID i2 : this) {
            if (i2.getType() != 0) continue;
            return false;
        }
        return true;
    }
}

