/*
 * Decompiled with CFR 0.152.
 */
package mslinks;

import io.ByteReader;
import io.ByteWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import mslinks.LinkInfo;
import mslinks.LinkTargetIDList;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.ShellLinkHeader;
import mslinks.data.CNRLink;
import mslinks.data.ItemID;
import mslinks.data.LinkFlags;
import mslinks.extra.ConsoleData;
import mslinks.extra.ConsoleFEData;
import mslinks.extra.EnvironmentVariable;
import mslinks.extra.Stub;
import mslinks.extra.Tracker;
import mslinks.extra.VistaIDList;

public class ShellLink {
    private static Map<String, String> env = System.getenv();
    private static HashMap<Integer, Class> extraTypes = new HashMap<Integer, Class>(){
        {
            this.put(-1610612734, ConsoleData.class);
            this.put(-1610612732, ConsoleFEData.class);
            this.put(-1610612733, Tracker.class);
            this.put(-1610612724, VistaIDList.class);
            this.put(-1610612735, EnvironmentVariable.class);
        }
    };
    private ShellLinkHeader header;
    private LinkTargetIDList idlist;
    private LinkInfo info;
    private String name;
    private String relativePath;
    private String workingDir;
    private String cmdArgs;
    private String iconLocation;
    private HashMap<Integer, Serializable> extra = new HashMap();
    private Path linkFileSource;

    private ShellLink() {
        this.header = new ShellLinkHeader();
        this.header.getLinkFlags().setIsUnicode();
    }

    public ShellLink(String file) throws IOException, ShellLinkException {
        this(Paths.get(file, new String[0]));
    }

    public ShellLink(File file) throws IOException, ShellLinkException {
        this(file.toPath());
    }

    public ShellLink(Path file) throws IOException, ShellLinkException {
        this(Files.newInputStream(file, new OpenOption[0]));
        this.linkFileSource = file.toAbsolutePath();
    }

    public ShellLink(InputStream in) throws IOException, ShellLinkException {
        this(new ByteReader(in));
        in.close();
    }

    private ShellLink(ByteReader data) throws ShellLinkException, IOException {
        int size;
        this.header = new ShellLinkHeader(data);
        LinkFlags lf = this.header.getLinkFlags();
        if (lf.hasLinkTargetIDList()) {
            this.idlist = new LinkTargetIDList(data);
        }
        if (lf.hasLinkInfo()) {
            this.info = new LinkInfo(data);
        }
        if (lf.hasName()) {
            this.name = data.readUnicodeString();
        }
        if (lf.hasRelativePath()) {
            this.relativePath = data.readUnicodeString();
        }
        if (lf.hasWorkingDir()) {
            this.workingDir = data.readUnicodeString();
        }
        if (lf.hasArguments()) {
            this.cmdArgs = data.readUnicodeString();
        }
        if (lf.hasIconLocation()) {
            this.iconLocation = data.readUnicodeString();
        }
        while ((size = (int)data.read4bytes()) >= 4) {
            int sign = (int)data.read4bytes();
            try {
                Class cl = extraTypes.get(sign);
                if (cl != null) {
                    this.extra.put(sign, (Serializable)cl.getConstructor(ByteReader.class, Integer.TYPE).newInstance(data, size));
                    continue;
                }
                this.extra.put(sign, new Stub(data, size, sign));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
                e2.printStackTrace();
            }
        }
    }

    private void serialize(OutputStream out) throws IOException {
        LinkFlags lf = this.header.getLinkFlags();
        ByteWriter bw = new ByteWriter(out);
        this.header.serialize(bw);
        if (lf.hasLinkTargetIDList()) {
            this.idlist.serialize(bw);
        }
        if (lf.hasLinkInfo()) {
            this.info.serialize(bw);
        }
        if (lf.hasName()) {
            bw.writeUnicodeString(this.name);
        }
        if (lf.hasRelativePath()) {
            bw.writeUnicodeString(this.relativePath);
        }
        if (lf.hasWorkingDir()) {
            bw.writeUnicodeString(this.workingDir);
        }
        if (lf.hasArguments()) {
            bw.writeUnicodeString(this.cmdArgs);
        }
        if (lf.hasIconLocation()) {
            bw.writeUnicodeString(this.iconLocation);
        }
        for (Serializable i2 : this.extra.values()) {
            i2.serialize(bw);
        }
        bw.write4bytes(0L);
        out.close();
    }

    public ShellLinkHeader getHeader() {
        return this.header;
    }

    public LinkInfo getLinkInfo() {
        return this.info;
    }

    public LinkInfo createLinkInfo() {
        this.info = new LinkInfo();
        this.header.getLinkFlags().setHasLinkInfo();
        return this.info;
    }

    public String getName() {
        return this.name;
    }

    public ShellLink setName(String s) {
        if (s == null) {
            this.header.getLinkFlags().clearHasName();
        } else {
            this.header.getLinkFlags().setHasName();
        }
        this.name = s;
        return this;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public ShellLink setRelativePath(String s) {
        if (s == null) {
            this.header.getLinkFlags().clearHasRelativePath();
        } else {
            this.header.getLinkFlags().setHasRelativePath();
            if (!s.startsWith(".")) {
                s = ".\\" + s;
            }
        }
        this.relativePath = s;
        return this;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public ShellLink setWorkingDir(String s) {
        if (s == null) {
            this.header.getLinkFlags().clearHasWorkingDir();
        } else {
            this.header.getLinkFlags().setHasWorkingDir();
            s = Paths.get(s, new String[0]).toAbsolutePath().normalize().toString();
        }
        this.workingDir = s;
        return this;
    }

    public String getCMDArgs() {
        return this.cmdArgs;
    }

    public ShellLink setCMDArgs(String s) {
        if (s == null) {
            this.header.getLinkFlags().clearHasArguments();
        } else {
            this.header.getLinkFlags().setHasArguments();
        }
        this.cmdArgs = s;
        return this;
    }

    public String getIconLocation() {
        return this.iconLocation;
    }

    public ShellLink setIconLocation(String s) {
        if (s == null) {
            this.header.getLinkFlags().clearHasIconLocation();
        } else {
            this.header.getLinkFlags().setHasIconLocation();
            String t = ShellLink.resolveEnvVariables(s);
            if (!Paths.get(t, new String[0]).isAbsolute()) {
                s = Paths.get(s, new String[0]).toAbsolutePath().toString();
            }
        }
        this.iconLocation = s;
        return this;
    }

    public ConsoleData getConsoleData() {
        ConsoleData cd = (ConsoleData)this.extra.get(-1610612734);
        if (cd == null) {
            cd = new ConsoleData();
            this.extra.put(-1610612734, cd);
        }
        return cd;
    }

    public String getLanguage() {
        ConsoleFEData cd = (ConsoleFEData)this.extra.get(-1610612732);
        if (cd == null) {
            cd = new ConsoleFEData();
            this.extra.put(-1610612732, cd);
        }
        return cd.getLanguage();
    }

    public ShellLink setLanguage(String s) {
        ConsoleFEData cd = (ConsoleFEData)this.extra.get(-1610612732);
        if (cd == null) {
            cd = new ConsoleFEData();
            this.extra.put(-1610612732, cd);
        }
        cd.setLanguage(s);
        return this;
    }

    public ShellLink saveTo(String path) throws IOException {
        Path target;
        this.linkFileSource = Paths.get(path, new String[0]).toAbsolutePath().normalize();
        if (Files.isDirectory(this.linkFileSource, new LinkOption[0])) {
            throw new IOException("path is directory!");
        }
        if (!this.header.getLinkFlags().hasRelativePath()) {
            target = Paths.get(this.resolveTarget(), new String[0]);
            Path origin = this.linkFileSource.getParent();
            if (target.getRoot().equals(origin.getRoot())) {
                this.setRelativePath(origin.relativize(target).toString());
            }
        }
        if (!this.header.getLinkFlags().hasWorkingDir() && !Files.isDirectory(target = Paths.get(this.resolveTarget(), new String[0]), new LinkOption[0])) {
            this.setWorkingDir(target.getParent().toString());
        }
        this.serialize(Files.newOutputStream(this.linkFileSource, new OpenOption[0]));
        return this;
    }

    public String resolveTarget() {
        if (this.header.getLinkFlags().hasLinkTargetIDList() && this.idlist != null && this.idlist.isCorrect()) {
            String path = "";
            for (ItemID i2 : this.idlist) {
                if (i2.getType() == 47) {
                    path = i2.getName();
                    continue;
                }
                if (i2.getType() == 49) {
                    path = String.valueOf(path) + i2.getName() + File.separator;
                    continue;
                }
                if (i2.getType() != 50) continue;
                path = String.valueOf(path) + i2.getName();
            }
            return path;
        }
        if (this.header.getLinkFlags().hasLinkInfo() && this.info != null) {
            CNRLink l2 = this.info.getCommonNetworkRelativeLink();
            String cps = this.info.getCommonPathSuffix();
            String lbp = this.info.getLocalBasePath();
            if (lbp != null) {
                String path = lbp;
                if (cps != null && !cps.equals("")) {
                    if (path.charAt(path.length() - 1) != File.separatorChar) {
                        path = String.valueOf(path) + File.separatorChar;
                    }
                    path = String.valueOf(path) + cps;
                }
                return path;
            }
            if (l2 != null && cps != null) {
                return String.valueOf(l2.getNetName()) + File.separator + cps;
            }
        }
        if (this.linkFileSource != null && this.header.getLinkFlags().hasRelativePath() && this.relativePath != null) {
            return this.linkFileSource.resolveSibling(this.relativePath).normalize().toString();
        }
        return "<unknown>";
    }

    public static ShellLink createLink(String target) {
        ShellLink sl = new ShellLink();
        target = ShellLink.resolveEnvVariables(target);
        Path tar = Paths.get(target, new String[0]).toAbsolutePath();
        if ((target = tar.toString()).startsWith("\\\\")) {
            int p1 = target.indexOf(92, 2);
            int p2 = target.indexOf(92, p1 + 1);
            LinkInfo inf = sl.createLinkInfo();
            inf.createCommonNetworkRelativeLink().setNetName(target.substring(0, p2));
            inf.setCommonPathSuffix(target.substring(p2 + 1));
            if (Files.isDirectory(Paths.get(target, new String[0]), new LinkOption[0])) {
                sl.header.getFileAttributesFlags().setDirecory();
            }
            sl.header.getLinkFlags().setHasExpString();
            sl.extra.put(-1610612735, new EnvironmentVariable().setVariable(target));
        } else {
            try {
                sl.header.getLinkFlags().setHasLinkTargetIDList();
                sl.idlist = new LinkTargetIDList();
                String[] path = target.split("\\\\");
                sl.idlist.add(new ItemID().setType(31));
                sl.idlist.add(new ItemID().setType(47).setName(path[0]));
                int i2 = 1;
                while (i2 < path.length) {
                    sl.idlist.add(new ItemID().setType(49).setName(path[i2]));
                    ++i2;
                }
                LinkInfo inf = sl.createLinkInfo();
                inf.createVolumeID().setDriveType(3);
                inf.setLocalBasePath(target);
                if (Files.isDirectory(tar, new LinkOption[0])) {
                    sl.header.getFileAttributesFlags().setDirecory();
                } else {
                    ((ItemID)sl.idlist.getLast()).setType(50);
                }
            }
            catch (ShellLinkException shellLinkException) {
                // empty catch block
            }
        }
        return sl;
    }

    public static ShellLink createLink(String target, String linkpath) throws IOException {
        return ShellLink.createLink(target).saveTo(linkpath);
    }

    private static String resolveEnvVariables(String path) {
        for (String i2 : env.keySet()) {
            String p2 = i2.replace("(", "\\(").replace(")", "\\)");
            String r2 = env.get(i2).replace("\\", "\\\\");
            path = Pattern.compile("%" + p2 + "%", 2).matcher(path).replaceAll(r2);
        }
        return path;
    }
}

