/*
 * Decompiled with CFR 0.152.
 */
package mslinks;

import io.ByteReader;
import io.ByteWriter;
import java.io.IOException;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.data.FileAttributesFlags;
import mslinks.data.Filetime;
import mslinks.data.GUID;
import mslinks.data.HotKeyFlags;
import mslinks.data.LinkFlags;

public class ShellLinkHeader
implements Serializable {
    private static int headerSize = 76;
    private static GUID clsid = new GUID("00021401-0000-0000-C000-000000000046");
    public static final int SW_SHOWNORMAL = 1;
    public static final int SW_SHOWMAXIMIZED = 3;
    public static final int SW_SHOWMINNOACTIVE = 7;
    private LinkFlags lf;
    private FileAttributesFlags faf;
    private Filetime creationTime;
    private Filetime accessTime;
    private Filetime writeTime;
    private int fileSize;
    private int iconIndex;
    private int showCommand;
    private HotKeyFlags hkf;

    public ShellLinkHeader() {
        this.lf = new LinkFlags(0);
        this.faf = new FileAttributesFlags(0);
        this.creationTime = new Filetime();
        this.accessTime = new Filetime();
        this.writeTime = new Filetime();
        this.showCommand = 1;
        this.hkf = new HotKeyFlags();
    }

    public ShellLinkHeader(ByteReader data) throws ShellLinkException, IOException {
        int size = (int)data.read4bytes();
        if (size != headerSize) {
            throw new ShellLinkException();
        }
        GUID g2 = new GUID(data);
        if (!g2.equals(clsid)) {
            throw new ShellLinkException();
        }
        this.lf = new LinkFlags(data);
        this.faf = new FileAttributesFlags(data);
        this.creationTime = new Filetime(data);
        this.accessTime = new Filetime(data);
        this.writeTime = new Filetime(data);
        this.fileSize = (int)data.read4bytes();
        this.iconIndex = (int)data.read4bytes();
        this.showCommand = (int)data.read4bytes();
        if (this.showCommand != 1 && this.showCommand != 3 && this.showCommand != 7) {
            throw new ShellLinkException();
        }
        this.hkf = new HotKeyFlags(data);
        data.read2bytes();
        data.read8bytes();
    }

    public LinkFlags getLinkFlags() {
        return this.lf;
    }

    public FileAttributesFlags getFileAttributesFlags() {
        return this.faf;
    }

    public Filetime getCreationTime() {
        return this.creationTime;
    }

    public Filetime getAccessTime() {
        return this.accessTime;
    }

    public Filetime getWriteTime() {
        return this.writeTime;
    }

    public HotKeyFlags getHotKeyFlags() {
        return this.hkf;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public ShellLinkHeader setFileSize(long n2) {
        this.fileSize = (int)n2;
        return this;
    }

    public int getIconIndex() {
        return this.iconIndex;
    }

    public ShellLinkHeader setIconIndex(int n2) {
        this.iconIndex = n2;
        return this;
    }

    public int getShowCommand() {
        return this.showCommand;
    }

    public ShellLinkHeader setShowCommand(int n2) throws ShellLinkException {
        if (n2 == 1 || n2 == 3 || n2 == 7) {
            this.showCommand = n2;
            return this;
        }
        throw new ShellLinkException();
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        bw.write4bytes(headerSize);
        clsid.serialize(bw);
        this.lf.serialize(bw);
        this.faf.serialize(bw);
        this.creationTime.serialize(bw);
        this.accessTime.serialize(bw);
        this.writeTime.serialize(bw);
        bw.write4bytes(this.fileSize);
        bw.write4bytes(this.iconIndex);
        bw.write4bytes(this.showCommand);
        this.hkf.serialize(bw);
        bw.write2bytes(0L);
        bw.write8bytes(0L);
    }
}

