/*
 * Decompiled with CFR 0.152.
 */
package mslinks.data;

import io.ByteReader;
import io.ByteWriter;
import io.Bytes;
import java.io.IOException;
import java.util.Random;
import mslinks.Serializable;

public class GUID
implements Serializable {
    private static Random r = new Random();
    private int d1;
    private short d2;
    private short d3;
    private short d4;
    private long d5;

    public GUID() {
        this.d1 = r.nextInt();
        this.d2 = (short)r.nextInt();
        this.d3 = (short)r.nextInt();
        this.d4 = (short)r.nextInt();
        this.d5 = r.nextLong() & 0xFFFFFFFFFFFFL;
    }

    public GUID(byte[] d2) {
        this.d1 = Bytes.makeIntL(d2[0], d2[1], d2[2], d2[3]);
        this.d2 = Bytes.makeShortL(d2[4], d2[5]);
        this.d3 = Bytes.makeShortL(d2[6], d2[7]);
        this.d4 = Bytes.makeShortB(d2[8], d2[9]);
        this.d5 = Bytes.makeLongB((byte)0, (byte)0, d2[10], d2[11], d2[12], d2[13], d2[14], d2[15]);
    }

    public GUID(ByteReader data) throws IOException {
        this.d1 = (int)data.read4bytes();
        this.d2 = (short)data.read2bytes();
        this.d3 = (short)data.read2bytes();
        data.changeEndiannes();
        this.d4 = (short)data.read2bytes();
        this.d5 = data.read6bytes();
        data.changeEndiannes();
    }

    public GUID(String s) {
        if (s.charAt(0) == '{' && s.charAt(s.length() - 1) == '}') {
            s = s.substring(1, s.length() - 1);
        }
        String[] p2 = s.split("-");
        byte[] b2 = this.parse(p2[0]);
        this.d1 = Bytes.makeIntB(b2[0], b2[1], b2[2], b2[3]);
        b2 = this.parse(p2[1]);
        this.d2 = Bytes.makeShortB(b2[0], b2[1]);
        b2 = this.parse(p2[2]);
        this.d3 = Bytes.makeShortB(b2[0], b2[1]);
        this.d4 = (short)Long.parseLong(p2[3], 16);
        this.d5 = Long.parseLong(p2[4], 16);
    }

    private byte[] parse(String s) {
        byte[] b2 = new byte[s.length() >> 1];
        int i2 = 0;
        int j2 = 0;
        while (j2 < s.length()) {
            b2[i2] = (byte)Long.parseLong(s.substring(j2, j2 + 2), 16);
            ++i2;
            j2 += 2;
        }
        return b2;
    }

    public String toString() {
        return String.format("%08X-%04X-%04X-%04X-%012X", this.d1, this.d2, this.d3, this.d4, this.d5);
    }

    public boolean equals(Object o2) {
        GUID g2 = (GUID)o2;
        return this.d1 == g2.d1 && this.d2 == g2.d2 && this.d3 == g2.d3 && this.d4 == g2.d4 && this.d5 == g2.d5;
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        bw.write4bytes(this.d1);
        bw.write2bytes(this.d2);
        bw.write2bytes(this.d3);
        bw.changeEndiannes();
        bw.write2bytes(this.d4);
        bw.write6bytes(this.d5);
        bw.changeEndiannes();
    }
}

