/*
 * Decompiled with CFR 0.152.
 */
package mslinks.data;

import io.ByteReader;
import io.ByteWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import mslinks.Serializable;
import mslinks.ShellLinkException;

public class VolumeID
implements Serializable {
    public static final int DRIVE_UNKNOWN = 0;
    public static final int DRIVE_NO_ROOT_DIR = 1;
    public static final int DRIVE_REMOVABLE = 2;
    public static final int DRIVE_FIXED = 3;
    public static final int DRIVE_REMOTE = 4;
    public static final int DRIVE_CDROM = 5;
    public static final int DRIVE_RAMDISK = 6;
    private int dt;
    private int dsn;
    private String label;

    public VolumeID() {
        this.dt = 0;
        this.dsn = (int)(Math.random() * 9.223372036854776E18);
        this.label = "";
    }

    public VolumeID(ByteReader data) throws ShellLinkException, IOException {
        int pos = data.getPosition();
        int size = (int)data.read4bytes();
        if (size <= 16) {
            throw new ShellLinkException();
        }
        this.dt = (int)data.read4bytes();
        if (this.dt != 1 && this.dt != 2 && this.dt != 3 && this.dt != 4 && this.dt != 5 && this.dt != 6) {
            this.dt = 0;
        }
        this.dsn = (int)data.read4bytes();
        int vloffset = (int)data.read4bytes();
        boolean u = false;
        if (vloffset == 20) {
            vloffset = (int)data.read4bytes();
            u = true;
        }
        data.seek(pos + vloffset - data.getPosition());
        int i2 = 0;
        if (u) {
            char c2;
            char[] buf = new char[size - vloffset >> 1];
            while ((c2 = (char)data.read2bytes()) != '\u0000') {
                buf[i2] = c2;
                ++i2;
            }
            this.label = new String(buf, 0, i2);
        } else {
            int b2;
            byte[] buf = new byte[size - vloffset];
            while ((b2 = data.read()) != 0) {
                buf[i2] = (byte)b2;
                ++i2;
            }
            this.label = new String(buf, 0, i2);
        }
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        int size = 16;
        byte[] label_b = this.label.getBytes();
        size += label_b.length + 1;
        boolean u = false;
        if (!Charset.defaultCharset().newEncoder().canEncode(this.label)) {
            size += 5 + this.label.length() * 2 + 2;
            u = true;
        }
        bw.write4bytes(size);
        bw.write4bytes(this.dt);
        bw.write4bytes(this.dsn);
        int off = 16;
        if (u) {
            off += 4;
        }
        bw.write4bytes(off);
        off += label_b.length + 1;
        if (u) {
            bw.write4bytes(++off);
            off += this.label.length() * 2 + 2;
        }
        bw.writeBytes(label_b);
        bw.write(0);
        if (u) {
            bw.write(0);
            int i2 = 0;
            while (i2 < this.label.length()) {
                bw.write2bytes(this.label.charAt(i2));
                ++i2;
            }
            bw.write2bytes(0L);
        }
    }

    public int getDriveType() {
        return this.dt;
    }

    public VolumeID setDriveType(int n2) throws ShellLinkException {
        if (n2 == 0 || n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4 || n2 == 5 || n2 == 6) {
            this.dt = n2;
            return this;
        }
        throw new ShellLinkException("incorrect drive type");
    }

    public int getSerialNumber() {
        return this.dsn;
    }

    public VolumeID setSerialNumber(int n2) {
        this.dsn = n2;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public VolumeID setLabel(String s) {
        if (s != null) {
            this.label = s;
        }
        return this;
    }
}

