/*
 * Decompiled with CFR 0.152.
 */
package mslinks.extra;

import io.ByteReader;
import io.ByteWriter;
import java.io.IOException;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.data.ConsoleFlags;
import mslinks.data.Size;

public class ConsoleData
implements Serializable {
    public static final int signature = -1610612734;
    public static final int size = 204;
    private ConsoleFlags flags = new ConsoleFlags(0);
    private int textFG;
    private int textBG;
    private int popupFG;
    private int popupBG;
    private Size buffer;
    private Size window;
    private Size windowpos;
    private int fontsize;
    private Font font;
    private CursorSize cursize;
    private int historysize;
    private int historybuffers;
    private int[] colors = new int[16];

    public static int rgb(int r2, int g2, int b2) {
        return r2 & 0xFF | (g2 & 0xFF) << 8 | (b2 & 0xFF) << 16;
    }

    public static int r(int rgb) {
        return rgb & 0xFF;
    }

    public static int g(int rgb) {
        return (rgb & 0xFF00) >> 8;
    }

    public static int b(int rgb) {
        return (rgb & 0xFF0000) >> 16;
    }

    public ConsoleData() {
        this.textFG = 7;
        this.textBG = 0;
        this.popupFG = 5;
        this.popupBG = 15;
        this.buffer = new Size(80, 300);
        this.window = new Size(80, 25);
        this.windowpos = new Size();
        this.fontsize = 14;
        this.font = Font.Terminal;
        this.cursize = CursorSize.Small;
        this.historysize = 50;
        this.historybuffers = 4;
        this.flags.setInsertMode();
        this.flags.setAutoPosition();
        int i2 = 0;
        this.colors[i2++] = ConsoleData.rgb(0, 0, 0);
        this.colors[i2++] = ConsoleData.rgb(0, 0, 128);
        this.colors[i2++] = ConsoleData.rgb(0, 128, 0);
        this.colors[i2++] = ConsoleData.rgb(0, 128, 128);
        this.colors[i2++] = ConsoleData.rgb(128, 0, 0);
        this.colors[i2++] = ConsoleData.rgb(128, 0, 128);
        this.colors[i2++] = ConsoleData.rgb(128, 128, 0);
        this.colors[i2++] = ConsoleData.rgb(192, 192, 192);
        this.colors[i2++] = ConsoleData.rgb(128, 128, 128);
        this.colors[i2++] = ConsoleData.rgb(0, 0, 255);
        this.colors[i2++] = ConsoleData.rgb(0, 255, 0);
        this.colors[i2++] = ConsoleData.rgb(0, 255, 255);
        this.colors[i2++] = ConsoleData.rgb(255, 0, 0);
        this.colors[i2++] = ConsoleData.rgb(255, 0, 255);
        this.colors[i2++] = ConsoleData.rgb(255, 255, 0);
        this.colors[i2++] = ConsoleData.rgb(255, 255, 255);
    }

    public ConsoleData(ByteReader br, int sz) throws ShellLinkException, IOException {
        if (sz != 204) {
            throw new ShellLinkException();
        }
        int t = (int)br.read2bytes();
        this.textFG = t & 0xF;
        this.textBG = t & 0xF0;
        t = (int)br.read2bytes();
        this.popupFG = t & 0xF;
        this.popupBG = t & 0xF0;
        this.buffer = new Size((int)br.read2bytes(), (int)br.read2bytes());
        this.window = new Size((int)br.read2bytes(), (int)br.read2bytes());
        this.windowpos = new Size((int)br.read2bytes(), (int)br.read2bytes());
        br.read8bytes();
        this.fontsize = (int)br.read4bytes() >>> 16;
        br.read4bytes();
        if ((int)br.read4bytes() >= 700) {
            this.flags.setBoldFont();
        }
        switch ((char)br.read()) {
            case 'T': {
                this.font = Font.Terminal;
                break;
            }
            case 'L': {
                this.font = Font.LucidaConsole;
                break;
            }
            case 'C': {
                this.font = Font.Consolas;
            }
        }
        br.seek(63);
        t = (int)br.read4bytes();
        this.cursize = t <= 25 ? CursorSize.Small : (t <= 50 ? CursorSize.Medium : CursorSize.Large);
        if ((int)br.read4bytes() != 0) {
            this.flags.setFullscreen();
        }
        if ((int)br.read4bytes() != 0) {
            this.flags.setQuickEdit();
        }
        if ((int)br.read4bytes() != 0) {
            this.flags.setInsertMode();
        }
        if ((int)br.read4bytes() != 0) {
            this.flags.setAutoPosition();
        }
        this.historysize = (int)br.read4bytes();
        this.historybuffers = (int)br.read4bytes();
        if ((int)br.read4bytes() != 0) {
            this.flags.setHistoryDup();
        }
        int i2 = 0;
        while (i2 < 16) {
            this.colors[i2] = (int)br.read4bytes();
            ++i2;
        }
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        bw.write4bytes(204L);
        bw.write4bytes(-1610612734L);
        bw.write2bytes(this.textFG | this.textBG << 4);
        bw.write2bytes(this.popupFG | this.popupBG << 4);
        this.buffer.serialize(bw);
        this.window.serialize(bw);
        this.windowpos.serialize(bw);
        bw.write8bytes(0L);
        bw.write4bytes(this.fontsize << 16);
        bw.write4bytes(this.font == Font.Terminal ? 48 : 54);
        bw.write4bytes(this.flags.isBoldFont() ? 700 : 0);
        String fn = "";
        switch (this.font) {
            case Terminal: {
                fn = "Terminal";
                break;
            }
            case LucidaConsole: {
                fn = "Lucida Console";
                break;
            }
            case Consolas: {
                fn = "Consolas";
            }
        }
        bw.writeUnicodeString(fn, true);
        int i2 = fn.length() + 1;
        while (i2 < 32) {
            bw.write2bytes(0L);
            ++i2;
        }
        switch (this.cursize) {
            case Small: {
                bw.write4bytes(0L);
                break;
            }
            case Medium: {
                bw.write4bytes(26L);
                break;
            }
            case Large: {
                bw.write4bytes(51L);
            }
        }
        bw.write4bytes(this.flags.isFullscreen() ? 1 : 0);
        bw.write4bytes(this.flags.isQuickEdit() ? 1 : 0);
        bw.write4bytes(this.flags.isInsertMode() ? 1 : 0);
        bw.write4bytes(this.flags.isAutoPosition() ? 1 : 0);
        bw.write4bytes(this.historysize);
        bw.write4bytes(this.historybuffers);
        bw.write4bytes(this.flags.isHistoryDup() ? 1 : 0);
        i2 = 0;
        while (i2 < 16) {
            bw.write4bytes(this.colors[i2]);
            ++i2;
        }
    }

    public int[] getColorTable() {
        return this.colors;
    }

    public int getTextColor() {
        return this.textFG;
    }

    public ConsoleData setTextColor(int n2) {
        this.textFG = n2;
        return this;
    }

    public int getTextBackground() {
        return this.textBG;
    }

    public ConsoleData setTextBackground(int n2) {
        this.textBG = n2;
        return this;
    }

    public int getPopupTextColor() {
        return this.popupFG;
    }

    public ConsoleData setPopupTextColor(int n2) {
        this.popupFG = n2;
        return this;
    }

    public int getPopupTextBackground() {
        return this.popupBG;
    }

    public ConsoleData setPopupTextBackground(int n2) {
        this.popupBG = n2;
        return this;
    }

    public Size getBufferSize() {
        return this.buffer;
    }

    public Size getWindowSize() {
        return this.window;
    }

    public Size getWindowPos() {
        return this.windowpos;
    }

    public ConsoleFlags getConsoleFlags() {
        return this.flags;
    }

    public int getFontSize() {
        return this.fontsize;
    }

    public ConsoleData setFontSize(int n2) {
        this.fontsize = n2;
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    public ConsoleData setFont(Font f2) {
        this.font = f2;
        return this;
    }

    public CursorSize getCursorSize() {
        return this.cursize;
    }

    public ConsoleData setCursorSize(CursorSize cs) {
        this.cursize = cs;
        return this;
    }

    public int getHistorySize() {
        return this.historysize;
    }

    public ConsoleData setHistorySize(int n2) {
        this.historysize = n2;
        return this;
    }

    public int getHistoryBuffers() {
        return this.historybuffers;
    }

    public ConsoleData setHistoryBuffers(int n2) {
        this.historybuffers = n2;
        return this;
    }

    public static enum CursorSize {
        Small,
        Medium,
        Large;

    }

    public static enum Font {
        Terminal,
        LucidaConsole,
        Consolas;

    }
}

