/*
 * Decompiled with CFR 0.152.
 */
package io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;

public class ByteWriter
extends OutputStream {
    private static boolean le = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
    private OutputStream stream;
    private int pos = 0;

    public ByteWriter(OutputStream out) {
        this.stream = out;
    }

    public int getPosition() {
        return this.pos;
    }

    public ByteWriter changeEndiannes() {
        le = !le;
        return this;
    }

    @Override
    public void write(int b2) throws IOException {
        ++this.pos;
        this.stream.write(b2);
    }

    public void write(long b2) throws IOException {
        this.write((int)b2);
    }

    public void write2bytes(long n2) throws IOException {
        long b0 = n2 & 0xFFL;
        long b1 = (n2 & 0xFF00L) >> 8;
        if (le) {
            this.write(b0);
            this.write(b1);
        } else {
            this.write(b1);
            this.write(b0);
        }
    }

    public void write3bytes(long n2) throws IOException {
        long b0 = n2 & 0xFFL;
        long b1 = (n2 & 0xFF00L) >> 8;
        long b2 = (n2 & 0xFF0000L) >> 16;
        if (le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
        } else {
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void write4bytes(long n2) throws IOException {
        long b0 = n2 & 0xFFL;
        long b1 = (n2 & 0xFF00L) >> 8;
        long b2 = (n2 & 0xFF0000L) >> 16;
        long b3 = (n2 & 0xFFFFFFFFFF000000L) >>> 24;
        if (le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
            this.write(b3);
        } else {
            this.write(b3);
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void write5bytes(long n2) throws IOException {
        long b0 = n2 & 0xFFL;
        long b1 = (n2 & 0xFF00L) >> 8;
        long b2 = (n2 & 0xFF0000L) >> 16;
        long b3 = (n2 & 0xFFFFFFFFFF000000L) >>> 24;
        long b4 = (n2 & 0xFF00000000L) >> 32;
        if (le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
            this.write(b3);
            this.write(b4);
        } else {
            this.write(b4);
            this.write(b3);
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void write6bytes(long n2) throws IOException {
        long b0 = n2 & 0xFFL;
        long b1 = (n2 & 0xFF00L) >> 8;
        long b2 = (n2 & 0xFF0000L) >> 16;
        long b3 = (n2 & 0xFFFFFFFFFF000000L) >>> 24;
        long b4 = (n2 & 0xFF00000000L) >> 32;
        long b5 = (n2 & 0xFF0000000000L) >> 40;
        if (le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
            this.write(b3);
            this.write(b4);
            this.write(b5);
        } else {
            this.write(b5);
            this.write(b4);
            this.write(b3);
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void write7bytes(long n2) throws IOException {
        long b0 = n2 & 0xFFL;
        long b1 = (n2 & 0xFF00L) >> 8;
        long b2 = (n2 & 0xFF0000L) >> 16;
        long b3 = (n2 & 0xFFFFFFFFFF000000L) >>> 24;
        long b4 = (n2 & 0xFF00000000L) >> 32;
        long b5 = (n2 & 0xFF0000000000L) >> 40;
        long b6 = (n2 & 0xFF000000000000L) >> 48;
        if (le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
            this.write(b3);
            this.write(b4);
            this.write(b5);
            this.write(b6);
        } else {
            this.write(b6);
            this.write(b5);
            this.write(b4);
            this.write(b3);
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void write8bytes(long n2) throws IOException {
        long b0 = n2 & 0xFFL;
        long b1 = (n2 & 0xFF00L) >> 8;
        long b2 = (n2 & 0xFF0000L) >> 16;
        long b3 = (n2 & 0xFFFFFFFFFF000000L) >>> 24;
        long b4 = (n2 & 0xFF00000000L) >> 32;
        long b5 = (n2 & 0xFF0000000000L) >> 40;
        long b6 = (n2 & 0xFF000000000000L) >> 48;
        long b7 = (n2 & 0xFF00000000000000L) >>> 56;
        if (le) {
            this.write(b0);
            this.write(b1);
            this.write(b2);
            this.write(b3);
            this.write(b4);
            this.write(b5);
            this.write(b6);
            this.write(b7);
        } else {
            this.write(b7);
            this.write(b6);
            this.write(b5);
            this.write(b4);
            this.write(b3);
            this.write(b2);
            this.write(b1);
            this.write(b0);
        }
    }

    public void writeBytes(byte[] b2) throws IOException {
        byte[] byArray = b2;
        int n2 = b2.length;
        int n3 = 0;
        while (n3 < n2) {
            byte i2 = byArray[n3];
            this.write(i2);
            ++n3;
        }
    }

    public void writeUnicodeString(String s) throws IOException {
        this.writeUnicodeString(s, false);
    }

    public void writeUnicodeString(String s, boolean nullterm) throws IOException {
        if (!nullterm) {
            this.write2bytes(s.length());
        }
        int i2 = 0;
        while (i2 < s.length()) {
            this.write2bytes(s.charAt(i2));
            ++i2;
        }
        if (nullterm) {
            this.write2bytes(0L);
        }
    }
}

