/*
 * Decompiled with CFR 0.152.
 */
package kr.co.soluwin.installer.data;

import com.sun.jna.Memory;
import com.sun.jna.platform.win32.VerRsrc;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import kr.co.soluwin.installer.Installer;
import kr.co.soluwin.installer.data.ProgramData;
import kr.co.soluwin.installer.resource.Strings;

public class Version
implements Comparable<Version> {
    private int major;
    private int minor;
    private int patch;
    private String patch_str = "";
    private boolean isNull = false;

    public Version() {
        this.patch_str = null;
        this.isNull = true;
    }

    public Version(String versionStr) {
        System.out.println(versionStr);
        try {
            versionStr = versionStr.replace("#", "").replace("/", "").trim();
            String[] splits = versionStr.split("\\.");
            this.major = Integer.parseInt(splits[0]);
            this.minor = Integer.parseInt(splits[1]);
            try {
                this.patch = Integer.parseInt(splits[2]);
                this.patch_str = "";
            }
            catch (Exception e2) {
                String[] splitPatch = splits[2].split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
                this.patch = Integer.parseInt(splitPatch[0]);
                this.patch_str = splitPatch[1].toLowerCase();
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    @Override
    public int compareTo(Version o2) {
        if (this.major != o2.major) {
            return this.major > o2.major ? 1 : -1;
        }
        if (this.minor != o2.minor) {
            return this.minor > o2.minor ? 1 : -1;
        }
        if (this.patch != o2.patch) {
            return this.patch > o2.patch ? 1 : -1;
        }
        if (this.patch_str != o2.patch_str) {
            return this.patch_str.compareTo(o2.patch_str);
        }
        return 0;
    }

    public String getCompareString(Version o2) {
        if (this.isNull()) {
            return "Install Please !";
        }
        if (o2.compareTo(this) == 1) {
            return "Update Please !";
        }
        return "Done";
    }

    public static Version getVersion(ProgramData programData) {
        try {
            if (programData.isBinder()) {
                if (Installer.isWindow) {
                    String filePath = String.valueOf(programData.getPath()) + File.separator + "mbook Binder.exe";
                    IntByReference dwDummy = new IntByReference();
                    dwDummy.setValue(0);
                    int versionlength = com.sun.jna.platform.win32.Version.INSTANCE.GetFileVersionInfoSize(filePath, dwDummy);
                    byte[] bufferarray = new byte[versionlength];
                    Memory lpData = new Memory(bufferarray.length);
                    PointerByReference lplpBuffer = new PointerByReference();
                    IntByReference puLen = new IntByReference();
                    boolean fileInfoResult = com.sun.jna.platform.win32.Version.INSTANCE.GetFileVersionInfo(filePath, 0, versionlength, lpData);
                    boolean verQueryVal = com.sun.jna.platform.win32.Version.INSTANCE.VerQueryValue(lpData, "\\", lplpBuffer, puLen);
                    VerRsrc.VS_FIXEDFILEINFO lplpBufStructure = new VerRsrc.VS_FIXEDFILEINFO(lplpBuffer.getValue());
                    lplpBufStructure.read();
                    int v1 = lplpBufStructure.dwFileVersionMS.intValue() >> 16;
                    int v2 = lplpBufStructure.dwFileVersionMS.intValue() & 0xFFFF;
                    int v3 = lplpBufStructure.dwFileVersionLS.intValue() >> 16;
                    return new Version(v1, v2, v3);
                }
                return Version.getBinderVersion(String.valueOf(programData.getPath()) + File.separator + "mbook Binder.jar");
            }
            return Version.getExtensionVersion(new FileInputStream(String.valueOf(programData.getPath()) + Strings.STR_ORIGINAL_PATH_EXTENSION_STARTUP + "MBook.jsx"));
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return new Version();
        }
    }

    public static Version getExtensionVersion(String resourceStr) {
        return Version.getExtensionVersion(Version.class.getResourceAsStream(resourceStr));
    }

    private static Version getExtensionVersion(InputStream inputStream) {
        Version version = null;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
                in.readLine();
                version = new Version(in.readLine());
            }
            catch (Exception exception) {
                try {
                    in.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
        return version;
    }

    public static Version getBinderVersion(String binderJarPath) {
        Version version = null;
        BufferedReader in = null;
        try {
            try {
                String JAVA_HOME = System.getProperty("java.home");
                ProcessBuilder pb = new ProcessBuilder("java", "-jar", binderJarPath, "-version");
                pb.directory(new File(JAVA_HOME));
                Process p2 = pb.start();
                in = new BufferedReader(new InputStreamReader(p2.getInputStream()));
                version = new Version(in.readLine());
                p2.waitFor();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                try {
                    in.close();
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
        }
        return version;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public String toString() {
        return this.patch_str == null ? "\uc815\ubcf4 \uc5c6\uc74c" : String.valueOf(this.major) + "." + this.minor + "." + this.patch + this.patch_str;
    }
}

