/*
 * Decompiled with CFR 0.152.
 */
package kr.co.soluwin.installer.model;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import kr.co.soluwin.installer.Installer;
import kr.co.soluwin.installer.data.IndesignVersion;
import kr.co.soluwin.installer.data.ProgramData;

public class ProgramTableModel
extends AbstractTableModel {
    private String[] tableColumn = new String[]{"", "Indesign Ver.", "path", "situation"};
    private ArrayList<ProgramData> aryProgramData = new ArrayList();

    @Override
    public Object getValueAt(int row, int col) {
        ProgramData programData = this.aryProgramData.get(row);
        switch (col) {
            case 0: {
                return programData.isWillSetup();
            }
            case 1: {
                return programData.getName();
            }
            case 2: {
                return programData.getPath();
            }
            case 3: {
                return programData.getVersion().getCompareString(Installer.EXTENSION_VERSION);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int row, int col) {
        ProgramData programData = this.aryProgramData.get(row);
        switch (col) {
            case 0: {
                programData.setWillSetup((Boolean)aValue);
                break;
            }
            case 1: {
                programData.setName((String)aValue);
                break;
            }
            case 2: {
                programData.setPath((String)aValue);
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: 
            case 2: 
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.aryProgramData.size();
    }

    public ProgramData getProgramDataByRow(int index) {
        return this.aryProgramData.get(index);
    }

    @Override
    public int getColumnCount() {
        return this.tableColumn.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.tableColumn[column];
    }

    public void addRow(ProgramData programData) {
        this.aryProgramData.add(programData);
        this.fireTableDataChanged();
    }

    public void removeRow(int index) {
        this.aryProgramData.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void detectDefaultData() {
        this.detectDefaultIndesignData();
    }

    private void detectDefaultBinderDate() {
        this.aryProgramData.add(ProgramData.getDefaultBinderData());
    }

    public void detectDefaultIndesignData() {
        IndesignVersion[] indesignVersionArray = IndesignVersion.values();
        int n2 = indesignVersionArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IndesignVersion indesignVersion = indesignVersionArray[n3];
            ProgramData programData = ProgramData.getDefaultIndesignData(indesignVersion);
            if (programData != null) {
                this.aryProgramData.add(programData);
            }
            ++n3;
        }
        this.fireTableDataChanged();
    }

    public void notifySetupStateChanged() {
        for (ProgramData programData : this.aryProgramData) {
            programData.checkSetupStateChanged();
        }
        this.fireTableDataChanged();
    }

    public ArrayList<ProgramData> getCheckData() {
        ArrayList<ProgramData> retAry = new ArrayList<ProgramData>();
        for (ProgramData programData : this.aryProgramData) {
            if (!programData.isWillSetup()) continue;
            retAry.add(programData);
        }
        return retAry;
    }
}

