/*
 * Decompiled with CFR 0.152.
 */
package kr.co.soluwin.installer.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kr.co.soluwin.installer.Installer;
import kr.co.soluwin.installer.data.ProgramData;
import kr.co.soluwin.installer.model.IndesignTableRenderer;
import kr.co.soluwin.installer.model.ProgramTableModel;
import kr.co.soluwin.installer.ui.DefaultPanel;
import kr.co.soluwin.installer.ui.ManagerFrame;

public class ExtensionInstallPanel
extends DefaultPanel {
    private JButton mBtnUpdateExtension;
    private JButton mBtnViewChangeLog;
    private JTable mTableIndesign;
    private ProgramTableModel programTableModel;
    private JButton mBtnAddProgramDir;
    private JFileChooser mFcAddIndesignDir;

    public ExtensionInstallPanel(ManagerFrame parentFrame) throws HeadlessException {
        super(parentFrame);
        this.initFrame();
    }

    private void initFrame() {
        this.setPreferredSize(new Dimension(680, 460));
        this.setSubTitle("\uc124\uce58\ud560 \uc778\ub514\uc790\uc778 \ubc84\uc804\uc744 \uc120\ud0dd\ud558\uc138\uc694.");
        this.setDesc("mbook " + Installer.EXTENSION_VERSION.toString() + "\uc744 \uc124\uce58\ud558\ub824\uace0 \ud569\ub2c8\ub2e4.\n" + "\uc124\uce58\ub97c \uc6d0\ud558\ub294 \uc778\ub514\uc790\uc778 \ubc84\uc804\uc744 \uc120\ud0dd\ud558\uc138\uc694.\n" + "\uc790\ub3d9 \ud0d0\uc0c9\ub418\uc9c0 \uc54a\uc740 \uc778\ub514\uc790\uc778\uc740 \"Add Indesign\"\ubc84\ud2bc\uc744 \ub20c\ub7ec\uc11c \ucd94\uac00\ud574 \uc8fc\uc138\uc694.");
        this.setLeftButton(DefaultPanel.ButtonType.PREVIOUS);
        this.setRightButton(DefaultPanel.ButtonType.NEXT);
        this.setSubButton(DefaultPanel.ButtonType.ADD_INDESIGN);
        this.mFcAddIndesignDir = new JFileChooser();
        if (Installer.isWindow) {
            this.mFcAddIndesignDir.setCurrentDirectory(new File(System.getenv("ProgramFiles")));
        }
        this.mFcAddIndesignDir.setFileSelectionMode(1);
        JScrollPane centerScrollPane = new JScrollPane();
        centerScrollPane.setBounds(12, 220, 656, 130);
        centerScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.programTableModel = new ProgramTableModel();
        this.programTableModel.detectDefaultData();
        IndesignTableRenderer indesignTableRenderer = new IndesignTableRenderer(this.programTableModel.getColumnCount());
        this.mTableIndesign = new JTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                if (ExtensionInstallPanel.this.programTableModel.getColumnName(column).equals("situation")) {
                    JComponent comp = (JComponent)super.prepareRenderer(renderer, row, column);
                    Font compFont = comp.getFont();
                    if (!ExtensionInstallPanel.this.programTableModel.getProgramDataByRow(row).getVersion().getCompareString(Installer.EXTENSION_VERSION).equals("Done")) {
                        comp.setFont(compFont.deriveFont(1, compFont.getSize()));
                        comp.setForeground(Color.decode("#6267a4"));
                    } else {
                        comp.setFont(compFont.deriveFont(0, compFont.getSize() + 1));
                    }
                    return comp;
                }
                return super.prepareRenderer(renderer, row, column);
            }
        };
        this.mTableIndesign.setRowHeight(25);
        this.mTableIndesign.getTableHeader().setPreferredSize(new Dimension(0, 25));
        this.mTableIndesign.setModel(this.programTableModel);
        this.mTableIndesign.setDefaultRenderer(String.class, indesignTableRenderer);
        this.mTableIndesign.setDefaultRenderer(Boolean.class, indesignTableRenderer);
        this.mTableIndesign.getTableHeader().setDefaultRenderer(indesignTableRenderer);
        this.mTableIndesign.getTableHeader().setReorderingAllowed(false);
        this.mTableIndesign.setBackground(Color.white);
        this.mTableIndesign.setGridColor(Color.decode("#E4E4E4"));
        this.mTableIndesign.setShowVerticalLines(false);
        this.mTableIndesign.setShowHorizontalLines(true);
        this.mTableIndesign.getColumn("").setMinWidth(30);
        this.mTableIndesign.getColumn("").setMaxWidth(30);
        this.mTableIndesign.getColumn("Indesign Ver.").setMinWidth(160);
        this.mTableIndesign.getColumn("Indesign Ver.").setMaxWidth(160);
        this.mTableIndesign.getColumn("situation").setMinWidth(110);
        this.mTableIndesign.getColumn("situation").setMaxWidth(110);
        this.mTableIndesign.setFillsViewportHeight(true);
        centerScrollPane.setViewportView(this.mTableIndesign);
        this.add(centerScrollPane);
    }

    @Override
    protected void subActionPerformed() {
        this.addIndesign();
    }

    private void addIndesign() {
        if (this.mFcAddIndesignDir.showOpenDialog(this) != 0) {
            return;
        }
        ProgramData transedData = ProgramData.transFileToProgamData(this.mFcAddIndesignDir.getSelectedFile());
        if (transedData != null) {
            this.programTableModel.addRow(transedData);
        } else {
            JOptionPane.showMessageDialog(null, String.valueOf(this.mFcAddIndesignDir.getSelectedFile().getPath()) + "\n\ud574\ub2f9 \ud3f4\ub354\uc548\uc5d0 \uc778\ub514\uc790\uc778 \uc2e4\ud589 \ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
    }

    public ArrayList<ProgramData> getCheckData() {
        return this.programTableModel.getCheckData();
    }
}

