/*
 * Decompiled with CFR 0.152.
 */
package kr.co.soluwin.installer.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import kr.co.soluwin.installer.Installer;
import kr.co.soluwin.installer.comp.SDProgressBarUI;
import kr.co.soluwin.installer.data.ProgramData;
import kr.co.soluwin.installer.ui.DefaultPanel;
import kr.co.soluwin.installer.ui.ManagerFrame;
import kr.co.soluwin.installer.util.FileUtil;
import kr.co.soluwin.installer.util.FontManager;

public class InstallPanel
extends DefaultPanel {
    private JTextPane mSetupTextPane;
    private boolean setupBinder = true;
    private boolean makeShortcut = false;
    private ArrayList<ProgramData> mAryExtensionInstall = new ArrayList();
    private JProgressBar mProgressBar;
    private Style styleSuccess;
    private Style styleFail;
    private int totalProgress = 0;

    public InstallPanel(ManagerFrame parentFrame) {
        super(parentFrame);
        this.initFrame();
    }

    private void initFrame() {
        this.setPreferredSize(new Dimension(680, 460));
        this.setSubTitle("\uc124\uce58\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4.");
        this.setDesc("mbook 2.0\uacfc mbook Binder \uc124\uce58\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4.\n\uc124\uce58\ub420 \ud504\ub85c\uadf8\ub7a8\uc740 \uc544\ub798\uc640 \uac19\uc2b5\ub2c8\ub2e4.");
        this.setLeftButton(DefaultPanel.ButtonType.NONE);
        this.setRightButton(DefaultPanel.ButtonType.NEXT);
        this.setSubButton(DefaultPanel.ButtonType.NONE);
        this.getRightButton().setEnabled(false);
        StyleContext context = new StyleContext();
        this.styleSuccess = context.addStyle("success", null);
        this.styleFail = context.addStyle("fail", null);
        StyleConstants.setForeground(this.styleSuccess, Color.decode("#6267a4"));
        StyleConstants.setForeground(this.styleFail, new Color(138, 8, 8));
        this.mSetupTextPane = new JTextPane(new DefaultStyledDocument());
        this.mSetupTextPane.setEditable(false);
        this.mSetupTextPane.setContentType("text/html");
        this.mSetupTextPane.setBackground(Color.WHITE);
        this.mSetupTextPane.setBounds(50, 192, 580, 125);
        this.mSetupTextPane.setFont(FontManager.Nanum.deriveFont(13.0f));
        this.mSetupTextPane.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.add(this.mSetupTextPane);
        this.setComponentZOrder(this.mSetupTextPane, 0);
        this.mProgressBar = new JProgressBar(0, 100);
        this.mProgressBar.setBackground(Color.WHITE);
        this.mProgressBar.setBounds(50, 327, 580, 20);
        this.mProgressBar.setUI(new SDProgressBarUI());
        this.add(this.mProgressBar);
        this.setComponentZOrder(this.mProgressBar, 0);
    }

    public void startInstall() {
        this.totalProgress += (this.setupBinder ? 1 : 0) + (this.makeShortcut ? 1 : 0) + this.mAryExtensionInstall.size();
        this.mProgressBar.setMaximum(this.totalProgress);
        InstallWorker installWorker = new InstallWorker();
        installWorker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("progress".equals(evt.getPropertyName())) {
                    InstallPanel.this.mProgressBar.setValue((Integer)evt.getNewValue());
                }
            }
        });
        installWorker.execute();
    }

    public void setBinderSetupOption(boolean setupBinder, boolean makeShortcut) {
        this.setupBinder = setupBinder;
        this.makeShortcut = makeShortcut;
    }

    public void setExtensionSetupAry(ArrayList<ProgramData> arrayList) {
        this.mAryExtensionInstall = arrayList;
    }

    private void appendSetupDesc(String str, Style style) {
        try {
            Document doc = this.mSetupTextPane.getDocument();
            doc.insertString(doc.getLength(), str, style);
        }
        catch (BadLocationException exc) {
            exc.printStackTrace();
        }
    }

    private void appendSetupSuccessDesc(String str) {
        this.appendSetupDesc(str, this.styleSuccess);
    }

    private void appendSetupDesc(String str) {
        this.appendSetupDesc(str, null);
    }

    private void appendSetupFailDesc(String str) {
        this.appendSetupDesc(str, this.styleFail);
    }

    class InstallWorker
    extends SwingWorker<Void, Void> {
        int progress = 0;

        InstallWorker() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            InstallPanel.this.appendSetupDesc(" \u25a0 mbook Binder : " + Installer.BINDER_VERSION);
            try {
                FileUtil.installBinderToDir(ProgramData.getDefaultBinderData());
                InstallPanel.this.appendSetupSuccessDesc(" - \uc124\uce58 \uc644\ub8cc\n");
            }
            catch (Exception e2) {
                e2.printStackTrace();
                InstallPanel.this.appendSetupFailDesc(" - \uc124\uce58 \uc2e4\ud328\n");
                InstallPanel.this.appendSetupDesc("    " + e2.getMessage() + "\n");
            }
            this.setProgress(++this.progress);
            if (InstallPanel.this.makeShortcut) {
                InstallPanel.this.appendSetupDesc("     - \ubc14\ud0d5\ud654\uba74\uc5d0 \ubc14\ub85c\uac00\uae30 \ub9cc\ub4e4\uae30");
                try {
                    FileUtil.installBinderShortcut();
                    InstallPanel.this.appendSetupSuccessDesc(" - \uc124\uce58 \uc644\ub8cc\n");
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                    InstallPanel.this.appendSetupFailDesc(" - \uc124\uce58 \uc2e4\ud328\n");
                    InstallPanel.this.appendSetupDesc("    " + e3.getMessage() + "\n");
                }
                this.setProgress(++this.progress);
            }
            InstallPanel.this.appendSetupDesc("\n");
            if (InstallPanel.this.mAryExtensionInstall.size() > 0) {
                InstallPanel.this.appendSetupDesc(" \u25a0 mbook Extension : " + Installer.EXTENSION_VERSION + "\n");
                for (ProgramData programData : InstallPanel.this.mAryExtensionInstall) {
                    InstallPanel.this.appendSetupDesc("     - " + programData.getPath());
                    try {
                        FileUtil.installExtensionToDir(programData);
                        InstallPanel.this.appendSetupSuccessDesc(" - \uc124\uce58 \uc644\ub8cc\n");
                    }
                    catch (Exception e4) {
                        e4.printStackTrace();
                        InstallPanel.this.appendSetupFailDesc(" - \uc124\uce58 \uc2e4\ud328\n");
                        InstallPanel.this.appendSetupDesc("    " + e4.getMessage() + "\n");
                    }
                    this.setProgress(++this.progress);
                }
            }
            return null;
        }

        @Override
        protected void process(List<Void> chunks) {
        }

        @Override
        protected void done() {
            InstallPanel.this.getRightButton().setEnabled(true);
        }
    }
}

