/*
 * Decompiled with CFR 0.152.
 */
package kr.co.soluwin.installer.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.codec.digest.DigestUtils;

public class Md5Util {
    public static String calcMD5HashForDir(File dirToHash, boolean includeHiddenFiles) {
        assert (dirToHash.isDirectory());
        Vector<FileInputStream> fileStreams = new Vector<FileInputStream>();
        System.out.println("Found files for hashing:");
        Md5Util.collectInputStreams(dirToHash, fileStreams, includeHiddenFiles);
        SequenceInputStream seqStream = new SequenceInputStream(fileStreams.elements());
        try {
            String md5Hash = DigestUtils.md5Hex(seqStream);
            seqStream.close();
            return md5Hash;
        }
        catch (IOException e2) {
            throw new RuntimeException("Error reading files to hash in " + dirToHash.getAbsolutePath(), e2);
        }
    }

    private static void collectInputStreams(File dir, List<FileInputStream> foundStreams, boolean includeHiddenFiles) {
        File[] fileList = dir.listFiles();
        Arrays.sort(fileList, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        File[] fileArray = fileList;
        int n2 = fileList.length;
        int n3 = 0;
        while (n3 < n2) {
            File f2 = fileArray[n3];
            if (includeHiddenFiles || !f2.getName().startsWith(".")) {
                if (f2.isDirectory()) {
                    Md5Util.collectInputStreams(f2, foundStreams, includeHiddenFiles);
                } else {
                    try {
                        System.out.println("\t" + f2.getAbsolutePath());
                        foundStreams.add(new FileInputStream(f2));
                    }
                    catch (FileNotFoundException e2) {
                        throw new AssertionError((Object)(String.valueOf(e2.getMessage()) + ": file should never not be found!"));
                    }
                }
            }
            ++n3;
        }
    }
}

