/*
 * Decompiled with CFR 0.152.
 */
package mslinks.data;

import io.ByteReader;
import io.ByteWriter;
import java.io.IOException;
import java.util.regex.Pattern;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.UnsupportedCLSIDException;
import mslinks.data.GUID;

public class ItemID
implements Serializable {
    private static final GUID mycomputer = new GUID("20d04fe0-3aea-1069-a2d8-08002b30309d");
    private static byte[] ub1;
    private static byte[] ub2;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_FILE = 50;
    public static final int TYPE_DIRECTORY = 49;
    public static final int TYPE_DRIVE = 47;
    public static final int TYPE_CLSID = 31;
    private int type;
    private int size;
    private String shortname;
    private String longname;
    private GUID clsid;
    private byte[] data;

    static {
        byte[] byArray = new byte[6];
        byArray[0] = 8;
        byArray[2] = 4;
        byArray[4] = -17;
        byArray[5] = -66;
        ub1 = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[0] = 42;
        ub2 = byArray2;
    }

    public ItemID() {
        this.shortname = "";
        this.longname = "";
    }

    public ItemID(byte[] d2) {
        this.data = d2;
    }

    public ItemID(ByteReader br) throws IOException, ShellLinkException {
        int pos = br.getPosition();
        this.type = br.read();
        if (this.type == 47) {
            this.setName(br.readString(22));
            br.seek(pos + 23 - br.getPosition());
        } else if (this.type == 50 || this.type == 49) {
            br.read();
            this.size = (int)br.read4bytes();
            br.read4bytes();
            br.read2bytes();
            this.shortname = br.readString(13);
            if ((br.getPosition() - pos & 1) != 0) {
                br.read();
            }
            pos = br.getPosition();
            int sz = (int)br.read2bytes();
            br.read6bytes();
            br.read4bytes();
            br.read4bytes();
            br.seek(26);
            this.longname = br.readUnicodeString(sz - 44);
            br.seek(pos + sz - br.getPosition());
        } else if (this.type == 31) {
            br.read();
            this.clsid = new GUID(br);
            if (!this.clsid.equals(mycomputer)) {
                throw new UnsupportedCLSIDException();
            }
        } else {
            throw new ShellLinkException("unsupported ItemID type");
        }
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        if (this.data != null) {
            bw.writeBytes(this.data);
            return;
        }
        int pos = bw.getPosition();
        bw.write(this.type);
        int attr = 0;
        switch (this.type) {
            case 31: {
                bw.write(0);
                this.clsid.serialize(bw);
                return;
            }
            case 47: {
                byte[] b2 = this.getName().getBytes();
                bw.write(b2);
                int i2 = 0;
                while (i2 < 22 - b2.length) {
                    bw.write(0);
                    ++i2;
                }
                return;
            }
            case 49: {
                bw.write(0);
                bw.write4bytes(0L);
                attr = 16;
                break;
            }
            case 50: {
                bw.write(0);
                bw.write4bytes(this.size);
            }
        }
        bw.write4bytes(0L);
        bw.write2bytes(attr);
        bw.writeBytes(this.shortname.getBytes());
        bw.write(0);
        if ((bw.getPosition() - pos & 1) != 0) {
            bw.write(0);
        }
        bw.write2bytes(46 + this.longname.length() * 2);
        bw.writeBytes(ub1);
        bw.write4bytes(0L);
        bw.write4bytes(0L);
        bw.writeBytes(ub2);
        int i3 = 0;
        while (i3 < 22) {
            bw.write(0);
            ++i3;
        }
        bw.writeUnicodeString(this.longname, true);
        bw.write2bytes((this.shortname.length() & 0xFFFFFFFE) + 16);
    }

    public String getName() {
        if (this.longname != null && !this.longname.equals("")) {
            return this.longname;
        }
        return this.shortname;
    }

    public ItemID setName(String s) throws ShellLinkException {
        if (s == null) {
            return this;
        }
        if (this.type == 50 || this.type == 49) {
            String name;
            if (s.contains("\\")) {
                throw new ShellLinkException("wrong name");
            }
            this.longname = s;
            String ext = "";
            int dot = s.lastIndexOf(46);
            if (dot != -1) {
                name = s.substring(0, dot);
                ext = s.substring(name.length());
            } else {
                name = s;
            }
            if (name.length() > 8) {
                name = String.valueOf(name.substring(0, 6)) + "~1";
            }
            this.shortname = String.valueOf(name) + ext;
        }
        if (this.type == 47) {
            if (Pattern.matches("\\w+:\\\\", s)) {
                this.shortname = this.longname = s;
            } else if (Pattern.matches("\\w+:", s)) {
                this.shortname = this.longname = String.valueOf(s) + "\\";
            } else if (Pattern.matches("\\w+", s)) {
                this.shortname = this.longname = String.valueOf(s) + ":\\";
            } else {
                throw new ShellLinkException("wrong name");
            }
        }
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public ItemID setSize(int s) throws ShellLinkException {
        if (this.type != 50) {
            throw new ShellLinkException("only files has size");
        }
        this.size = s;
        return this;
    }

    public int getType() {
        return this.type;
    }

    public ItemID setType(int t) throws ShellLinkException {
        if (t == 31) {
            this.type = t;
            this.clsid = mycomputer;
            return this;
        }
        if (t == 50 || t == 49 || t == 47) {
            this.type = t;
            return this;
        }
        throw new ShellLinkException("wrong type");
    }
}

