/*
 * Decompiled with CFR 0.152.
 */
package mslinks.extra;

import io.ByteReader;
import io.ByteWriter;
import java.io.IOException;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.data.GUID;

public class Tracker
implements Serializable {
    public static final int signature = -1610612733;
    public static final int size = 96;
    private String netbios;
    private GUID d1;
    private GUID d2;
    private GUID db1;
    private GUID db2;

    public Tracker() {
        this.netbios = "localhost";
        this.d1 = this.db1 = new GUID();
        this.d2 = this.db2 = new GUID("539D9DC6-8293-11E3-8FB0-005056C00008");
    }

    public Tracker(ByteReader br, int sz) throws ShellLinkException, IOException {
        if (sz != 96) {
            throw new ShellLinkException();
        }
        int len = (int)br.read4bytes();
        if (len < 88) {
            throw new ShellLinkException();
        }
        br.read4bytes();
        int pos = br.getPosition();
        this.netbios = br.readString(16);
        br.seek(pos + 16 - br.getPosition());
        this.d1 = new GUID(br);
        this.d2 = new GUID(br);
        this.db1 = new GUID(br);
        this.db2 = new GUID(br);
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        bw.write4bytes(96L);
        bw.write4bytes(-1610612733L);
        bw.write4bytes(88L);
        bw.write4bytes(0L);
        byte[] b2 = this.netbios.getBytes();
        bw.writeBytes(b2);
        int i2 = 0;
        while (i2 < 16 - b2.length) {
            bw.write(0);
            ++i2;
        }
        this.d1.serialize(bw);
        this.d2.serialize(bw);
        this.db1.serialize(bw);
        this.db2.serialize(bw);
    }

    public String getNetbiosName() {
        return this.netbios;
    }

    public Tracker setNetbiosName(String s) throws ShellLinkException {
        if (s.length() > 16) {
            throw new ShellLinkException("netbios name length must be <= 16");
        }
        this.netbios = s;
        return this;
    }
}

